--
-- BuyableFergieWheelsAttacher
-- Specialization for Buyable Twin Wheels
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v3.0
-- @date  		30/10/12
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick
--				v3.0 - Added dynamic collision support, ls13-ready
--
-- free for noncommerical-usage
--

BuyableFergieWheelsAttacher = {};

function BuyableFergieWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableFergieWheelsAttacher:load(xmlFile)

	self.onAssemblingTwins = SpecializationUtil.callSpecializationsFunction("onAssemblingTwins");
	self.onDisassemblingTwins = SpecializationUtil.callSpecializationsFunction("onDisassemblingTwins");
	self.onAssemblingCage = SpecializationUtil.callSpecializationsFunction("onAssemblingCage");
	self.onDisassemblingCage = SpecializationUtil.callSpecializationsFunction("onDisassemblingCage");
	
	self.buyableTwinWheels = {};
	self.buyableTwinWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheelsCheckString"), "standard");
	self.buyableTwinWheels.twinWheels = nil;
	self.buyableTwinWheels.wheelsInRange = nil;	
	
	self.buyableCageWheels = {};
	self.buyableCageWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#cageWheelsCheckString"), self.buyableTwinWheels.checkString);
	self.buyableCageWheels.cageWheels = nil;
	self.buyableCageWheels.wheelsInRange = nil;

end;

function BuyableFergieWheelsAttacher:delete()
	if self.buyableTwinWheels.twinWheels ~= nil then
		self.buyableTwinWheels.twinWheels:disassembleTwinWheels(true);
	end;
	if self.buyableCageWheels.cageWheels ~= nil then
		self.buyableCageWheels.cageWheels:disassembleCageWheels(true);
	end;
end;

function BuyableFergieWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableFergieWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableFergieWheelsAttacher:update(dt)

	if self:getIsActive() and self.movingDirection == 0 then
		local wheels1 = self.buyableTwinWheels;
		local wheels2 = self.buyableCageWheels;
		if wheels1.wheelsInRange ~= nil and wheels2.cageWheels == nil then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_WHEELS_ATTACH) then
					if wheels1.twinWheels == nil then
						wheels1.wheelsInRange:assembleTwinWheels(self);
					else
						if wheels1.wheelsInRange.twinWheelsUser == self then
							wheels1.wheelsInRange:disassembleTwinWheels();
						end;
					end;
				end;
			end;
		end;
		if wheels2.wheelsInRange ~= nil and wheels1.twinWheels == nil then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_CAGEWHEELS_ATTACH) then
					if wheels2.cageWheels == nil then
						wheels2.wheelsInRange:assembleCageWheels(self);
					else
						if wheels2.wheelsInRange.cageWheelsUser == self then
							wheels2.wheelsInRange:disassembleCageWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableFergieWheelsAttacher:draw()
	if self.movingDirection == 0 then
		local wheels1 = self.buyableTwinWheels;
		local wheels2 = self.buyableCageWheels;
		if wheels2.wheelsInRange ~= nil and wheels1.twinWheels == nil then
			if wheels2.cageWheels ~= nil then
				if wheels2.wheelsInRange.cageWheelsUser == self then
					g_currentMission:addHelpButtonText(g_i18n:getText("BuyableCageWheels_disassemble"), InputBinding.BUYABLE_CAGEWHEELS_ATTACH);
				end;
			else
				if wheels2.wheelsInRange.cageWheelsUser == nil then
					g_currentMission:addHelpButtonText(g_i18n:getText("BuyableCageWheels_assemble"), InputBinding.BUYABLE_CAGEWHEELS_ATTACH);
				end;
			end;
		end;
		if wheels1.wheelsInRange ~= nil and wheels2.cageWheels == nil then
			if wheels1.twinWheels ~= nil then
				if wheels1.wheelsInRange.twinWheelsUser == self then
					g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.BUYABLE_WHEELS_ATTACH);
				end;
			else
				if wheels1.wheelsInRange.twinWheelsUser == nil then
					g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_assemble"), InputBinding.BUYABLE_WHEELS_ATTACH);
				end;
			end;
		end;
	end;
end;

function BuyableFergieWheelsAttacher:onAssemblingTwins(buyableTwinWheels)
	self.buyableTwinWheels.twinWheels = buyableTwinWheels;
end;

function BuyableFergieWheelsAttacher:onDisassemblingTwins()
	self.buyableTwinWheels.twinWheels = nil;
end;

function BuyableFergieWheelsAttacher:onAssemblingCage(buyableCageWheels)
	self.buyableCageWheels.cageWheels = buyableCageWheels;
end;

function BuyableFergieWheelsAttacher:onDisassemblingCage()
	self.buyableCageWheels.cageWheels = nil;
end;