--
-- Bale Sled
-- Class for Bale Sled
--
-- @author  Henly20 and PeterJ_LS-UK modteam
-- @date  31/10/2011
--


bale_sled = {};

function bale_sled.prerequisitesPresent(specializations)
    return true;
end;

function bale_sled:load(xmlFile)	


	self.setBackGate = SpecializationUtil.callSpecializationsFunction("setBackGate");
	self.BackGateAnimation = getXMLString(xmlFile, "vehicle.BackGate#animationName");
	self.BackGate = false;
	
	local gateSound = getXMLString(xmlFile, "vehicle.gateSound#file");
	if gateSound ~= nil and gateSound ~= "" then
		gateSound = Utils.getFilename(gateSound, self.baseDirectory);
		self.gateSound = createSample("gateSound");
		self.gateSoundEnabled = false;
		loadSample(self.gateSound, gateSound, false);
		self.gateSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.gateSound#pitchOffset"), 1);
		self.gateSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.gateSound#volume"), 1);
	end;
	self.playGateSound = false;

end;

function bale_sled:delete()

	if self.gateSound ~= nil then
		delete(self.gateSound);
		self.gateSoundEnabled = false;
	end;
end;

function bale_sled:readStream(streamId, connection)

	self:setBackGate(streamReadBool(streamId), true);
	
end;

function bale_sled:writeStream(streamId, connection)
	streamWriteBool(streamId, self.BackGate);
end;

function bale_sled:mouseEvent(posX, posY, isDown, isUp, button)
end;

function bale_sled:keyEvent(unicode, sym, modifier, isDown)
end;

function bale_sled:update(dt)

	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
				self:setBackGate(not self.isBackGateOn);
			end;
		end;
	end;
end;

function bale_sled:updateTick(dt)

	
	if self:getAnimationTime(self.BackGateAnimation) == 0 or self:getAnimationTime(self.BackGateAnimation) == 1 then
		self.playGateSound = false;
	else
		self.playGateSound = true;
	end;
	if self.playGateSound then
		if self.isClient then
			if not self.gateSoundEnabled and self:getIsActiveForSound() then
				setSamplePitch(self.gateSound, self.gateSoundPitchOffset);
				playSample(self.gateSound, 0, self.gateSoundVolume, 0);
				self.gateSoundEnabled = true;
			end;
		end;
	else
		if self.gateSoundEnabled then
			stopSample(self.gateSound);
			self.gateSoundEnabled = false;
		end;
	end;
end;

function bale_sled:draw()

	if self.BackGate == true then
		g_currentMission:addHelpButtonText(g_i18n:getText("Close"), InputBinding.IMPLEMENT_EXTRA3);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Open"), InputBinding.IMPLEMENT_EXTRA3);
	end;

end;

function bale_sled:onDeactivateSounds()
	if self.gateSoundEnabled then
		stopSample(self.gateSound);
		self.gateSoundEnabled = false;
	end;
end;

function bale_sled:onDetach()
    if self.deactivateOnDetach then
        bale_sled.onDeactivate(self);
    else
        bale_sled.onDeactivateSounds(self)
    end;

end;

function bale_sled:onLeave()
	if self.deactivateOnLeave then
		bale_sled.onDeactivateSounds(self);
	end;
end;

function bale_sled:onDeactivate()
 
	bale_sled.onDeactivateSounds(self)
end;

function bale_sled:setBackGate(isBackGate,noEventSend)
	SetBackGateEvent.sendEvent(self, isBackGate, noEventSend);
	-- Play BackGate animation --
	self.isBackGateOn = isBackGate;
	if self.isBackGateOn then
		if self.BackGateAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.BackGateAnimation, 1, nil, true);
			self.BackGate = true;
		end;
	else
		if self.BackGateAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.BackGateAnimation, -1, nil, true);
			self.BackGate = false;
		end;
	end;	
end;

SetBackGateEvent = {};
SetBackGateEvent_mt = Class(SetBackGateEvent, Event);

InitEventClass(SetBackGateEvent, "SetBackGateEvent");

function SetBackGateEvent:emptyNew()
    local self = Event:new(SetBackGateEvent_mt);
    self.className="SetBackGateEvent";
    return self;
end;

function SetBackGateEvent:new(vehicle, isBackGate)
    local self = SetBackGateEvent:emptyNew()
    self.vehicle = vehicle;
	self.isBackGate = isBackGate;
    return self;
end;

function SetBackGateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isBackGate = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetBackGateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isBackGate);
end;

function SetBackGateEvent:run(connection)   
	self.vehicle:setBackGate(self.isBackGate, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetBackGateEvent:new(self.vehicle, self.isBackGate), nil, connection, self.vehicle);
    end;
end;

function SetBackGateEvent.sendEvent(vehicle, isBackGate, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetBackGateEvent:new(vehicle, isBackGate), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetBackGateEvent:new(vehicle, isBackGate));
		end;
	end;
end;
