--
-- buyFillLevel
-- Class for fillable to start at certain fillLevel
--
-- @author  PeterJ - euroDZN
-- @date  20/09/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.
  
buyFillLevel = {};

function buyFillLevel.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;
  
function buyFillLevel:load(xmlFile)

	self.setBuyFillLevel = buyFillLevel.setBuyFillLevel;

	local buyFillLevel = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.buyFillLevel"), 0);
	if buyFillLevel > 0 then
		self.buyFillLevel = math.min(buyFillLevel, self.capacity);
		self.buyFilled = true;
	else
		self.buyFilled = false;
	end;

end;

function buyFillLevel:delete()
end;

function buyFillLevel:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if self.synchronizeFillLevel then
		local fillLevel = getXMLFloat(xmlFile, key.."#fillLevel");
		local fillType = getXMLString(xmlFile, key.."#fillType");
		if fillLevel ~= nil and fillType ~= nil then
			self:setBuyFillLevel(false);
		end;
	end
	return BaseMission.VEHICLE_LOAD_OK;
end;

function buyFillLevel:getSaveAttributesAndNodes(nodeIdent)
end;

function buyFillLevel:readStream(streamId, connection)
	local buyFilled = streamReadBool(streamId);
	self:setBuyFillLevel(buyFilled, true);
end;

function buyFillLevel:writeStream(streamId, connection)
	streamWriteBool(streamId, self.buyFilled);
end;

function buyFillLevel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function buyFillLevel:keyEvent(unicode, sym, modifier, isDown)
end;
  
function buyFillLevel:update(dt)
end;

function buyFillLevel:updateTick(dt)

	if self.buyFilled then
		if self.buyFillLevel > 0 and self.fillLevel <= 0 then
			self:setBuyFillLevel(true);
		end;
	end;
end;

function buyFillLevel:draw()
end;

function buyFillLevel:setBuyFillLevel(buyFilled, noEventSend)
	if buyFilled then
		local firstFillType = self:getFirstEnabledFillType();
		if firstFillType ~= Fillable.FILLTYPE_UNKNOWN then
			self:setFillLevel(self.buyFillLevel, firstFillType, true); 
			self.buyFilled = false;
		end;
	else
		self.buyFilled = false;
	end;
	buyFilled = self.buyFilled;
	SetBuyFilledEvent.sendEvent(self, buyFilled, noEventSend);
end;


SetBuyFilledEvent = {};
SetBuyFilledEvent_mt = Class(SetBuyFilledEvent, Event);

InitEventClass(SetBuyFilledEvent, "SetBuyFilledEvent");

function SetBuyFilledEvent:emptyNew()
	local self = Event:new(SetBuyFilledEvent_mt);
	return self;
end;

function SetBuyFilledEvent:new(object, buyFilled)
	local self = SetBuyFilledEvent:emptyNew()
	self.object = object;
	self.buyFilled = buyFilled;
	return self;
end;

function SetBuyFilledEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.buyFilled = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function SetBuyFilledEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.buyFilled);
end;

function SetBuyFilledEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:setBuyFillLevel(self.buyFilled, true);
	end;
end;

function SetBuyFilledEvent.sendEvent(vehicle, buyFilled, noEventSend)
	if buyFilled ~= vehicle.buyFilled then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetBuyFilledEvent:new(vehicle, buyFilled), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetBuyFilledEvent:new(vehicle, buyFilled));
			end;
		end;
	end;
end;