--
-- BaleCounter
-- Specialization for baler to display a bale counter.
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v1.0
-- @date  		30/11/10
--
-- edited by LS-UK modteam
-- @ 25/06/2011

BaleCounter = {};

function BaleCounter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function BaleCounter:load(xmlFile)
	self.dropBale = Utils.appendedFunction(self.dropBale, BaleCounter.dropBale);
	--  HUD --
	self.File = Utils.getFilename("textures/FergusonCounter.dds", self.baseDirectory);
	self.hudPoxX = 0.5;
    self.hudPoxY = 0.83; 
    self.hudWidth = 0.264;
    self.hudHeight = 0.16;
    self.HUDF12 = Overlay:new("HUDF12", self.File, self.hudPoxX, self.hudPoxY, self.hudWidth, self.hudHeight);
	self.HUD = false;
	
	self.TotalFergBalesCount = 0;
	self.CurrentFergBalesCount = 0;
	self.lastBaleSent = 0;

end;

function BaleCounter:delete()
end;

function BaleCounter:readStream(streamId, connection)
	self.TotalFergBalesCount = streamReadInt32(streamId);
	self.CurrentMcHaleBalesCount = streamReadInt32(streamId);
end;

function BaleCounter:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.TotalFergBalesCount);
	streamWriteInt32(streamId, self.CurrentMcHaleBalesCount);
end;

function BaleCounter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BaleCounter:keyEvent(unicode, sym, modifier, isDown)
end;

function BaleCounter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local TotalFergBalesCount =  Utils.getNoNil(getXMLInt(xmlFile, key.."#TotalFergBalesCount"),0);
	self.TotalFergBalesCount = TotalFergBalesCount;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function BaleCounter:getSaveAttributesAndNodes(nodeIdent)
	local TotalFergBalesCount= Utils.getNoNil(self.TotalFergBalesCount, 0);
	local attributes = 'TotalFergBalesCount="' .. tostring(self.TotalFergBalesCount) ..'"';
	return attributes, nil;
end;

function BaleCounter:update(dt)		
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENTHUD) then
			self.HUD = not self.HUD;
		end;
    end;
end;

function BaleCounter:updateTick(dt)	
end;

function BaleCounter:draw()
	setTextBold(true);
	setTextColor(0, 0, 0, 1.0);
	if self.HUD then
		self.HUDF12:render();
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_OFF"), self.typeDesc), InputBinding.IMPLEMENTHUD);
		if self.CurrentFergBalesCount~= nil then
			renderText(0.56, 0.91, 0.024, string.format(self.CurrentFergBalesCount));
		end;
		if self.TotalFergBalesCount~= nil then
			renderText(0.64, 0.91, 0.024, string.format(self.TotalFergBalesCount));
		end;
	else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HUD_ON"), self.typeDesc), InputBinding.IMPLEMENTHUD);	
	end;
	setTextBold(false);
end;

function BaleCounter:dropBale(baleIndex)
	if self.CurrentFergBalesCount ~= nil and self.TotalFergBalesCount ~= nil then
		self.CurrentFergBalesCount = self.CurrentFergBalesCount +1;
		self.TotalFergBalesCount = self.TotalFergBalesCount +1;
	end;
end;
