--#####################################################################--
-- VehicleControls														   --
--#####################################################################--
-- @Idee	Marc85													   --
--#####################################################################--
-- @author 	BlackyBPG						www.blackpanthergroup.de   --
--																	   --
-- @date  09/10/2013 (dd/mm/yyyy)
-- @update1 07/03/2014 (dd/mm/yyyy)
--																	   --
-- Hinweis: Editieren nur nach vorheriger absprache des Authors		   --
--#####################################################################--
vehicleControls = {};
function vehicleControls.prerequisitesPresent(specializations)
    return true;
end;

function vehicleControls:load(xmlFile)
	self.turnSignal =  {};
	local turnIndexStr = getXMLString(xmlFile, "vehicle.vehicleControls.turnSignal#index");
	if turnIndexStr ~= nil then
		local turnIndex = Utils.indexToObject(self.rootNode, turnIndexStr);
		if turnIndex ~= nil and turnIndex ~= 0 then
			self.turnSignal.index = turnIndex;
			self.turnSignal.leftRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.vehicleControls.turnSignal#leftRot"),20);
			self.turnSignal.rightRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.vehicleControls.turnSignal#rightRot"),-20);
			self.turnSignal.lrRot = 0;
			self.turnSignal.setBack = 0;
		end;
	end;

	self.speeder =  {};
	local speedIndexStr = getXMLString(xmlFile, "vehicle.vehicleControls.speed#index");
	if speedIndexStr ~= nil then
		local speedIndex = Utils.indexToObject(self.rootNode, speedIndexStr);
		if speedIndex ~= nil and speedIndex ~= 0 then
			self.speeder.index = speedIndex;
			self.speeder.maxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.vehicleControls.speed#maxRot"),-242);
			self.speeder.maxSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.vehicleControls.speed#maxSpeed"),60);
			self.speeder.lastSpeed1 = 0;
			self.speeder.lastSpeed2 = 0;
			self.speeder.lastSpeed3 = 0;
			self.speeder.lastSpeedPos = 1;
		end;
	end;

	self.grainLevel =  {};
	local grainLevelIndexStr = getXMLString(xmlFile, "vehicle.vehicleControls.grainLevel#index");
	if grainLevelIndexStr ~= nil then
		local grainLevelIndex = Utils.indexToObject(self.rootNode, grainLevelIndexStr);
		if grainLevelIndex ~= nil and grainLevelIndex ~= 0 then
			self.grainLevel.index = grainLevelIndex;
			self.grainLevel.maxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.vehicleControls.grainLevel#maxRot"),-242);
			self.grainLevel.maxGrainLevel = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankCapacity"),5000);
			local warnPre = getXMLFloat(xmlFile, "vehicle.vehicleControls.grainLevel#warningIndex");
			self.grainLevel.warningPercent = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.vehicleControls.grainLevel#warningPercent"), 75);
			if warnPre ~= nil then
				local warnPreIndex = Utils.indexToObject(self.rootNode, warnPre);
				if warnPreIndex ~= nil and warnPreIndex ~= 0 then
					self.grainLevel.warning = warnPreIndex;
				end;
			end;
			local warnFull = getXMLFloat(xmlFile, "vehicle.vehicleControls.grainLevel#warningFullIndex");
			if warnFull ~= nil then
				local warnFullIndex = Utils.indexToObject(self.rootNode, warnFull);
				if warnFullIndex ~= nil and warnFullIndex ~= 0 then
					self.grainLevel.warningFull = warnFullIndex;
				end;
			end;
		end;
	end;

	self.rpms =  {};
	local rpmIndexStr = getXMLString(xmlFile, "vehicle.vehicleControls.rpm#index");
	if rpmIndexStr ~= nil then
		local rpmIndex = Utils.indexToObject(self.rootNode, rpmIndexStr);
		if rpmIndex ~= nil and rpmIndex ~= 0 then
			self.rpms.index = rpmIndex;
			self.rpms.maxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.vehicleControls.rpm#maxRot"),245);
			self.rpms.maxRPM = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.vehicleControls.rpm#maxRPM"),3500);
			self.rpms.lastRPM1 = 0;
			self.rpms.lastRPM2 = 0;
			self.rpms.lastRPM3 = 0;
			self.rpms.lastRPMPos = 1;
		end;
	end;

	self.oilNeedle =  {};
	local oilIndexStr = getXMLString(xmlFile, "vehicle.vehicleControls.oilLevel#index");
	if oilIndexStr ~= nil then
		local oilIndex = Utils.indexToObject(self.rootNode, oilIndexStr);
		if oilIndex ~= nil and oilIndex ~= 0 then
			self.oilNeedle.index = oilIndex;
			self.oilNeedle.maxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.vehicleControls.oilLevel#maxRot"),70);
		end;
	end;

	self.fuel =  {};
	local fuelIndexStr = getXMLString(xmlFile, "vehicle.vehicleControls.fuel#index");
	if fuelIndexStr ~= nil then
		local fuelIndex = Utils.indexToObject(self.rootNode, fuelIndexStr);
		if fuelIndex ~= nil and fuelIndex ~= 0 then
			self.fuel.index = fuelIndex;
			self.fuel.maxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.vehicleControls.fuel#maxRot"),-134);
			self.fuel.reserve = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.vehicleControls.fuel#reserve"),-19);
			local rlIndex = getXMLString(xmlFile, "vehicle.vehicleControls.fuel#reserveLightIndex");
			if rlIndex ~= nil then
				self.fuel.reserveLight = Utils.indexToObject(self.rootNode, rlIndex);
			end;
		end;
	end;

	local handBrakeLight1 = getXMLString(xmlFile, "vehicle.vehicleControls.handBrakeLight#index1");
	if handBrakeLight1 ~= nil then
		local hbLightIndex1 = Utils.indexToObject(self.rootNode, handBrakeLight1);
		if hbLightIndex1 ~= nil and hbLightIndex1 ~= 0 then
			self.handBrakeLight1 = hbLightIndex1;
		end;
	end;
	local handBrakeLight2 = getXMLString(xmlFile, "vehicle.vehicleControls.handBrakeLight#index2");
	if handBrakeLight2 ~= nil then
		local hbLightIndex2 = Utils.indexToObject(self.rootNode, handBrakeLight2);
		if hbLightIndex2 ~= nil and hbLightIndex2 ~= 0 then
			self.handBrakeLight2 = hbLightIndex2;
		end;
	end;

	self.isSelectable = true;
end;

function vehicleControls:getAllowFillShovel(superFunc, fillType)
	if self.isTurnedOn then
		if superFunc ~= nil then
			return superFunc(self, fillType);
		end;
	end;
	return false;
end;

function vehicleControls:update(dt)
	self.operatingTime = Utils.getNoNil(self.operatingTime,0);
	if self.ESLimiter ~= nil then
		if self.ESLimiter.operatingTime ~= nil then
			self.operatingTime = Utils.getNoNil(self.ESLimiter.operatingTime,0);
		end;
	end;
	if self:getIsActive() then
		if self.oilNeedle ~= nil and self.oilNeedle.index ~= nil and self.operatingTime ~= nil and self.nextOilChange ~= nil and self.oilChangeInterval ~= nil then
			local rotStep = self.oilNeedle.maxRot / (self.oilChangeInterval * 600)
			local curRot = rotStep * ((self.oilChangeInterval * 600) - ((self.nextOilChange * 600) - self.operatingTime));
			if not self.isMotorStarted then
				curRot = self.oilNeedle.maxRot;
			end;
			if curRot > self.oilNeedle.maxRot then
				curRot = self.oilNeedle.maxRot;
			elseif curRot < 0 then
				curRot = 0;
			end;
			setRotation(self.oilNeedle.index, 0,Utils.degToRad(curRot),0);
		end;
		if self.fuel ~= nil and self.fuel.index ~= nil and self.fuelCapacity ~= nil then
			local curFuel = math.min(self.fuelCapacity, math.max(0, self.fuelFillLevel));
			local curRot = self.fuel.maxRot / self.fuelCapacity * curFuel;
			if not self.isMotorStarted then
				curRot = 0;
			end;
			if curRot < self.fuel.maxRot then
				curRot = self.fuel.maxRot;
			elseif curRot > 0 then
				curRot = 0;
			end;
			setRotation(self.fuel.index, 0,Utils.degToRad(curRot),0);
			if self.fuel.reserveLight ~= nil then
				if curRot >= self.fuel.reserve and self.isMotorStarted then
					setVisibility(self.fuel.reserveLight, true);
				else
					setVisibility(self.fuel.reserveLight, false);
				end;
			end;
		end;
		if self.speeder ~= nil and self.speeder.index ~= nil then
			local curSpeed = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
			local curRot = self.speeder.maxRot / self.speeder.maxSpeed * ((curSpeed + self.speeder.lastSpeed1 + self.speeder.lastSpeed2 + self.speeder.lastSpeed3) / 4);
			if not self.isMotorStarted then
				curRot = 0;
			end;
			if curRot < self.speeder.maxRot then
				curRot = self.speeder.maxRot;
			elseif curRot > 0 then
				curRot = 0;
			end;
			setRotation(self.speeder.index, 0,Utils.degToRad(curRot),0);
			if self.speeder.lastSpeedPos == 1 then
				self.speeder.lastSpeedPos = 2;
				self.speeder.lastSpeed1 = curSpeed;
			elseif self.speeder.lastSpeedPos == 2 then
				self.speeder.lastSpeedPos = 3;
				self.speeder.lastSpeed2 = curSpeed;
			else
				self.speeder.lastSpeedPos = 1;
				self.speeder.lastSpeed3 = curSpeed;
			end;
		end;

		if self.grainLevel ~= nil and self.grainLevel.index ~= nil then
			local curRot = (self.grainLevel.maxRot / self.grainLevel.maxGrainLevel) * self.grainTankFillLevel;
			setRotation(self.grainLevel.index, 0,Utils.degToRad(curRot),0);
			if self.grainLevel.warning ~= nil then
				local showWarn = false;
				local percent = 100 / self.grainLevel.maxGrainLevel * self.grainTankFillLevel;
				if self.grainLevel.warningPercent <= percent then
					showWarn = true;
				end;
				if self.grainLevel.warningFull ~= nil then
					if percent > 99.6 then
						showWarn = false;
					end;
				end;
				if getVisibility(self.grainLevel.warning) ~= showWarn then
					setVisibility(self.grainLevel.warning, showWarn);
				end;
			end;
			if self.grainLevel.warningFull ~= nil then
				local percent = 100 / self.grainLevel.maxGrainLevel * self.grainTankFillLevel;
				local showWarnFull = false;
				if percent >= 99.5 then
					showWarnFull = true;
				end;
				if getVisibility(self.grainLevel.warningFull) ~= showWarnFull then
					setVisibility(self.grainLevel.warningFull, showWarnFull);
				end;
			end;
		end;

		if self.rpms ~= nil and self.rpms.index ~= nil and self.motor ~= nil then
			local curRPM = self.motor.lastMotorRpm;
			local curRot = self.rpms.maxRot / self.rpms.maxRPM * ((curRPM + self.rpms.lastRPM1 + self.rpms.lastRPM2 + self.rpms.lastRPM3) / 4);
			if not self.isMotorStarted then
				curRot = 0;
			end;
			if curRot < self.rpms.maxRot then
				curRot = self.rpms.maxRot;
			elseif curRot > 0 then
				curRot = 0;
			end;
			setRotation(self.rpms.index, 0,Utils.degToRad(curRot),0);
			if self.rpms.lastRPMPos == 1 then
				self.rpms.lastRPMPos = 2;
				self.rpms.lastRPM1 = curRPM;
			elseif self.rpms.lastRPMPos == 2 then
				self.rpms.lastRPMPos = 3;
				self.rpms.lastRPM2 = curRPM;
			else
				self.rpms.lastRPMPos = 1;
				self.rpms.lastRPM3 = curRPM;
			end;
		end;
	end;

	if self.B3 ~= nil and self.B3.dirLeft ~= nil and self.B3.dirRight ~= nil then
		if self.turnSignal ~= nil and self.turnSignal.index ~= nil then
			if self.B3.dirLeft[1].a and not self.B3.wl then
				if self.turnSignal.lrRot < self.turnSignal.leftRot then
					self.turnSignal.lrRot = self.turnSignal.lrRot + (dt * 0.05);
					setRotation(self.turnSignal.index,0,Utils.degToRad(self.turnSignal.lrRot),0);
				end;
			elseif self.B3.dirRight[1].a and not self.B3.wl then
				if self.turnSignal.lrRot > self.turnSignal.rightRot then
					self.turnSignal.lrRot = self.turnSignal.lrRot - (dt * 0.05);
					setRotation(self.turnSignal.index,0,Utils.degToRad(self.turnSignal.lrRot),0);
				end;
			else
				if self.turnSignal.lrRot < 0 then
					self.turnSignal.setBack = 1;
					self.turnSignal.lrRot = self.turnSignal.lrRot + (dt * 0.05);
					setRotation(self.turnSignal.index,0,Utils.degToRad(self.turnSignal.lrRot),0);
				elseif self.turnSignal.lrRot > 0 then
					self.turnSignal.setBack = 2;
					self.turnSignal.lrRot = self.turnSignal.lrRot - (dt * 0.05);
					setRotation(self.turnSignal.index,0,Utils.degToRad(self.turnSignal.lrRot),0);
				end;
				if (self.turnSignal.lrRot < 0 and self.turnSignal.setBack == 2) or (self.turnSignal.lrRot > 0 and self.turnSignal.setBack == 1) then
					self.turnSignal.setBack = 0;
					setRotation(self.turnSignal.index,0,0,0);
				end;
			end;
		end;
	end;
end;

function vehicleControls:updateTick(dt)
	if self.handBrakeLight1 ~= nil then
		if self.handbrake ~= nil then
			if self.handbrake and (not getVisibility(self.handBrakeLight1)) then
				setVisibility(self.handBrakeLight1, true);
			elseif getVisibility(self.handBrakeLight1) and not self.handbrake then
				setVisibility(self.handBrakeLight1, false);
			end;
		elseif self.parkingBrake ~= nil then
			if self.handbrake and (not getVisibility(self.handBrakeLight1)) then
				setVisibility(self.handBrakeLight1, true);
			elseif getVisibility(self.handBrakeLight1) and not self.handbrake then
				setVisibility(self.handBrakeLight1, false);
			end;
		end;
	end;
	if self.handBrakeLight2 ~= nil then
		if self.handbrake ~= nil then
			if self.handbrake and (not getVisibility(self.handBrakeLight2)) then
				setVisibility(self.handBrakeLight2, true);
			elseif getVisibility(self.handBrakeLight2) and not self.handbrake then
				setVisibility(self.handBrakeLight2, false);
			end;
		elseif self.parkingBrake ~= nil then
			if self.handbrake and (not getVisibility(self.handBrakeLight2)) then
				setVisibility(self.handBrakeLight2, true);
			elseif getVisibility(self.handBrakeLight2) and not self.handbrake then
				setVisibility(self.handBrakeLight2, false);
			end;
		end;
	end;
end;

function vehicleControls:draw()
end;

function vehicleControls:delete()
end;

function vehicleControls:mouseEvent(posX, posY, isDown, isUp, button)
end;

function vehicleControls:keyEvent(unicode, sym, modifier, isDown)
end;

function vehicleControls:readStream(streamId, connection)
end;

function vehicleControls:writeStream(streamId, connection)
end;

