-- author: rafftnix
-- date: 16.12.2012


SetSawFuelFillLevelEvent = {};
SetSawFuelFillLevelEvent_mt = Class(SetSawFuelFillLevelEvent, Event);
InitEventClass(SetSawFuelFillLevelEvent, "SetSawFuelFillLevelEvent");
function SetSawFuelFillLevelEvent:emptyNew()
    local self = Event:new(SetSawFuelFillLevelEvent_mt);
    self.className="SetSawFuelFillLevelEvent";
    return self;
end;

function SetSawFuelFillLevelEvent:new(object, level)
    local self = SetSawFuelFillLevelEvent:emptyNew(); 
    self.object = object; 
	local percent = level / self.object.saw.fuelCapacity;
	self.percent = math.floor(percent*255);
    return self;
end;

function SetSawFuelFillLevelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteUIntN(streamId, self.percent, 8);
end;

function SetSawFuelFillLevelEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    local percent = streamReadUIntN(streamId, 8);
	percent = percent / 255;
	local level = percent * self.object.saw.fuelCapacity;
    self.object:setSawFuelFillLevel(level);
end;