-- author: rafftnix
-- date: 20.12.2012

RefuelMotorSawEvent = {};
RefuelMotorSawEvent_mt = Class(RefuelMotorSawEvent, Event);
InitEventClass(RefuelMotorSawEvent, "RefuelMotorSawEvent");
function RefuelMotorSawEvent:emptyNew()
    local self = Event:new(RefuelMotorSawEvent_mt);
    self.className="RefuelMotorSawEvent";
    return self;
end;

function RefuelMotorSawEvent:new(object)
    local self = RefuelMotorSawEvent:emptyNew(); 
    self.object = object; 
    return self;
end;

function RefuelMotorSawEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

function RefuelMotorSawEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self:run(connection);
end;

function RefuelMotorSawEvent:run(connection)
	self.object:refuelMotorSaw(true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(RefuelMotorSawEvent:new(self.object), nil, connection, self.object);
	end; 
end;

function RefuelMotorSawEvent.sendEvent(object, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(RefuelMotorSawEvent:new(object), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(RefuelMotorSawEvent:new(object)); 
		end;
	end;
end;