-- author: rafftnix
-- date: 31.12.2012

JoinTrunksEvent = {};
JoinTrunksEvent_mt = Class(JoinTrunksEvent, Event);
InitEventClass(JoinTrunksEvent, "JoinTrunksEvent");
function JoinTrunksEvent:emptyNew()
    local self = Event:new(JoinTrunksEvent_mt);
    self.className="JoinTrunksEvent";
    return self;
end;

function JoinTrunksEvent:new(trunk1, trunk2)
    local self = JoinTrunksEvent:emptyNew(); 
    self.trunk1 = trunk1;
	self.trunk2 = trunk2;
    return self;
end;

function JoinTrunksEvent:writeStream(streamId, connection)
	print("function JoinTrunksEvent:writeStream("..tostring(streamId)..", "..tostring(connection));
	print("self.trunk1 = " .. tostring(self.trunk1) .. "   networkGetObjectId(self.trunk1) = " .. tostring(networkGetObjectId(self.trunk1)));
	print("self.trunk2 = " .. tostring(self.trunk2) .. "   networkGetObjectId(self.trunk2) = " .. tostring(networkGetObjectId(self.trunk2)));
    streamWriteInt32(streamId, networkGetObjectId(self.trunk1));
    streamWriteInt32(streamId, networkGetObjectId(self.trunk2));
end;

function JoinTrunksEvent:readStream(streamId, connection)
	local trunk1NetId = streamReadInt32(streamId);
	local trunk2NetId = streamReadInt32(streamId);

	print("trunk1NetId: " .. tostring(trunk1NetId) .. "   " .. tostring(networkGetObject(trunk1NetId)));
	print("trunk2NetId: " .. tostring(trunk2NetId) .. "   " .. tostring(networkGetObject(trunk2NetId)));
	if g_currentMission.treeManager.firstRunDone and networkGetObject(trunk1NetId) ~= nil and networkGetObject(trunk2NetId) ~= nil then
		g_currentMission.harvestableTrees:joinTrunks(networkGetObject(trunk1NetId), networkGetObject(trunk2NetId));
	else
		local joint = {trunk1NetId, trunk2NetId}
		table.insert(g_currentMission.harvestableTrees.trunkJointStorage, joint);
	end;	
end;