-- author: rafftnix
-- date: 16.12.2012


SetSawIsRunningEvent = {};
SetSawIsRunningEvent_mt = Class(SetSawIsRunningEvent, Event);
InitEventClass(SetSawIsRunningEvent, "SetSawIsRunningEvent");

function SetSawIsRunningEvent:emptyNew()
--print("function SetSawIsRunningEvent:emptyNew()");
    local self = Event:new(SetSawIsRunningEvent_mt);
    self.className="SetSawIsRunningEvent";
    return self;
end;

function SetSawIsRunningEvent:new(object, isRunning)
--print("function SetSawIsRunningEvent:new("..tostring(object)..", "..tostring(isRunning));
    local self = SetSawIsRunningEvent:emptyNew(); 
    self.object = object; 
	self.isRunning = isRunning;
    return self;
end;

function SetSawIsRunningEvent:writeStream(streamId, connection)
--print("function SetSawIsRunningEvent:writeStream(streamId, connection)");
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.isRunning);
end;

function SetSawIsRunningEvent:readStream(streamId, connection)
--print("function SetSawIsRunningEvent:readStream(streamId, connection)");
	local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self.isRunning = streamReadBool(streamId);
    self:run(connection);
end;

function SetSawIsRunningEvent:run(connection)
--print("function SetSawIsRunningEvent:run(connection)");
	self.object:setSawIsRunning(self.isRunning, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetSawIsRunningEvent:new(self.object, self.isRunning), nil, connection, self.object);
	end; 
end;

function SetSawIsRunningEvent.sendEvent(object, isRunning, noEventSend)
--print("function SetSawIsRunningEvent.sendEvent("..tostring(object)..", "..tostring(isRunning)..", "..tostring(noEventSend));
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(SetSawIsRunningEvent:new(object, isRunning), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(SetSawIsRunningEvent:new(object, isRunning)); 
		end;
	end;
end;