-- author: fireandice, rafftnix
-- date: February 2014

playAnimWhileMovingTool = {};

function playAnimWhileMovingTool.prerequisitesPresent(specializations)
    return true;
end;

function playAnimWhileMovingTool:load(xmlFile)
	for a=1, table.getn(self.movingTools) do
		local entry = self.movingTools[a];
		local baseName = string.format("vehicle.movingTools.movingTool(%d)", a-1);
		local animationRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#rootNode"));
		if animationRootNode ~= nil then
			local animationCharSet = getAnimCharacterSet(animationRootNode);
			if animationCharSet ~= nil then
				local clip = getAnimClipIndex(animationCharSet, getXMLString(xmlFile, baseName.."#clip"));
				entry.clipName = getXMLString(xmlFile, baseName.."#clip");
				assignAnimTrackClip(animationCharSet, 0, clip);
				setAnimTrackLoopState(animationCharSet, 0, false);
				entry.animationCharSet = animationCharSet;
				entry.animationDuration = getAnimClipDuration(animationCharSet, clip);
				entry.invertAnim = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#invertAnim"), false);
				assignAnimTrackClip(animationCharSet, 1, clip);
			end
		end
	end;
end;

function playAnimWhileMovingTool:delete()
end;


function playAnimWhileMovingTool:mouseEvent(posX, posY, isDown, isUp, button)
end;

function playAnimWhileMovingTool:keyEvent(unicode, sym, modifier, isDown)
end;

function playAnimWhileMovingTool:update(dt)
	for a=1, table.getn(self.movingTools) do
		local tool = self.movingTools[a];
		if tool.animationCharSet ~= nil then
			if tool.rotSpeed ~= 0 or tool.rotSpeedBackupMC ~= 0 then
				local toolRange = tool.rotMax-tool.rotMin;
				local toolCurPos = math.abs(tool.curRot[tool.rotationAxis]-tool.rotMax);
				local animTime = toolCurPos/toolRange*tool.animationDuration;
				if tool.invertAnim then
					animTime = tool.animationDuration-animTime;
				end;
				setAnimTrackTime(tool.animationCharSet, 1, animTime);
				enableAnimTrack(tool.animationCharSet, 1);
			elseif tool.transSpeed ~= 0 or tool.transSpeedBackupMC ~= 0 then
				local toolRange = tool.transMax-tool.transMin;
				local toolCurPos = math.abs(tool.curTrans[tool.translationAxis]-tool.transMax);
				local animTime = toolCurPos/toolRange*tool.animationDuration;
				if tool.invertAnim then
					animTime = tool.animationDuration-animTime;
				end;
				setAnimTrackTime(tool.animationCharSet, 1,  animTime);
				enableAnimTrack(tool.animationCharSet, 1);
			end;
		end;
	end;
end;

function playAnimWhileMovingTool:draw()	
end;