--
-- DrivingParticleSystem
-- Specialization for DrivingParticleSystem
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		13/11/11
-- @history:	v1.0 - Initial version
--				v1.1 - added on/off depending on: 
--						- terrainDetail (fields)
--						- fruitType dust, used to enable ps on roads
--

DrivingParticleSystem = {};

function DrivingParticleSystem.prerequisitesPresent(specializations)
    return true;
end;

function DrivingParticleSystem:load(xmlFile)
	
    self.drivingParticles = {};
    if self.isClient then
        local i=0;
        while true do
            local key = string.format("vehicle.drivingParticles.drivingParticle(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
                break;
            end;
            local particle = {};
            particle.ps = {};
            Utils.loadParticleSystem(xmlFile, particle.ps, key, self.components, false, nil, self.baseDirectory);
            if table.getn(particle.ps) > 0 then
                particle.minSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#minSpeed"), 2)/3600;
                particle.maxSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxSpeed"), 40)/3600;
                particle.minScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#minScale"), 0.2);
                particle.maxScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxScale"), 1);
                --particle.direction = Utils.getNoNil(getXMLFloat(xmlFile, key.."#direction"), 1);
				particle.wheel = getXMLInt(xmlFile, key .. "#wheel");
				particle.lastScale = 0;
				particle.a = false;
                table.insert(self.drivingParticles, particle);
            end;

            i = i+1;
        end;
    end;
	self.drivingParticleThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drivingParticles#threshold"), 0.005);
	self.dtTmp = 0;
	self.dtDelta = 400;
	--[[ print("###########################################");
	for i,j in pairs(FruitUtil) do
		print("--> "..tostring(i).." "..tostring(j));
	end;
	print("###########################################");
	for i,j in pairs(Utils) do
		print("--> "..tostring(i).." "..tostring(j));
	end;
	print("###########################################"); ]]--
end;

function DrivingParticleSystem:delete()
    for _, particle in pairs(self.drivingParticles) do
        Utils.deleteParticleSystem(particle.ps);
    end;
end;

function DrivingParticleSystem:readStream(streamId, connection)
end;

function DrivingParticleSystem:writeStream(streamId, connection)
end;

function DrivingParticleSystem:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DrivingParticleSystem:keyEvent(unicode, sym, modifier, isDown)
end;

function DrivingParticleSystem:update(dt)
end;

function DrivingParticleSystem:updateTick(dt)	
	local check = false;
	self.dtTmp = self.dtTmp + dt;
	if self.dtTmp > self.dtDelta then
		check = true;
		self.dtTmp = 0;
	end;
	if self.isClient then	
		if self:getIsActive() and check then
			local isVisible = false;
			local camera = getCamera();
			if camera ~= 0 then
				local x,y,z = getWorldTranslation(camera);
				local x1,y1,z1 = getWorldTranslation(self.rootNode);
				local distance = Utils.vector3Length(x-x1,y-y1,z-z1);
				isVisible = (distance < 300);
			end;
			
			local dens = 0; 
			if isVisible then
				local dens1=0; local dens2=0; local dens3=0; local dens4=0;
				local x,y,z = getWorldTranslation(self.wheels[2].repr);
				local x1,y1,z1 = getWorldTranslation(self.wheels[1].repr);
				local x2,y2,z2 = getWorldTranslation(self.wheels[4].repr);
				local id = g_currentMission.terrainDetailId;
				local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
				local area = Utils.getFruitArea(FruitUtil.FRUITTYPE_DUST, x, z, x1, z1, x2, z2);
				if area > 0 then
					dens4 = area;
				else
					dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
					dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
					dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
				end;
				if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
					dens = dens1+dens2+dens3+dens4;
				end;
			end;
			
            for k, particle in pairs(self.drivingParticles) do		
				local isActive = false;
				
				if dens > 0 and g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
					if particle.wheel ~= nil then
						--[[local x,y,z = getWorldTranslation(self.wheels[particle.wheel].repr);--getWheelShapeContactPoint(self.wheels[particle.wheel].node, self.wheels[particle.wheel].wheelShape);
						y = y - self.wheels[particle.wheel].radius;
						
						if y ~= nil then
							local height = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x,y,z); 
							local hasGroundContact = math.abs(y - height) < self.drivingParticleThreshold;
						]]--
							--if self.lastSpeedReal > particle.minSpeed and (particle.direction == 0 or (particle.direction > 0) == (self.movingDirection > 0)) and hasGroundContact then								
							if math.abs(self.lastSpeedReal) > math.abs(particle.minSpeed) then --and (particle.direction == 0 or (particle.direction > 0) == (self.movingDirection > 0)) then															
								isActive = isVisible;
							end;
						--end;
					end;
				end;
				if isActive == true and particle.a == false then
					Utils.setEmittingState(particle.ps, isActive);
					particle.a = true;
				elseif isActive == false and particle.a == true then
					Utils.setEmittingState(particle.ps, isActive);
					particle.a = false;
				end;
            end;
		elseif check == true then
			for _, particle in pairs(self.drivingParticles) do
				if particle.a == true then
					Utils.setEmittingState(particle.ps, false);
					particle.a = false;
				end;
			end;
        end;
    end;
end;

function DrivingParticleSystem:draw()	
end;