   -- realPloughPS
   -- Specialization for real Plough Particle System
   --
   -- Ersteller Brndi
   -- Datum 29/07/12
   --
   -- Before you want to use the script to another mod please contact me on ICQ (554488792)
   -- or one of the various forum's (nickname: Brndi) Thank you!
   --
   -- Bevor du das Script in einen anderen Mod verwenden willst bitte kontaktiere mich in ICQ (554488792)
   -- oder in einen der verschiedenen Forums (Nickname: Brndi) Danke!!!
   --

ploughModifyPS = {};

function ploughModifyPS.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Plough, specializations) and SpecializationUtil.hasSpecialization(Attachable, specializations); 
end;

function ploughModifyPS:load(xmlFile)

	if self.isClient then
		self.pflugParticleSystemsInvert = {};
		local i=0;
		while true do
			local key = string.format("vehicle.pflugParticleSystems.pflugParticleSystemInvertiert(%d)", i);
			local node = getXMLString(xmlFile, key.. "#node");
			if node == nil then
				break;
			end;
			node = Utils.indexToObject(self.components, node);
			if node ~= nil then
				local psFile = getXMLString(xmlFile, key.. "#file");
				local pflugParticleSystemInvert = {};
				pflugParticleSystemInvert.particleSystem = {};
				StaticParticleSystem.loadParticleSystem(xmlFile, pflugParticleSystemInvert.particleSystem, key, self.components, false, nil, self.baseDirectory);
				table.insert(self.pflugParticleSystemsInvert, pflugParticleSystemInvert);
			end;
			i = i+1;
		end;


		self.pflugParticleSystemsnichtInvert = {};
		local i=0;
		while true do
			local key = string.format("vehicle.pflugParticleSystems.pflugParticleSystemnichtInvertiert(%d)", i);
			local node = getXMLString(xmlFile, key.. "#node");
			if node == nil then
				break;
			end;
			node = Utils.indexToObject(self.components, node);
			if node ~= nil then
				local psFile = getXMLString(xmlFile, key.. "#file");
				local pflugParticleSystemnichtInvert = {};
				pflugParticleSystemnichtInvert.particleSystem = {};
				StaticParticleSystem.loadParticleSystem(xmlFile, pflugParticleSystemnichtInvert.particleSystem, key, self.components, false, nil, self.baseDirectory);
				table.insert(self.pflugParticleSystemsnichtInvert, pflugParticleSystemnichtInvert);
			end;
			i = i+1;
		end;
	end;

	self.ParticleInvert = false;

end;

function ploughModifyPS:delete()

	for k, pflugParticleSystemInvert in pairs(self.pflugParticleSystemsInvert) do
		Utils.deleteParticleSystem(pflugParticleSystemInvert);
	end;

	for k, pflugParticleSystemnichtInvert in pairs(self.pflugParticleSystemsnichtInvert) do
		Utils.deleteParticleSystem(pflugParticleSystemnichtInvert);
	end;

end;

function ploughModifyPS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ploughModifyPS:keyEvent(unicode, sym, modifier, isDown)
end;

function ploughModifyPS:update(dt)

	if self:getIsActive() then
		if self.rotationMax then
			self.ParticleInvert = true;
		else
			self.ParticleInvert = false;
		end;
	end;

	if self.ParticleInvert and self.groundParticleSystemActive and self.ploughHasGroundContact then
		for k, pflugParticleSystemInvert in pairs(self.pflugParticleSystemsInvert) do
			Utils.setEmittingState(pflugParticleSystemInvert.particleSystem, true);
		end;

		self.ParticleInvertZs = true;
	else
		for k, pflugParticleSystemInvert in pairs(self.pflugParticleSystemsInvert) do
			Utils.setEmittingState(pflugParticleSystemInvert.particleSystem, false);
		end;
		
		self.ParticleInvertZs = false;
	end;

	if not self.ParticleInvert and self.groundParticleSystemActive and self.ploughHasGroundContact then
		for k, pflugParticleSystemnichtInvert in pairs(self.pflugParticleSystemsnichtInvert) do
			Utils.setEmittingState(pflugParticleSystemnichtInvert.particleSystem, true);
		end;

		
		self.ParticlenichtInvertZs = true;
	else
		for k, pflugParticleSystemnichtInvert in pairs(self.pflugParticleSystemsnichtInvert) do
			Utils.setEmittingState(pflugParticleSystemnichtInvert.particleSystem, false);
		end;

		
		self.ParticlenichtInvertZs = false;
	end;

	if not self.groundParticleSystemActive or not self.ploughHasGroundContact or not self.ploughHasContactReport or not self.ploughContactReportsActive or not self.ploughSoundEnabled then
		Utils.setEmittingState(self.pflugParticleSystemInvert, false);
		Utils.setEmittingState(self.pflugParticleSystemnichtInvert, false);
	end;

end;

function ploughModifyPS:updateTick(dt)
end;

function ploughModifyPS:draw()
end;