--[[
	VariableCapacityWheelLoaderRegister.lua
	
	Autor: Ifko[nator]
	Datum: 08.08.2014
]]

SpecializationUtil.registerSpecialization("variableCapacityWheelLoader", "VariableCapacityWheelLoader", g_currentModDirectory.."Scripts/VariableCapacityWheelLoader.lua")

VariableCapacityWheelLoaderRegister = {};

function VariableCapacityWheelLoaderRegister:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("shovel") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.variableCapacityWheelLoader", _name)) ~= nil then
								allowInsertion = false;
							end;
						end;
						if allowInsertion then
							local allowInsert = false;
							for i = 1, table.maxn(v.specializations) do
								local vs = v.specializations[i]
								-- Standard lua's 
								if vs ~= nil and vs == SpecializationUtil.getSpecialization("motorized") then 
									allowInsert = true;
								end;
							end;
							if allowInsert then
								local allowInsert2 = true;
								for i = 1, table.maxn(v.specializations) do
									local vs = v.specializations[i]
									-- Standard lua's 
									if vs ~= nil and vs == SpecializationUtil.getSpecialization("mixerWagon") then 
										allowInsert2 = false;
									end;
								end;
								if allowInsert2 then
									table.insert(v.specializations, SpecializationUtil.getSpecialization("variableCapacityWheelLoader"));
								end;
							end;
						end;
						Motorized.HIDE_HUD = g_i18n:getText("HIDE_HUD_TEXT");
						Motorized.SHOW_HUD = g_i18n:getText("SHOW_HUD_TEXT");
						Motorized.NOT_ALLOW_ADD_CAPACITY = g_i18n:getText("NOT_ALLOW_ADD_CAPACITY_TEXT");
						Motorized.ALLOW_ADD_CAPACITY = g_i18n:getText("ALLOW_ADD_CAPACITY_TEXT");
						Motorized.SET_NEW_CAPACITY = g_i18n:getText("SET_NEW_CAPACITY_TEXT");
						Motorized.STOP_SET_NEW_CAPACITY = g_i18n:getText("STOP_SET_NEW_CAPACITY_TEXT");
						Motorized.VERSION = g_i18n:getText("VERSION_TEXT");
						Motorized.FILL_LEVEL = g_i18n:getText("FILL_LEVEL_TEXT");
						Motorized.CAPACITY = g_i18n:getText("CAPACITY_TEXT");
						Motorized.CAPACITY_ADDED = g_i18n:getText("CAPACITY_ADDED_TEXT");
						Motorized.ADD_CAPACITY_ACTIVE = g_i18n:getText("ADD_CAPACITY_ACTIVE_TEXT");
						Motorized.ADD_CAPACITY_NOT_ACTIVE = g_i18n:getText("ADD_CAPACITY_NOT_ACTIVE_TEXT");
						Motorized.ADD_CAPACITY_MIN = g_i18n:getText("ADD_CAPACITY_MIN_TEXT");
						Motorized.ADD_CAPACITY_MAX = g_i18n:getText("ADD_CAPACITY_MAX_TEXT");
						Motorized.CAPACITY_REMOVED = g_i18n:getText("CAPACITY_REMOVED_TEXT");
						Motorized.REMOVE_CAPACITY_ACTIVE = g_i18n:getText("REMOVE_CAPACITY_ACTIVE_TEXT");
						Motorized.REMOVE_CAPACITY_NOT_ACTIVE = g_i18n:getText("REMOVE_CAPACITY_NOT_ACTIVE_TEXT");
						Motorized.REMOVE_CAPACITY_MIN = g_i18n:getText("REMOVE_CAPACITY_MIN_TEXT");
						Motorized.REMOVE_CAPACITY_MAX = g_i18n:getText("REMOVE_CAPACITY_MAX_TEXT");
						Motorized.NEW_CAPACITY = g_i18n:getText("NEW_CAPACITY_TEXT");
					end;
				end;
			end;	
		end;
	end;
end;

function VariableCapacityWheelLoaderRegister:deleteMap()
end;

function VariableCapacityWheelLoaderRegister:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableCapacityWheelLoaderRegister:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableCapacityWheelLoaderRegister:update(dt)
end;

function VariableCapacityWheelLoaderRegister:draw()
end;

addModEventListener(VariableCapacityWheelLoaderRegister);