--[[
	VariableCapacityTrailerShovelRegister.lua
	
	Autor: Ifko[nator]
	Datum: 08.08.2014
]]

SpecializationUtil.registerSpecialization("variableCapacityTrailerShovel", "VariableCapacityTrailerShovel", g_currentModDirectory.."Scripts/VariableCapacityTrailerShovel.lua")

VariableCapacityTrailerShovelRegister = {};

function VariableCapacityTrailerShovelRegister:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("fillable") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.variableCapacityTrailerShovel", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.variableBody", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.ubt", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.Cargo", _name)) ~= nil 
								or rawget(SpecializationUtil.specializations, string.format("%s.HeapTipTrigger", _name)) ~= nil 
								or rawget(SpecializationUtil.specializations, string.format("%s.dlcBaleLoader", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.treePlanter", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.seedlingPallet", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.Autostack", _name)) ~= nil
								or rawget(SpecializationUtil.specializations, string.format("%s.Quaderballensammelwagen", _name)) ~= nil 
								or rawget(SpecializationUtil.specializations, string.format("%s.Rundballensammelwagen", _name)) ~= nil 
							then
								allowInsertion = false;
							end;
						end;
						if allowInsertion then
							local allowInsert = true;
							for i = 1, table.maxn(v.specializations) do
								local vs = v.specializations[i]
								-- Standard lua's 
								if vs ~= nil and (vs == SpecializationUtil.getSpecialization("mixerWagon") 
									or vs == SpecializationUtil.getSpecialization("baleLoader") 
									or vs == SpecializationUtil.getSpecialization("baler") 
									or vs == SpecializationUtil.getSpecialization("combine")
									or vs == SpecializationUtil.getSpecialization("strawBlower")
									or vs == SpecializationUtil.getSpecialization("articulatedAxis")
								) then 
									allowInsert = false;
								end;
							end;
							if allowInsert then
								table.insert(v.specializations, SpecializationUtil.getSpecialization("variableCapacityTrailerShovel"));
							end;
						end;
						Trailer.HIDE_HUD = g_i18n:getText("HIDE_HUD_TEXT");
						Trailer.SHOW_HUD = g_i18n:getText("SHOW_HUD_TEXT");
						Trailer.NOT_ALLOW_ADD_CAPACITY = g_i18n:getText("NOT_ALLOW_ADD_CAPACITY_TEXT");
						Trailer.ALLOW_ADD_CAPACITY = g_i18n:getText("ALLOW_ADD_CAPACITY_TEXT");
						Trailer.SET_NEW_CAPACITY = g_i18n:getText("SET_NEW_CAPACITY_TEXT");
						Trailer.STOP_SET_NEW_CAPACITY = g_i18n:getText("STOP_SET_NEW_CAPACITY_TEXT");
						Trailer.VERSION = g_i18n:getText("VERSION_TEXT");
						Trailer.FILL_LEVEL = g_i18n:getText("FILL_LEVEL_TEXT");
						Trailer.CAPACITY = g_i18n:getText("CAPACITY_TEXT");
						Trailer.CAPACITY_ADDED = g_i18n:getText("CAPACITY_ADDED_TEXT");
						Trailer.ADD_CAPACITY_ACTIVE = g_i18n:getText("ADD_CAPACITY_ACTIVE_TEXT");
						Trailer.ADD_CAPACITY_NOT_ACTIVE = g_i18n:getText("ADD_CAPACITY_NOT_ACTIVE_TEXT");
						Trailer.ADD_CAPACITY_MIN = g_i18n:getText("ADD_CAPACITY_MIN_TEXT");
						Trailer.ADD_CAPACITY_MAX = g_i18n:getText("ADD_CAPACITY_MAX_TEXT");
						Trailer.CAPACITY_REMOVED = g_i18n:getText("CAPACITY_REMOVED_TEXT");
						Trailer.REMOVE_CAPACITY_ACTIVE = g_i18n:getText("REMOVE_CAPACITY_ACTIVE_TEXT");
						Trailer.REMOVE_CAPACITY_NOT_ACTIVE = g_i18n:getText("REMOVE_CAPACITY_NOT_ACTIVE_TEXT");
						Trailer.REMOVE_CAPACITY_MIN = g_i18n:getText("REMOVE_CAPACITY_MIN_TEXT");
						Trailer.REMOVE_CAPACITY_MAX = g_i18n:getText("REMOVE_CAPACITY_MAX_TEXT");
						Trailer.NEW_CAPACITY = g_i18n:getText("NEW_CAPACITY_TEXT");
					end;
				end;
			end;	
		end;
	end;
end;

function VariableCapacityTrailerShovelRegister:deleteMap()
end;

function VariableCapacityTrailerShovelRegister:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableCapacityTrailerShovelRegister:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableCapacityTrailerShovelRegister:update(dt)
end;

function VariableCapacityTrailerShovelRegister:draw()
end;

addModEventListener(VariableCapacityTrailerShovelRegister);