--[[
	EN: 'VariableCapacityCombine' Specialization for Combines.
	
	DE: 'VariableCapacityCombine' Spezialisierung für Drescher.
	
	Autor: Ifko[nator]
	Datum: 08.08.2014
	Version: 2.0
	
	Alternativer XML Eintrag:
	
<!--Variable Kapazität Anfang-->
	<variableGrainTankCapacity addMin="0.01" addMax="0.08" removeMin="0.005" removeMax="0.02" hudPosX="0.05" hudPosY="0.012"/> 
	<!-- Die hier eingetragen Zahlen werden mit der Zahl aus dem Abschnitt 'grainTankCapacity' multipliziert.
	Hat man nun eine Kapazität von '2000' würden die Werte wie folgt aussehen:
	addMin = '20' addMax = '160' removeMin = '10' removeMax = '40'
	Den: 2000*0.01 = '20', 2000*0.08 = '160', 2000*0.005 = '10' und 2000*0.02 = '40'
	Mit den Werten bei 'hudPosX' und 'hudPosY' kann man die Postion des Huds verändern. Muss man aber nicht angeben.
Variable Kapazität Ende-->
]]

VariableCapacityCombine = {}

local variableCapacityCombine_directory = g_currentModDirectory;

function VariableCapacityCombine.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function VariableCapacityCombine:load(xmlFile)
	self.grainTankCapacityStart = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankCapacity"), 0);
	
	self.addGrainTankCapacityMinXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableGrainTankCapacity#addMin"), 0.01);
	self.addGrainTankCapacityMaxXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableGrainTankCapacity#addMax"), 0.08);
	
	self.removeGrainTankCapacityMinXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableGrainTankCapacity#removeMin"), 0.005);
	self.removeGrainTankCapacityMaxXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableGrainTankCapacity#removeMax"), 0.02);
	
	self.addGrainTankCapacityMin = self.grainTankCapacityStart * self.addGrainTankCapacityMinXml;
	self.addGrainTankCapacityMax = self.grainTankCapacityStart * self.addGrainTankCapacityMaxXml;
	
	self.removeGrainTankCapacityMin = self.grainTankCapacityStart * self.removeGrainTankCapacityMinXml;
	self.removeGrainTankCapacityMax = self.grainTankCapacityStart * self.removeGrainTankCapacityMaxXml;
	
	self.addGrainTankCapacityTime = false;
	self.newAddGrainTankCapacity = 0;
	self.newRemoveGrainTankCapacity = 0;
	self.grainTankCapacityTime = 0;
	
	self.setNewGrainTankCapacity = false;
	self.allowAddGrainTankCapacity = true;
	self.showHud = true;
	
	self.VariableCapacityCombineHudPosX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableGrainTankCapacity#hudPosX"), 0.05);
    self.VariableCapacityCombineHudPosY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableGrainTankCapacity#hudPosY"), 0.012);
    self.VariableCapacityCombineHudWidth = 0.42;
    self.VariableCapacityCombineHudHeight = 0.23;
	
	self.VariableCapacityCombineOverlayFilenameOld = 
		Utils.getFilename("GUI/VariableCapacity_Hud_Old.png", 
		variableCapacityCombine_directory
	);
	self.VariableCapacityCombineOverlayOld = 
		Overlay:new("VariableCapacityCombineOverlayOld", 
		self.VariableCapacityCombineOverlayFilenameOld, 
		self.VariableCapacityCombineHudPosX, 
		self.VariableCapacityCombineHudPosY, 
		self.VariableCapacityCombineHudWidth, 
		self.VariableCapacityCombineHudHeight
	);
	
	self.VariableCapacityCombineOverlayFilenameNew = 
		Utils.getFilename("GUI/VariableCapacity_Hud_New.png", 
		variableCapacityCombine_directory
	);
	self.VariableCapacityCombineOverlayNew = 
		Overlay:new("VariableCapacityCombineOverlayNew", 
		self.VariableCapacityCombineOverlayFilenameNew, 
		self.VariableCapacityCombineHudPosX, 
		self.VariableCapacityCombineHudPosY, 
		self.VariableCapacityCombineHudWidth, 
		self.VariableCapacityCombineHudHeight
	);
end;

function VariableCapacityCombine:delete()
end;

function VariableCapacityCombine:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableCapacityCombine:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableCapacityCombine:update(dt)
	local isPdaOpen = Utils.getNoNil(g_currentMission.missionPDA.showPDA, false) or Utils.getNoNil(self.acGuiActive, false);
	
	if self:getIsActive() and self.isClient then
		if InputBinding.hasEvent(InputBinding.ADD_CAPACITY_BUTTON) then
			if self.allowAddGrainTankCapacity then
				self.allowAddGrainTankCapacity = false;
			else
				self.allowAddGrainTankCapacity = true;
				if self.grainTankCapacityTime < 2 then
					self.grainTankCapacity = self.grainTankCapacityStart + self.newAddGrainTankCapacity;
				else
					self.grainTankCapacity = self.grainTankCapacityStart - self.newRemoveGrainTankCapacity;
				end;
			end;
		end;
		if not isPdaOpen then
			if InputBinding.hasEvent(InputBinding.SHOW_HUD_BUTTON) then
				if self.showHud then
					self.showHud = false;
				else
					self.showHud = true;
				end;
			end;
		end;
		if (self.grainTankFillLevel > 0 and self.grainTankFillLevel < self.grainTankCapacity) and self.allowAddGrainTankCapacity then
			if InputBinding.hasEvent(InputBinding.SET_NEW_CAPACITY_BUTTON) then
				if self.setNewGrainTankCapacity then
					self.setNewGrainTankCapacity = false;
				else
					self.setNewGrainTankCapacity = true;
				end;
			end;
		end;
	end;
end;

function VariableCapacityCombine:updateTick(dt)
	if self.allowAddGrainTankCapacity then
		if self.grainTankCapacity > 0 then
			if (self.grainTankFillLevel == 0 and self.grainTankFillLevel < self.grainTankCapacity) or self.setNewGrainTankCapacity then
				self.addGrainTankCapacityTime = true;
				self.newAddGrainTankCapacity = math.random(self.addGrainTankCapacityMin, self.addGrainTankCapacityMax);
				self.newRemoveGrainTankCapacity = math.random(self.removeGrainTankCapacityMin, self.removeGrainTankCapacityMax);
				if self.grainTankCapacityTime < 2 then
					self.grainTankCapacity = self.grainTankCapacityStart - self.newRemoveGrainTankCapacity;
				else
					self.grainTankCapacity = self.grainTankCapacityStart + self.newAddGrainTankCapacity;
					self.grainTankCapacityTime = 0;
				end;
			else
				self.addGrainTankCapacityTime = false;
			end;
			if self.addGrainTankCapacityTime then
				self.grainTankCapacityTime = self.grainTankCapacityTime + 1;
			end;	
		end;
	else
		self.grainTankCapacity = self.grainTankCapacityStart;
		if self.grainTankFillLevel > self.grainTankCapacityStart then
			self.grainTankFillLevel = self.grainTankCapacityStart;
		end;
	end;
end;

function VariableCapacityCombine:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'newGrainTankCapacity="' .. self.grainTankCapacity .. '" newAddGrainTankCapacity="' .. self.newAddGrainTankCapacity .. '" newRemoveGrainTankCapacity="' .. self.newRemoveGrainTankCapacity .. '" grainTankCapacityTime="' .. self.grainTankCapacityTime .. '"';
	return attributes;
end;

function VariableCapacityCombine:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local newGrainTankCapacity = getXMLInt(xmlFile, key .. "#newGrainTankCapacity");
	local newGrainTankFillLevel = getXMLInt(xmlFile, key .. "#grainTankFillLevel");
	local newAddGrainTankCapacity = getXMLInt(xmlFile, key .. "#newAddGrainTankCapacity");
	local newRemoveGrainTankCapacity = getXMLInt(xmlFile, key .. "#newRemoveGrainTankCapacity");
	local grainTankCapacityTime = getXMLInt(xmlFile, key .. "#grainTankCapacityTime");
	
	if newGrainTankCapacity ~= nil then
		self.grainTankCapacity = newGrainTankCapacity;
	end;
	
	if newGrainTankFillLevel ~= nil then
		self.grainTankFillLevel = newGrainTankFillLevel;
	end;
	
	if newAddGrainTankCapacity ~= nil then
		self.newAddGrainTankCapacity = newAddGrainTankCapacity;
	end;
	
	if newRemoveGrainTankCapacity ~= nil then
		self.newRemoveGrainTankCapacity = newRemoveGrainTankCapacity;
	end;
	
	if grainTankCapacityTime ~= nil then
		self.grainTankCapacityTime = grainTankCapacityTime;
	end;
	 
	return BaseMission.VEHICLE_LOAD_OK;
end;

function VariableCapacityCombine:draw()
	local GrainTankFillLevel = string.format(math.floor(self.grainTankFillLevel));
	local GrainTankFillLevelString = string.format("%d [l]", GrainTankFillLevel);
	local GrainTankCapacityStart = string.format(math.floor(self.grainTankCapacityStart));
	local GrainTankCapacityStartString = string.format("%d [l]", GrainTankCapacityStart);
	
	local NewAddGrainTankCapacity = string.format(math.floor(self.newAddGrainTankCapacity));
	local NewAddGrainTankCapacityString = string.format("%d [l]", NewAddGrainTankCapacity);
	local AddGrainTankCapacityMin = string.format(math.floor(self.addGrainTankCapacityMin));
	local AddGrainTankCapacityMinString = string.format("%d [l]", AddGrainTankCapacityMin);
	local AddGrainTankCapacityMax = string.format(math.floor(self.addGrainTankCapacityMax));
	local AddGrainTankCapacityMaxString = string.format("%d [l]", AddGrainTankCapacityMax);
	
	local NewRemoveGrainTankCapacity = string.format(math.floor(self.newRemoveGrainTankCapacity));
	local NewRemoveGrainTankCapacityString = string.format("%d [l]", NewRemoveGrainTankCapacity);
	local RemoveGrainTankCapacityMin = string.format(math.floor(self.removeGrainTankCapacityMin));
	local RemoveGrainTankCapacityMinString = string.format("%d [l]", RemoveGrainTankCapacityMin);
	local RemoveGrainTankCapacityMax = string.format(math.floor(self.removeGrainTankCapacityMax));
	local RemoveGrainTankCapacityMaxString = string.format("%d [l]", RemoveGrainTankCapacityMax);
	
	local GrainTankCapacity = string.format(math.floor(self.grainTankCapacity));
	local GrainTankCapacityString = string.format("%d [l]", GrainTankCapacity);
	
	local isPdaOpen = Utils.getNoNil(g_currentMission.missionPDA.showPDA, false) or Utils.getNoNil(self.acGuiActive, false);
	
	if self.grainTankCapacity > 0 then
		if self.allowAddGrainTankCapacity then
			g_currentMission:addHelpButtonText(Combine.NOT_ALLOW_ADD_CAPACITY, InputBinding.ADD_CAPACITY_BUTTON);
			if self.grainTankFillLevel > 0 and self.grainTankFillLevel < self.grainTankCapacity then
				if self.setNewGrainTankCapacity then
					g_currentMission:addExtraPrintText(Combine.STOP_SET_NEW_CAPACITY .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.SET_NEW_CAPACITY_BUTTON));
				else
					g_currentMission:addExtraPrintText(Combine.SET_NEW_CAPACITY .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.SET_NEW_CAPACITY_BUTTON));
				end;
			end;
		else
			g_currentMission:addHelpButtonText(Combine.ALLOW_ADD_CAPACITY, InputBinding.ADD_CAPACITY_BUTTON);
		end;
		if self.showHud then
			if not isPdaOpen then
				if g_newGUISkin then
					self.VariableCapacityCombineOverlayNew:render();
				else
					self.VariableCapacityCombineOverlayOld:render();
				end;
				
				setTextBold(true);
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextColor(1, 1, 1, 1);
				
				renderText(
					self.VariableCapacityCombineHudPosX + 0.035, 
					self.VariableCapacityCombineHudPosY + 0.19, 
					0.02, 
					(Combine.VERSION)
				);
				renderText(
					self.VariableCapacityCombineHudPosX + 0.015, 
					self.VariableCapacityCombineHudPosY + 0.15, 
					0.02, 
					(Combine.GRAINTANK_FILL_LEVEL)
				);
				renderText(
					self.VariableCapacityCombineHudPosX + 0.015, 
					self.VariableCapacityCombineHudPosY + 0.13, 
					0.02, 
					(Combine.GRAINTANK_CAPACITY)
				);
				if self.grainTankCapacityTime < 2 then
					renderText(
						self.VariableCapacityCombineHudPosX + 0.015, 
						self.VariableCapacityCombineHudPosY + 0.11, 
						0.02, 
						(Combine.GRAINTANK_CAPACITY_ADDED)
					);
					if self.newAddGrainTankCapacity > 0 then
						if self.allowAddGrainTankCapacity then
							renderText(
								self.VariableCapacityCombineHudPosX + 0.015, 
								self.VariableCapacityCombineHudPosY + 0.09, 
								0.02, 
								(Combine.ADD_GRAINTANK_CAPACITY_ACTIVE)
							);
						else
							renderText(
								self.VariableCapacityCombineHudPosX + 0.015, 
								self.VariableCapacityCombineHudPosY + 0.09, 
								0.02, 
								(Combine.ADD_GRAINTANK_CAPACITY_NOT_ACTIVE)
							);
						end;
					else
						renderText(
							self.VariableCapacityCombineHudPosX + 0.015, 
							self.VariableCapacityCombineHudPosY + 0.09, 
							0.02, 
							(Combine.ADD_GRAINTANK_CAPACITY_NOT_ACTIVE)
						);
					end;
					renderText(
						self.VariableCapacityCombineHudPosX + 0.015, 
						self.VariableCapacityCombineHudPosY + 0.07, 
						0.02, 
						(Combine.ADD_GRAINTANK_CAPACITY_MIN)
					);
					renderText(
						self.VariableCapacityCombineHudPosX + 0.015, 
						self.VariableCapacityCombineHudPosY + 0.05, 
						0.02, 
						(Combine.ADD_GRAINTANK_CAPACITY_MAX)
					);
				else
					renderText(
						self.VariableCapacityCombineHudPosX + 0.015, 
						self.VariableCapacityCombineHudPosY + 0.11, 
						0.02, 
						(Combine.GRAINTANK_CAPACITY_REMOVED)
					);
					if self.newRemoveGrainTankCapacity > 0 then
						if self.allowAddGrainTankCapacity then
							renderText(
								self.VariableCapacityCombineHudPosX + 0.015, 
								self.VariableCapacityCombineHudPosY + 0.09, 
								0.02, 
								(Combine.REMOVE_GRAINTANK_CAPACITY_ACTIVE)
							);
						else
							renderText(
								self.VariableCapacityCombineHudPosX + 0.015, 
								self.VariableCapacityCombineHudPosY + 0.09, 
								0.02, 
								(Combine.REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE)
							);
						end;
					else
						renderText(
							self.VariableCapacityCombineHudPosX + 0.015, 
							self.VariableCapacityCombineHudPosY + 0.09, 
							0.02, 
							(Combine.REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE)
						);
					end;
					renderText(
						self.VariableCapacityCombineHudPosX + 0.015, 
						self.VariableCapacityCombineHudPosY + 0.07, 
						0.02, 
						(Combine.REMOVE_GRAINTANK_CAPACITY_MIN)
					);
					renderText(
						self.VariableCapacityCombineHudPosX + 0.015, 
						self.VariableCapacityCombineHudPosY + 0.05, 
						0.02, 
						(Combine.REMOVE_GRAINTANK_CAPACITY_MAX)
					);
				end;
				renderText(
					self.VariableCapacityCombineHudPosX + 0.015, 
					self.VariableCapacityCombineHudPosY + 0.03,
					0.02, 
					(Combine.NEW_GRAINTANK_CAPACITY)
				);
				
				setTextAlignment(RenderText.ALIGN_RIGHT);
				
				renderText(
					self.VariableCapacityCombineHudPosX + 0.4, 
					self.VariableCapacityCombineHudPosY + 0.15, 
					0.02, 
					(GrainTankFillLevelString)
				);
				renderText(
					self.VariableCapacityCombineHudPosX + 0.4, 
					self.VariableCapacityCombineHudPosY + 0.13, 
					0.02, 
					(GrainTankCapacityStartString)
				);
				if self.grainTankCapacityTime < 2 then
					renderText(
						self.VariableCapacityCombineHudPosX + 0.4, 
						self.VariableCapacityCombineHudPosY + 0.11, 
						0.02, 
						(NewAddGrainTankCapacityString)
					);
					renderText(
						self.VariableCapacityCombineHudPosX + 0.4, 
						self.VariableCapacityCombineHudPosY + 0.07, 
						0.02, 
						(AddGrainTankCapacityMinString)
					);
					renderText(
						self.VariableCapacityCombineHudPosX + 0.4, 
						self.VariableCapacityCombineHudPosY + 0.05, 
						0.02, 
						(AddGrainTankCapacityMaxString)
					);
				else
					renderText(
						self.VariableCapacityCombineHudPosX + 0.4, 
						self.VariableCapacityCombineHudPosY + 0.11, 
						0.02, 
						(NewRemoveGrainTankCapacityString)
					);
					renderText(
						self.VariableCapacityCombineHudPosX + 0.4, 
						self.VariableCapacityCombineHudPosY + 0.07, 
						0.02, 
						(RemoveGrainTankCapacityMinString)
					);
					renderText(
						self.VariableCapacityCombineHudPosX + 0.4, 
						self.VariableCapacityCombineHudPosY + 0.05, 
						0.02, 
						(RemoveGrainTankCapacityMaxString)
					);
				end;
				renderText(
					self.VariableCapacityCombineHudPosX + 0.4, 
					self.VariableCapacityCombineHudPosY + 0.03, 
					0.02, 
					(GrainTankCapacityString)
				);
				
				g_currentMission:addHelpButtonText(Combine.HIDE_HUD, InputBinding.SHOW_HUD_BUTTON);
			else
				if self.grainTankCapacityTime < 2 then
					g_currentMission:addExtraPrintText(Combine.GRAINTANK_CAPACITY_ADDED .. " " .. NewAddGrainTankCapacityString);
					if self.newAddGrainTankCapacity > 0 then
						if self.allowAddGrainTankCapacity then
							g_currentMission:addExtraPrintText(Combine.ADD_GRAINTANK_CAPACITY_ACTIVE);
						else
							g_currentMission:addExtraPrintText(Combine.ADD_GRAINTANK_CAPACITY_NOT_ACTIVE);
						end;
					else
						g_currentMission:addExtraPrintText(Combine.ADD_GRAINTANK_CAPACITY_NOT_ACTIVE);
					end;
				else
					g_currentMission:addExtraPrintText(Combine.GRAINTANK_CAPACITY_REMOVED .. " " .. NewRemoveGrainTankCapacityString);
					if self.newRemoveGrainTankCapacity > 0 then
						if self.allowAddGrainTankCapacity then
							g_currentMission:addExtraPrintText(Combine.REMOVE_GRAINTANK_CAPACITY_ACTIVE);
						else
							g_currentMission:addExtraPrintText(Combine.REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE);
						end;
					else
						g_currentMission:addExtraPrintText(Combine.REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE);
					end;
				end;
				g_currentMission:addExtraPrintText(Combine.NEW_GRAINTANK_CAPACITY .. " " .. GrainTankCapacityString);
			end;
		else
			if self.grainTankCapacityTime < 2 then
				g_currentMission:addExtraPrintText(Combine.GRAINTANK_CAPACITY_ADDED .. " " .. NewAddGrainTankCapacityString);
				if self.newAddGrainTankCapacity > 0 then
					if self.allowAddGrainTankCapacity then
						g_currentMission:addExtraPrintText(Combine.ADD_GRAINTANK_CAPACITY_ACTIVE);
					else
						g_currentMission:addExtraPrintText(Combine.ADD_GRAINTANK_CAPACITY_NOT_ACTIVE);
					end;
				else
					g_currentMission:addExtraPrintText(Combine.ADD_GRAINTANK_CAPACITY_NOT_ACTIVE);
				end;
			else
				g_currentMission:addExtraPrintText(Combine.GRAINTANK_CAPACITY_REMOVED .. " " .. NewRemoveGrainTankCapacityString);
				if self.newRemoveGrainTankCapacity > 0 then
					if self.allowAddGrainTankCapacity then
						g_currentMission:addExtraPrintText(Combine.REMOVE_GRAINTANK_CAPACITY_ACTIVE);
					else
						g_currentMission:addExtraPrintText(Combine.REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE);
					end;
				else
					g_currentMission:addExtraPrintText(Combine.REMOVE_GRAINTANK_CAPACITY_NOT_ACTIVE);
				end;
			end;
			g_currentMission:addExtraPrintText(Combine.NEW_GRAINTANK_CAPACITY .. " " .. GrainTankCapacityString);
		
			if not isPdaOpen then
				g_currentMission:addHelpButtonText(Combine.SHOW_HUD, InputBinding.SHOW_HUD_BUTTON);
			end;
		end;
	end;
end;