--[[
	EN: 'VariableCapacityBaler' Specialization for baler's and forageWagon's.
	
	DE: 'VariableCapacityBaler' Spezialisierung für Ballenpressen und Ladewagen.
	
	Autor: Ifko[nator]
	Datum: 08.08.2014
	Version: 2.0
	
	Alternativer XML Eintrag:
	
<!--Variable Kapazität Anfang-->
	<variableCapacity addMin="0.01" addMax="0.08" removeMin="0.005" removeMax="0.02" hudPosX="0.05" hudPosY="0.012"/> 
	<!-- Die hier eingetragen Zahlen werden mit der Zahl aus dem Abschnitt 'capacity' multipliziert.
	Hat man nun eine Kapazität von '2000' würden die Werte wie folgt aussehen:
	addMin = '20' addMax = '160' removeMin = '10' removeMax = '40'
	Den: 2000*0.01 = '20', 2000*0.08 = '160', 2000*0.005 = '10' und 2000*0.02 = '40'
	Mit den Werten bei 'hudPosX' und 'hudPosY' kann man die Postion des Huds verändern. Muss man aber nicht angeben.
Variable Kapazität Ende-->
]]

VariableCapacityBaler = {}

local variableCapacityBaler_directory = g_currentModDirectory;

function VariableCapacityBaler.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function VariableCapacityBaler:load(xmlFile)
	self.capacityStart = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0);
	
	self.addCapacityMinXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#addMin"), 0.005);
	self.addCapacityMaxXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#addMax"), 0.01);
	
	self.removeCapacityMinXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#removeMin"), 0.0025);
	self.removeCapacityMaxXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#removeMax"), 0.008);
	
	self.addCapacityMin = self.capacityStart * self.addCapacityMinXml;
	self.addCapacityMax = self.capacityStart * self.addCapacityMaxXml;
	
	self.removeCapacityMin = self.capacityStart * self.removeCapacityMinXml;
	self.removeCapacityMax = self.capacityStart * self.removeCapacityMaxXml;
	
	self.addCapacityTime = false;
	self.newAddCapacity = 0;
	self.newRemoveCapacity = 0;
	self.capacityTime = 0;
	
	self.setNewCapacity = false;
	self.allowAddCapacity = true;
	self.showHud = true;
	
	self.VariableCapacityBalerHudPosX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#hudPosX"), 0.05);
    self.VariableCapacityBalerHudPosY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#hudPosY"), 0.012);
    self.VariableCapacityBalerHudWidth = 0.42;
    self.VariableCapacityBalerHudHeight = 0.23;
	
	self.VariableCapacityBalerOverlayFilenameOld = 
		Utils.getFilename("GUI/VariableCapacity_Hud_Old.png", 
		variableCapacityBaler_directory
	);
	self.VariableCapacityBalerOverlayOld = 
		Overlay:new("VariableCapacityBalerOverlayOld", 
		self.VariableCapacityBalerOverlayFilenameOld, 
		self.VariableCapacityBalerHudPosX, 
		self.VariableCapacityBalerHudPosY, 
		self.VariableCapacityBalerHudWidth, 
		self.VariableCapacityBalerHudHeight
	);
	
	self.VariableCapacityBalerOverlayFilenameNew = 
		Utils.getFilename("GUI/VariableCapacity_Hud_New.png", 
		variableCapacityBaler_directory
	);
	self.VariableCapacityBalerOverlayNew = 
		Overlay:new("VariableCapacityBalerOverlayNew", 
		self.VariableCapacityBalerOverlayFilenameNew, 
		self.VariableCapacityBalerHudPosX, 
		self.VariableCapacityBalerHudPosY, 
		self.VariableCapacityBalerHudWidth, 
		self.VariableCapacityBalerHudHeight
	);
end;

function VariableCapacityBaler:delete()
end;

function VariableCapacityBaler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableCapacityBaler:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableCapacityBaler:update(dt)
	local isPdaOpen = Utils.getNoNil(g_currentMission.missionPDA.showPDA, false) or Utils.getNoNil(self.acGuiActive, false);
	
	if self:getIsActive() and self.isClient then
		if InputBinding.hasEvent(InputBinding.ADD_CAPACITY_BUTTON) then
			if self.allowAddCapacity then
				self.allowAddCapacity = false;
			else
				self.allowAddCapacity = true;
				if self.capacityTime < 2 then
					self.capacity = self.capacityStart - self.newRemoveCapacity;
				else 
					self.capacity = self.capacityStart + self.newAddCapacity;
				end;
			end;
		end;
		if not isPdaOpen then
			if InputBinding.hasEvent(InputBinding.SHOW_HUD_BUTTON) then
				if self.showHud then
					self.showHud = false;
				else
					self.showHud = true;
				end;
			end;
		end;
		if (self.fillLevel >= (self.capacity * 0.05) and self.fillLevel < self.capacity) and self.allowAddCapacity then
			if InputBinding.hasEvent(InputBinding.SET_NEW_CAPACITY_BUTTON) then
				if self.setNewCapacity then
					self.setNewCapacity = false;
				else
					self.setNewCapacity = true;
				end;
			end;
		end;
	end;
end;

function VariableCapacityBaler:updateTick(dt)
	if self.allowAddCapacity then
		if self.capacity > 0 then
			if (self.fillLevel < (self.capacity * 0.05) and self.fillLevel < self.capacity) or self.setNewCapacity then
				self.addCapacityTime = true;
				self.newAddCapacity = math.random(self.addCapacityMin, self.addCapacityMax);
				self.newRemoveCapacity = math.random(self.removeCapacityMin, self.removeCapacityMax);
				if self.capacityTime < 2 then
					self.capacity = self.capacityStart + self.newAddCapacity;
				else
					self.capacity = self.capacityStart - self.newRemoveCapacity;
					self.capacityTime = 0;
				end;
			else
				self.addCapacityTime = false;
			end;
			if self.addCapacityTime then
				self.capacityTime = self.capacityTime + 1;
			end;
		end;
	else
		self.capacity = self.capacityStart;
		if self.fillLevel > self.capacityStart then
			self.fillLevel = self.capacityStart;
		end;
	end;
end;

function VariableCapacityBaler:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'newCapacity="' .. self.capacity .. '" newAddCapacity="' .. self.newAddCapacity .. '" newRemoveCapacity="' .. self.newRemoveCapacity .. '" capacityTime="' .. self.capacityTime .. '"';
	return attributes;
end;

function VariableCapacityBaler:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local newCapacity = getXMLInt(xmlFile, key .. "#newCapacity");
	local newFillLevel = getXMLInt(xmlFile, key .. "#fillLevel");
	local newAddCapacity = getXMLInt(xmlFile, key .. "#newAddCapacity");
	local newRemoveCapacity = getXMLInt(xmlFile, key .. "#newRemoveCapacity");
	local capacityTime = getXMLInt(xmlFile, key .. "#capacityTime");
	
	if newCapacity ~= nil then
		self.capacity = newCapacity;	
	end;
	
	if newFillLevel ~= nil then
		self.fillLevel = newFillLevel;
	end;
	
	if newAddCapacity ~= nil then
		self.newAddCapacity = newAddCapacity;
	end;
	
	if newRemoveCapacity ~= nil then
		self.newRemoveCapacity = newRemoveCapacity;
	end;
	
	if capacityTime ~= nil then
		self.capacityTime = capacityTime;
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function VariableCapacityBaler:draw()
	local FillLevel = string.format(math.floor(self.fillLevel));
	local FillLevelString = string.format("%d [l]", FillLevel);
	local CapacityStart = string.format(math.floor(self.capacityStart));
	local CapacityStartString = string.format("%d [l]", CapacityStart);
	
	local NewAddCapacity = string.format(math.floor(self.newAddCapacity));
	local NewAddCapacityString = string.format("%d [l]", NewAddCapacity);
	local AddCapacityMin = string.format(math.floor(self.addCapacityMin));
	local AddCapacityMinString = string.format("%d [l]", AddCapacityMin);
	local AddCapacityMax = string.format(math.floor(self.addCapacityMax));
	local AddCapacityMaxString = string.format("%d [l]", AddCapacityMax);
	
	local NewRemoveCapacity = string.format(math.floor(self.newRemoveCapacity));
	local NewRemoveCapacityString = string.format("%d [l]", NewRemoveCapacity);
	local RemoveCapacityMin = string.format(math.floor(self.removeCapacityMin));
	local RemoveCapacityMinString = string.format("%d [l]", RemoveCapacityMin);
	local RemoveCapacityMax = string.format(math.floor(self.removeCapacityMax));
	local RemoveCapacityMaxString = string.format("%d [l]", RemoveCapacityMax);
	
	local Capacity = string.format(math.floor(self.capacity));
	local CapacityString = string.format("%d [l]", Capacity);
	
	local isPdaOpen = Utils.getNoNil(g_currentMission.missionPDA.showPDA, false) or Utils.getNoNil(self.acGuiActive, false);

	if self.capacity > 0 then
		if self.allowAddCapacity then
			g_currentMission:addHelpButtonText(Baler.NOT_ALLOW_ADD_CAPACITY, InputBinding.ADD_CAPACITY_BUTTON);
			if self.fillLevel >= (self.capacity * 0.05) and self.fillLevel < self.capacity then
				if self.setNewCapacity then
					g_currentMission:addExtraPrintText(Baler.STOP_SET_NEW_CAPACITY .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.SET_NEW_CAPACITY_BUTTON));
				else
					g_currentMission:addExtraPrintText(Baler.SET_NEW_CAPACITY .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.SET_NEW_CAPACITY_BUTTON));
				end;
			end;
		else
			g_currentMission:addHelpButtonText(Baler.ALLOW_ADD_CAPACITY, InputBinding.ADD_CAPACITY_BUTTON);
		end;
		if self.showHud then
			if not isPdaOpen then
				if g_newGUISkin then
					self.VariableCapacityBalerOverlayNew:render();
				else
					self.VariableCapacityBalerOverlayOld:render();
				end;
				
				setTextBold(true);
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextColor(1, 1, 1, 1);
				
				renderText(
					self.VariableCapacityBalerHudPosX + 0.035, 
					self.VariableCapacityBalerHudPosY + 0.19, 
					0.02, 
					(Baler.VERSION)
				);
				renderText(
					self.VariableCapacityBalerHudPosX + 0.015, 
					self.VariableCapacityBalerHudPosY + 0.15, 
					0.02, 
					(Baler.FILL_LEVEL)
				);
				renderText(
					self.VariableCapacityBalerHudPosX + 0.015, 
					self.VariableCapacityBalerHudPosY + 0.13, 
					0.02, 
					(Baler.CAPACITY)
				);
				if self.capacityTime < 2 then
					renderText(
						self.VariableCapacityBalerHudPosX + 0.015, 
						self.VariableCapacityBalerHudPosY + 0.11, 
						0.02, 
						(Baler.CAPACITY_REMOVED)
					);
					if self.newRemoveCapacity > 0 then
						if self.allowAddCapacity then
							renderText(
								self.VariableCapacityBalerHudPosX + 0.015, 
								self.VariableCapacityBalerHudPosY + 0.09, 
								0.02, 
								(Baler.REMOVE_CAPACITY_ACTIVE)
							);
						else
							renderText(
								self.VariableCapacityBalerHudPosX + 0.015, 
								self.VariableCapacityBalerHudPosY + 0.09, 
								0.02, 
								(Baler.REMOVE_CAPACITY_NOT_ACTIVE)
							);
						end;
					else
						renderText(
							self.VariableCapacityBalerHudPosX + 0.015, 
							self.VariableCapacityBalerHudPosY + 0.09, 
							0.02, 
							(Baler.REMOVE_CAPACITY_NOT_ACTIVE)
						);
					end;
					renderText(
						self.VariableCapacityBalerHudPosX + 0.015, 
						self.VariableCapacityBalerHudPosY + 0.07, 
						0.02, 
						(Baler.REMOVE_CAPACITY_MIN)
					);
					renderText(
						self.VariableCapacityBalerHudPosX + 0.015, 
						self.VariableCapacityBalerHudPosY + 0.05, 
						0.02, 
						(Baler.REMOVE_CAPACITY_MAX)
					);
				else
					renderText(
						self.VariableCapacityBalerHudPosX + 0.015, 
						self.VariableCapacityBalerHudPosY + 0.11, 
						0.02, 
						(Baler.CAPACITY_ADDED)
					);
					if self.newAddCapacity > 0 then
						if self.allowAddCapacity then
							renderText(
								self.VariableCapacityBalerHudPosX + 0.015, 
								self.VariableCapacityBalerHudPosY + 0.09, 
								0.02, 
								(Baler.ADD_CAPACITY_ACTIVE)
							);
						else
							renderText(
								self.VariableCapacityBalerHudPosX + 0.015, 
								self.VariableCapacityBalerHudPosY + 0.09, 
								0.02, 
								(Baler.ADD_CAPACITY_NOT_ACTIVE)
							);
						end;
					else
						renderText(
							self.VariableCapacityBalerHudPosX + 0.015, 
							self.VariableCapacityBalerHudPosY + 0.09, 
							0.02, 
							(Baler.ADD_CAPACITY_NOT_ACTIVE)
						);
					end;
					renderText(
						self.VariableCapacityBalerHudPosX + 0.015, 
						self.VariableCapacityBalerHudPosY + 0.07, 
						0.02, 
						(Baler.ADD_CAPACITY_MIN)
					);
					renderText(
						self.VariableCapacityBalerHudPosX + 0.015, 
						self.VariableCapacityBalerHudPosY + 0.05, 
						0.02, 
						(Baler.ADD_CAPACITY_MAX)
					);
				end;
				renderText(
					self.VariableCapacityBalerHudPosX + 0.015, 
					self.VariableCapacityBalerHudPosY + 0.03, 
					0.02, 
					(Baler.NEW_CAPACITY)
				);
				
				setTextAlignment(RenderText.ALIGN_RIGHT);
				
				renderText(
					self.VariableCapacityBalerHudPosX + 0.4, 
					self.VariableCapacityBalerHudPosY + 0.15,
					0.02, 
					(FillLevelString)
				);
				renderText(
					self.VariableCapacityBalerHudPosX + 0.4, 
					self.VariableCapacityBalerHudPosY + 0.13, 
					0.02, 
					(CapacityStartString)
				);
				if self.capacityTime < 2 then
					renderText(
						self.VariableCapacityBalerHudPosX + 0.4, 
						self.VariableCapacityBalerHudPosY + 0.11, 
						0.02, 
						(NewRemoveCapacityString)
					);
					renderText(
						self.VariableCapacityBalerHudPosX + 0.4, 
						self.VariableCapacityBalerHudPosY + 0.07, 
						0.02, 
						(RemoveCapacityMinString)
					);
					renderText(
						self.VariableCapacityBalerHudPosX + 0.4, 
						self.VariableCapacityBalerHudPosY + 0.05, 
						0.02, 
						(RemoveCapacityMaxString)
					);
				else
					renderText(
						self.VariableCapacityBalerHudPosX + 0.4, 
						self.VariableCapacityBalerHudPosY + 0.11, 
						0.02, 
						(NewAddCapacityString)
					);
					renderText(
						self.VariableCapacityBalerHudPosX + 0.4, 
						self.VariableCapacityBalerHudPosY + 0.07, 
						0.02, 
						(AddCapacityMinString)
					);
					renderText(
						self.VariableCapacityBalerHudPosX + 0.4, 
						self.VariableCapacityBalerHudPosY + 0.05, 
						0.02, 
						(AddCapacityMaxString)
					);
				end;
				renderText(
					self.VariableCapacityBalerHudPosX + 0.4, 
					self.VariableCapacityBalerHudPosY + 0.03, 
					0.02, 
					(CapacityString)
				);
				
				g_currentMission:addHelpButtonText(Baler.HIDE_HUD, InputBinding.SHOW_HUD_BUTTON);
			else
				if self.capacityTime < 2 then
					g_currentMission:addExtraPrintText(Baler.CAPACITY_ADDED .. " " .. NewAddCapacityString);
					if self.newAddCapacity > 0 then
						if self.allowAddCapacity then
							g_currentMission:addExtraPrintText(Baler.ADD_CAPACITY_ACTIVE);
						else
							g_currentMission:addExtraPrintText(Baler.ADD_CAPACITY_NOT_ACTIVE);
						end;
					else
						g_currentMission:addExtraPrintText(Baler.ADD_CAPACITY_NOT_ACTIVE);
					end;
				else
					g_currentMission:addExtraPrintText(Baler.CAPACITY_REMOVED .. " " .. NewRemoveCapacityString);
					if self.newRemoveCapacity > 0 then
						if self.allowAddCapacity then
							g_currentMission:addExtraPrintText(Baler.REMOVE_CAPACITY_ACTIVE);
						else
							g_currentMission:addExtraPrintText(Baler.REMOVE_CAPACITY_NOT_ACTIVE);
						end;
					else
						g_currentMission:addExtraPrintText(Baler.REMOVE_CAPACITY_NOT_ACTIVE);
					end;
				end;
				g_currentMission:addExtraPrintText(Baler.NEW_CAPACITY .. " " .. CapacityString);
			end;
		else
			if self.capacityTime < 2 then
				g_currentMission:addExtraPrintText(Baler.CAPACITY_ADDED .. " " .. NewAddCapacityString);
				if self.newAddCapacity > 0 then
					if self.allowAddCapacity then
						g_currentMission:addExtraPrintText(Baler.ADD_CAPACITY_ACTIVE);
					else
						g_currentMission:addExtraPrintText(Baler.ADD_CAPACITY_NOT_ACTIVE);
					end;
				else
					g_currentMission:addExtraPrintText(Baler.ADD_CAPACITY_NOT_ACTIVE);
				end;
			else
				g_currentMission:addExtraPrintText(Baler.CAPACITY_REMOVED .. " " .. NewRemoveCapacityString);
				if self.newRemoveCapacity > 0 then
					if self.allowAddCapacity then
						g_currentMission:addExtraPrintText(Baler.REMOVE_CAPACITY_ACTIVE);
					else
						g_currentMission:addExtraPrintText(Baler.REMOVE_CAPACITY_NOT_ACTIVE);
					end;
				else
					g_currentMission:addExtraPrintText(Baler.REMOVE_CAPACITY_NOT_ACTIVE);
				end;
			end;
			g_currentMission:addExtraPrintText(Baler.NEW_CAPACITY .. " " .. CapacityString);
			
			if not isPdaOpen then
				g_currentMission:addHelpButtonText(Baler.SHOW_HUD, InputBinding.SHOW_HUD_BUTTON);
			end;
		end;
	end;
end