--[[
	EN: 'VariableCapacityWheelLoader' Specialization for WheelLoader.
	
	DE: 'VariableCapacityWheelLoader' Spezialisierung für Radlader.
	
	Autor: Ifko[nator]
	Datum: 08.08.2014
	Version: 2.0
	
	Alternativer XML Eintrag:
	
<!--Variable Kapazität Anfang-->
	<variableCapacity addMin="0.01" addMax="0.08" removeMin="0.005" removeMax="0.02" hudPosX="0.05" hudPosY="0.012"/> 
	<!-- Die hier eingetragen Zahlen werden mit der Zahl aus dem Abschnitt 'capacity' multipliziert.
	Hat man nun eine Kapazität von '2000' würden die Werte wie folgt aussehen:
	addMin = '20' addMax = '160' removeMin = '10' removeMax = '40'
	Den: 2000*0.01 = '20', 2000*0.08 = '160', 2000*0.005 = '10' und 2000*0.02 = '40'
	Mit den Werten bei 'hudPosX' und 'hudPosY' kann man die Postion des Huds verändern. Muss man aber nicht angeben.
Variable Kapazität Ende-->
]]

VariableCapacityWheelLoader = {}

local VariableCapacityWheelLoader_directory = g_currentModDirectory;

function VariableCapacityWheelLoaderprerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function VariableCapacityWheelLoader:load(xmlFile)
	self.capacityStart = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0);
	
	self.addCapacityMinXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#addMin"), 0.01);
	self.addCapacityMaxXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#addMax"), 0.08);
	
	self.removeCapacityMinXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#removeMin"), 0.005);
	self.removeCapacityMaxXml = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#removeMax"), 0.02);
	
	self.addCapacityMin = self.capacityStart * self.addCapacityMinXml;
	self.addCapacityMaxStart = self.capacityStart * self.addCapacityMaxXml;
	self.addCapacityMax = self.addCapacityMaxStart;
	
	self.removeCapacityMin = self.capacityStart * self.removeCapacityMinXml;
	self.removeCapacityMax = self.capacityStart * self.removeCapacityMaxXml;
	
	self.addCapacityTime = false;
	self.newAddCapacity = 0;
	self.newRemoveCapacity = 0;
	self.capacityTime = 0;
	
	self.setNewCapacity = false;
	self.allowAddCapacity = true;
	self.showHud = true;
	
	self.VariableCapacityWheelLoaderHudPosX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#hudPosX"), 0.05);
    self.VariableCapacityWheelLoaderHudPosY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.variableCapacity#hudPosY"), 0.012);
    self.VariableCapacityWheelLoaderHudWidth = 0.42;
    self.VariableCapacityWheelLoaderHudHeight = 0.23;
	
	self.VariableCapacityWheelLoaderOverlayFilenameOld = 
		Utils.getFilename("GUI/VariableCapacity_Hud_Old.png", 
		VariableCapacityWheelLoader_directory
	);
	self.VariableCapacityWheelLoaderOverlayOld = 
		Overlay:new("VariableCapacityWheelLoaderOverlayOld", 
		self.VariableCapacityWheelLoaderOverlayFilenameOld, 
		self.VariableCapacityWheelLoaderHudPosX, 
		self.VariableCapacityWheelLoaderHudPosY, 
		self.VariableCapacityWheelLoaderHudWidth, 
		self.VariableCapacityWheelLoaderHudHeight
	);
	
	self.VariableCapacityWheelLoaderOverlayFilenameNew = 
		Utils.getFilename("GUI/VariableCapacity_Hud_New.png", 
		VariableCapacityWheelLoader_directory
	);
	self.VariableCapacityWheelLoaderOverlayNew = 
		Overlay:new("VariableCapacityWheelLoaderOverlayNew", 
		self.VariableCapacityWheelLoaderOverlayFilenameNew, 
		self.VariableCapacityWheelLoaderHudPosX, 
		self.VariableCapacityWheelLoaderHudPosY,
		self.VariableCapacityWheelLoaderHudWidth, 
		self.VariableCapacityWheelLoaderHudHeight
	);
end;

function VariableCapacityWheelLoader:delete()
end;

function VariableCapacityWheelLoader:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableCapacityWheelLoader:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableCapacityWheelLoader:update(dt)
	local isPdaOpen = Utils.getNoNil(g_currentMission.missionPDA.showPDA, false) or Utils.getNoNil(self.acGuiActive, false);
	
	if self:getIsActive() and self.isClient then
		if InputBinding.hasEvent(InputBinding.ADD_CAPACITY_BUTTON) then
			if self.allowAddCapacity then
				self.allowAddCapacity = false;
			else
				self.allowAddCapacity = true;
				if self.capacityTime < 2 then
					self.capacity = self.capacityStart + self.newAddCapacity;
				else
					self.capacity = self.capacityStart - self.newRemoveCapacity;
				end;
			end;
		end;
		if not isPdaOpen then
			if InputBinding.hasEvent(InputBinding.SHOW_HUD_BUTTON) then
				if self.showHud then
					self.showHud = false;
				else
					self.showHud = true;
				end;
			end;
		end;
		if (self.fillLevel >= (self.capacity * 0.01) and self.fillLevel < self.capacity) and self.allowAddCapacity then
			if InputBinding.hasEvent(InputBinding.SET_NEW_CAPACITY_BUTTON) then
				if self.setNewCapacity then
					self.setNewCapacity = false;
				else
					self.setNewCapacity = true;
				end;
			end;
		end;
	end;
end;

function VariableCapacityWheelLoader:updateTick(dt)
	if self.allowAddCapacity then
		if self.capacity > 0 then
			if (self.fillLevel < (self.capacity * 0.01) and self.fillLevel < self.capacity) or self.setNewCapacity then
				self.addCapacityTime = true;
				if self.currentFillType == Fillable.FILLTYPE_WHEAT 
					or self.currentFillType == Fillable.FILLTYPE_BARLEY
					or self.currentFillType == Fillable.FILLTYPE_OAT
					or self.currentFillType == Fillable.FILLTYPE_RYE
					or self.currentFillType == Fillable.FILLTYPE_WEED
					or self.currentFillType == Fillable.FILLTYPE_RAPE
					or self.currentFillType == Fillable.FILLTYPE_MAIZE
					or self.currentFillType == Fillable.FILLTYPE_FORAGE
					or self.currentFillType == Fillable.FILLTYPE_SUNFLOWER
				then	
					self.addCapacityMax = self.addCapacityMaxStart * 1.1;
				elseif self.currentFillType == Fillable.FILLTYPE_MANURE
					or self.currentFillType == Fillable.FILLTYPE_WHEAT_WINDROW
					or self.currentFillType == Fillable.FILLTYPE_BARLEY_WINDROW
					or self.currentFillType == Fillable.FILLTYPE_GRASS_WINDROW
					or self.currentFillType == Fillable.FILLTYPE_DRYGRASS_WINDROW
					or self.currentFillType == Fillable.FILLTYPE_SILAGE
				then
					self.addCapacityMax = self.addCapacityMaxStart * 1.3;
				elseif self.currentFillType == Fillable.FILLTYPE_POTATO
					or self.currentFillType == Fillable.FILLTYPE_SUGARBEET
				then
					self.addCapacityMax = self.addCapacityMaxStart * 0.3;
				elseif self.currentFillType == Fillable.FILLTYPE_CHAFF
					or self.currentFillType == Fillable.FILLTYPE_WOODCHIP
				then
					self.addCapacityMax = self.addCapacityMaxStart * 1.6;
				else
					self.addCapacityMax = self.addCapacityMaxStart;
				end;
				self.newAddCapacity = math.random(self.addCapacityMin, self.addCapacityMax);
				self.newRemoveCapacity = math.random(self.removeCapacityMin, self.removeCapacityMax);
				if self.capacityTime < 2 then
					self.capacity = self.capacityStart - self.newRemoveCapacity;
				else
					self.capacity = self.capacityStart + self.newAddCapacity;
					self.capacityTime = 0;
				end;
			else
				self.addCapacityTime = false;
			end;
			if self.addCapacityTime then
				self.capacityTime = self.capacityTime + 1;
			end;
		end;
	else
		self.capacity = self.capacityStart;
		if self.fillLevel > self.capacityStart then
			self.fillLevel = self.capacityStart;
		end;
	end;
end;

function VariableCapacityWheelLoader:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'newCapacity="' .. self.capacity .. '" newAddCapacity="' .. self.newAddCapacity .. '" newRemoveCapacity="' .. self.newRemoveCapacity .. '" capacityTime="' .. self.capacityTime .. '"';
	return attributes;
end;

function VariableCapacityWheelLoader:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local newCapacity = getXMLInt(xmlFile, key .. "#newCapacity");
	local newFillLevel = getXMLInt(xmlFile, key .. "#fillLevel");
	local newAddCapacity = getXMLInt(xmlFile, key .. "#newAddCapacity");
	local newRemoveCapacity = getXMLInt(xmlFile, key .. "#newRemoveCapacity");
	local capacityTime = getXMLInt(xmlFile, key .. "#capacityTime");
	
	if newCapacity ~= nil then
		self.capacity = newCapacity;	
	end;
	
	if newFillLevel ~= nil then
		self.fillLevel = newFillLevel;
	end;
	
	if newAddCapacity ~= nil then
		self.newAddCapacity = newAddCapacity;
	end;
	
	if newRemoveCapacity ~= nil then
		self.newRemoveCapacity = newRemoveCapacity;
	end;
	
	if capacityTime ~= nil then
		self.capacityTime = capacityTime;
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function VariableCapacityWheelLoader:draw()
	local FillLevel = string.format(math.floor(self.fillLevel));
	local FillLevelString = string.format("%d [l]", FillLevel);
	local CapacityStart = string.format(math.floor(self.capacityStart));
	local CapacityStartString = string.format("%d [l]", CapacityStart);
	
	local NewAddCapacity = string.format(math.floor(self.newAddCapacity));
	local NewAddCapacityString = string.format("%d [l]", NewAddCapacity);
	local AddCapacityMin = string.format(math.floor(self.addCapacityMin));
	local AddCapacityMinString = string.format("%d [l]", AddCapacityMin);
	local AddCapacityMax = string.format(math.floor(self.addCapacityMax));
	local AddCapacityMaxString = string.format("%d [l]", AddCapacityMax);
	
	local NewRemoveCapacity = string.format(math.floor(self.newRemoveCapacity));
	local NewRemoveCapacityString = string.format("%d [l]", NewRemoveCapacity);
	local RemoveCapacityMin = string.format(math.floor(self.removeCapacityMin));
	local RemoveCapacityMinString = string.format("%d [l]", RemoveCapacityMin);
	local RemoveCapacityMax = string.format(math.floor(self.removeCapacityMax));
	local RemoveCapacityMaxString = string.format("%d [l]", RemoveCapacityMax);
	
	local Capacity = string.format(math.floor(self.capacity));
	local CapacityString = string.format("%d [l]", Capacity);
	
	local isPdaOpen = Utils.getNoNil(g_currentMission.missionPDA.showPDA, false) or Utils.getNoNil(self.acGuiActive, false);

	if self.capacity > 0 then
		if self.allowAddCapacity then
			g_currentMission:addHelpButtonText(Motorized.NOT_ALLOW_ADD_CAPACITY, InputBinding.ADD_CAPACITY_BUTTON);
			if self.fillLevel >= (self.capacity * 0.01) and self.fillLevel < self.capacity then
				if self.setNewCapacity then
					g_currentMission:addExtraPrintText(Motorized.STOP_SET_NEW_CAPACITY .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.SET_NEW_CAPACITY_BUTTON));
				else
					g_currentMission:addExtraPrintText(Motorized.SET_NEW_CAPACITY .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.SET_NEW_CAPACITY_BUTTON));
				end;
			end;
		else
			g_currentMission:addHelpButtonText(Motorized.ALLOW_ADD_CAPACITY, InputBinding.ADD_CAPACITY_BUTTON);
		end;
		if self.showHud then
			if not isPdaOpen then
				if g_newGUISkin then
					self.VariableCapacityWheelLoaderOverlayNew:render();
				else
					self.VariableCapacityWheelLoaderOverlayOld:render();
				end;
				
				setTextBold(true);
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextColor(1, 1, 1, 1);
				
				renderText(
					self.VariableCapacityWheelLoaderHudPosX + 0.035, 
					self.VariableCapacityWheelLoaderHudPosY + 0.19, 
					0.02, 
					(Motorized.VERSION)
				);
				renderText(
					self.VariableCapacityWheelLoaderHudPosX + 0.015, 
					self.VariableCapacityWheelLoaderHudPosY + 0.15, 
					0.02, 
					(Motorized.FILL_LEVEL)
				);
				renderText(
					self.VariableCapacityWheelLoaderHudPosX + 0.015, 
					self.VariableCapacityWheelLoaderHudPosY + 0.13, 
					0.02, 
					(Motorized.CAPACITY)
				);
				if self.capacityTime < 2 then
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.015, 
						self.VariableCapacityWheelLoaderHudPosY + 0.11, 
						0.02, 
						(Motorized.CAPACITY_ADDED)
					);
					if self.newAddCapacity > 0 then
						if self.allowAddCapacity then
							renderText(
								self.VariableCapacityWheelLoaderHudPosX + 0.015, 
								self.VariableCapacityWheelLoaderHudPosY + 0.09, 
								0.02, 
								(Motorized.ADD_CAPACITY_ACTIVE)
							);
						else
							renderText(
								self.VariableCapacityWheelLoaderHudPosX + 0.015, 
								self.VariableCapacityWheelLoaderHudPosY + 0.09, 
								0.02, 
								(Motorized.ADD_CAPACITY_NOT_ACTIVE)
							);
						end;
					else
						renderText(
							self.VariableCapacityWheelLoaderHudPosX + 0.015, 
							self.VariableCapacityWheelLoaderHudPosY + 0.09, 
							0.02, 
							(Motorized.ADD_CAPACITY_NOT_ACTIVE)
						);
					end;
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.015, 
						self.VariableCapacityWheelLoaderHudPosY + 0.07, 
						0.02, 
						(Motorized.ADD_CAPACITY_MIN)
					);
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.015, 
						self.VariableCapacityWheelLoaderHudPosY + 0.05, 
						0.02, 
						(Motorized.ADD_CAPACITY_MAX)
					);
				else
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.015, 
						self.VariableCapacityWheelLoaderHudPosY + 0.11, 
						0.02, 
						(Motorized.CAPACITY_REMOVED)
					);
					if self.newRemoveCapacity > 0 then
						if self.allowAddCapacity then
							renderText(
								self.VariableCapacityWheelLoaderHudPosX + 0.015, 
								self.VariableCapacityWheelLoaderHudPosY + 0.09, 
								0.02, 
								(Motorized.REMOVE_CAPACITY_ACTIVE)
							);
						else
							renderText(
								self.VariableCapacityWheelLoaderHudPosX + 0.015, 
								self.VariableCapacityWheelLoaderHudPosY + 0.09, 
								0.02, 
								(Motorized.REMOVE_CAPACITY_NOT_ACTIVE)
							);
						end;
					else
						renderText(
							self.VariableCapacityWheelLoaderHudPosX + 0.015, 
							self.VariableCapacityWheelLoaderHudPosY + 0.09, 
							0.02, 
							(Motorized.REMOVE_CAPACITY_NOT_ACTIVE)
						);
					end;
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.015, 
						self.VariableCapacityWheelLoaderHudPosY + 0.07, 
						0.02, (
						Motorized.REMOVE_CAPACITY_MIN)
					);
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.015, 
						self.VariableCapacityWheelLoaderHudPosY + 0.05, 
						0.02, 
						(Motorized.REMOVE_CAPACITY_MAX)
					);
				end;
				renderText(
					self.VariableCapacityWheelLoaderHudPosX + 0.015, 
					self.VariableCapacityWheelLoaderHudPosY + 0.03, 
					0.02, 
					(Motorized.NEW_CAPACITY)
				);
				
				setTextAlignment(RenderText.ALIGN_RIGHT);
				
				renderText(
					self.VariableCapacityWheelLoaderHudPosX + 0.4, 
					self.VariableCapacityWheelLoaderHudPosY + 0.15, 
					0.02, 
					(FillLevelString)
				);
				renderText(
					self.VariableCapacityWheelLoaderHudPosX + 0.4, 
					self.VariableCapacityWheelLoaderHudPosY + 0.13, 
					0.02, 
					(CapacityStartString)
				);
				if self.capacityTime < 2 then
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.4, 
						self.VariableCapacityWheelLoaderHudPosY + 0.11,
						0.02, 
						(NewAddCapacityString)
					);
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.4, 
						self.VariableCapacityWheelLoaderHudPosY + 0.07, 
						0.02, 
						(AddCapacityMinString)
					);
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.4, 
						self.VariableCapacityWheelLoaderHudPosY + 0.05, 
						0.02, 
						(AddCapacityMaxString)
					);
				else
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.4, 
						self.VariableCapacityWheelLoaderHudPosY + 0.11, 
						0.02, 
						(NewRemoveCapacityString)
					);
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.4, 
						self.VariableCapacityWheelLoaderHudPosY + 0.07, 
						0.02, 
						(RemoveCapacityMinString)
					);
					renderText(
						self.VariableCapacityWheelLoaderHudPosX + 0.4, 
						self.VariableCapacityWheelLoaderHudPosY + 0.05, 
						0.02, 
						(RemoveCapacityMaxString)
					);
				end;
				renderText(
					self.VariableCapacityWheelLoaderHudPosX + 0.4, 
					self.VariableCapacityWheelLoaderHudPosY + 0.03, 
					0.02, 
					(CapacityString)
				);
				
				g_currentMission:addHelpButtonText(Motorized.HIDE_HUD, InputBinding.SHOW_HUD_BUTTON);
			else
				if self.capacityTime < 2 then
					g_currentMission:addExtraPrintText(Motorized.CAPACITY_ADDED .. " " .. NewAddCapacityString);
					if self.newAddCapacity > 0 then
						if self.allowAddCapacity then
							g_currentMission:addExtraPrintText(Motorized.ADD_CAPACITY_ACTIVE);
						else
							g_currentMission:addExtraPrintText(Motorized.ADD_CAPACITY_NOT_ACTIVE);
						end;
					else
						g_currentMission:addExtraPrintText(Motorized.ADD_CAPACITY_NOT_ACTIVE);
					end;
				else
					g_currentMission:addExtraPrintText(Motorized.CAPACITY_REMOVED .. " " .. NewRemoveCapacityString);
					if self.newRemoveCapacity > 0 then
						if self.allowAddCapacity then
							g_currentMission:addExtraPrintText(Motorized.REMOVE_CAPACITY_ACTIVE);
						else
							g_currentMission:addExtraPrintText(Motorized.REMOVE_CAPACITY_NOT_ACTIVE);
						end;
					else
						g_currentMission:addExtraPrintText(Motorized.REMOVE_CAPACITY_NOT_ACTIVE);
					end;
				end;
				g_currentMission:addExtraPrintText(Motorized.NEW_CAPACITY .. " " .. CapacityString);
			end;
		else
			if self.capacityTime < 2 then
				g_currentMission:addExtraPrintText(Motorized.CAPACITY_ADDED .. " " .. NewAddCapacityString);
				if self.newAddCapacity > 0 then
					if self.allowAddCapacity then
						g_currentMission:addExtraPrintText(Motorized.ADD_CAPACITY_ACTIVE);
					else
						g_currentMission:addExtraPrintText(Motorized.ADD_CAPACITY_NOT_ACTIVE);
					end;
				else
					g_currentMission:addExtraPrintText(Motorized.ADD_CAPACITY_NOT_ACTIVE);
				end;
			else
				g_currentMission:addExtraPrintText(Motorized.CAPACITY_REMOVED .. " " .. NewRemoveCapacityString);
				if self.newRemoveCapacity > 0 then
					if self.allowAddCapacity then
						g_currentMission:addExtraPrintText(Motorized.REMOVE_CAPACITY_ACTIVE);
					else
						g_currentMission:addExtraPrintText(Motorized.REMOVE_CAPACITY_NOT_ACTIVE);
					end;
				else
					g_currentMission:addExtraPrintText(Motorized.REMOVE_CAPACITY_NOT_ACTIVE);
				end;
			end;
			g_currentMission:addExtraPrintText(Motorized.NEW_CAPACITY .. " " .. CapacityString);
		
			if not isPdaOpen then
				g_currentMission:addHelpButtonText(Motorized.SHOW_HUD, InputBinding.SHOW_HUD_BUTTON);
			end;
		end;
	end;
end;