--[[
	VariableCapacityMixerWagonRegister.lua
	
	Autor: Ifko[nator]
	Datum: 08.08.2014
]]

SpecializationUtil.registerSpecialization("variableCapacityMixerWagon", "VariableCapacityMixerWagon", g_currentModDirectory.."Scripts/VariableCapacityMixerWagon.lua")

VariableCapacityMixerWagonRegister = {};

function VariableCapacityMixerWagonRegister:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					-- Standard lua's
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("mixerWagon") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							-- Mod lua's (nicht im dataS Ordner!)
							if rawget(SpecializationUtil.specializations, string.format("%s.variableCapacityMixerWagon", _name)) ~= nil then
								allowInsertion = false;
							end;
						end;
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("variableCapacityMixerWagon"));
						end;
						MixerWagon.HIDE_HUD = g_i18n:getText("HIDE_HUD_TEXT");
						MixerWagon.SHOW_HUD = g_i18n:getText("SHOW_HUD_TEXT");
						MixerWagon.NOT_ALLOW_ADD_CAPACITY = g_i18n:getText("NOT_ALLOW_ADD_CAPACITY_TEXT");
						MixerWagon.ALLOW_ADD_CAPACITY = g_i18n:getText("ALLOW_ADD_CAPACITY_TEXT");
						MixerWagon.SET_NEW_CAPACITY = g_i18n:getText("SET_NEW_CAPACITY_TEXT");
						MixerWagon.STOP_SET_NEW_CAPACITY = g_i18n:getText("STOP_SET_NEW_CAPACITY_TEXT");
						MixerWagon.VERSION = g_i18n:getText("VERSION_TEXT");
						MixerWagon.FILL_LEVEL = g_i18n:getText("FILL_LEVEL_TEXT");
						MixerWagon.CAPACITY = g_i18n:getText("CAPACITY_TEXT");
						MixerWagon.CAPACITY_ADDED = g_i18n:getText("CAPACITY_ADDED_TEXT");
						MixerWagon.ADD_CAPACITY_ACTIVE = g_i18n:getText("ADD_CAPACITY_ACTIVE_TEXT");
						MixerWagon.ADD_CAPACITY_NOT_ACTIVE = g_i18n:getText("ADD_CAPACITY_NOT_ACTIVE_TEXT");
						MixerWagon.ADD_CAPACITY_MIN = g_i18n:getText("ADD_CAPACITY_MIN_TEXT");
						MixerWagon.ADD_CAPACITY_MAX = g_i18n:getText("ADD_CAPACITY_MAX_TEXT");
						MixerWagon.CAPACITY_REMOVED = g_i18n:getText("CAPACITY_REMOVED_TEXT");
						MixerWagon.REMOVE_CAPACITY_ACTIVE = g_i18n:getText("REMOVE_CAPACITY_ACTIVE_TEXT");
						MixerWagon.REMOVE_CAPACITY_NOT_ACTIVE = g_i18n:getText("REMOVE_CAPACITY_NOT_ACTIVE_TEXT");
						MixerWagon.REMOVE_CAPACITY_MIN = g_i18n:getText("REMOVE_CAPACITY_MIN_TEXT");
						MixerWagon.REMOVE_CAPACITY_MAX = g_i18n:getText("REMOVE_CAPACITY_MAX_TEXT");
						MixerWagon.NEW_CAPACITY = g_i18n:getText("NEW_CAPACITY_TEXT");
					end;
				end;
			end;	
		end;
	end;
end;

function VariableCapacityMixerWagonRegister:deleteMap()
end;

function VariableCapacityMixerWagonRegister:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableCapacityMixerWagonRegister:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableCapacityMixerWagonRegister:update(dt)
end;

function VariableCapacityMixerWagonRegister:draw()
end;

addModEventListener(VariableCapacityMixerWagonRegister);