--
-- radio
-- Specialization class for Gears
--
-- @author  MySQly
-- @date  10/06/09
--
-- Copyright (C) MySQly, All Rights Reserved.

radio = {};

function radio.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function radio:load(xmlFile)
    self.radioCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.radio#count"),0);
	self.radioVolume = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.radio#volume"),0);
    self.radioOn = false;
    self.radio = {};
	self.currentSong = 1;
    for i=1, self.radioCount do
        local objname = string.format("vehicle.radio.song" .. "%d",i);
        self.radio[i] = {};
        local filename = Utils.getFilename(getXMLString(xmlFile, objname .. "#filename"),self.baseDirectory);
		self.radio[i].song = createSample(string.format("track" .. "%d",i));
		loadSample(self.radio[i].song, filename, false);
    end;
	self.songPlayed = false;
end;

function radio:delete()

end;

function radio:mouseEvent(posX, posY, isDown, isUp, button)

end;

function radio:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_f9 then
		self.radioOn = not self.radioOn;
	end;
	
	if isDown and sym == Input.KEY_f10 then
		stopSample(self.radio[self.currentSong].song);
		self.songPlayed = false;
		if self.currentSong >= self.radioCount then
			self.currentSong = 1;
		else
			self.currentSong = self.currentSong + 1;
		end;
	end;
	
	if isDown and sym == Input.KEY_f11 then
		stopSample(self.radio[self.currentSong].song);
		self.songPlayed = false;
		if self.currentSong <= 1 then
			self.currentSong = self.radioCount;
		else
			self.currentSong = self.currentSong - 1;
		end;
	end;
end;

function radio:update(dt)
	if self.radioVolume <= 0 then
		self.radioVolume = 0.1;
	end;
	if self.radioOn then
		if not self.songPlayed then
			playSample(self.radio[self.currentSong].song, 1, self.radioVolume, 0);
			self.songKoniec = self.time + getSampleDuration(self.radio[self.currentSong].song);
			self.songPlayed = true;
		end;
		if self.time >= self.songKoniec then
			if self.currentSong == self.radioCount then
				self.currentSong = 1;
			else
				self.currentSong = self.currentSong + 1;
			end;
			self.songPlayed = false;
		end;
	else
		if self.songPlayed then
			stopSample(self.radio[self.currentSong].song, 0, 1, 0);
			self.songPlayed = false;
		end;
	end;
end;

function radio:draw()

end;

function radio:onEnter()
	
end;

function radio:onLeave()

end;

