rotationPart = {};

function rotationPart.prerequisitesPresent(specializations)
    return true;
end;

function rotationPart:load(xmlFile)

    self.rotatingPartsAnimTime = 0;

    self.rotatingParts = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.rotatingParts.rotatingPart(%d)", i);
        if not hasXMLProperty(xmlFile, baseName) then
            break;
        end;
        local entry = {};
        entry.node = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. "#node"));
        entry.speed = Utils.getNoNil(getXMLFloat(xmlFile, baseName.. "#speed"), 0.005);
        if entry.node ~= nil then
            table.insert(self.rotatingParts, entry);
        end;
        i = i+1;
    end;
	
	self.setRotate = SpecializationUtil.callSpecializationsFunction("setRotate");
end;

function rotationPart:delete()
end;

function rotationPart:readStream(streamId, connection)
end;

function rotationPart:writeStream(streamId, connection)
end;

function rotationPart:readUpdateStream(streamId, timestamp, connection)
end;

function rotationPart:writeUpdateStream(streamId, connection, dirtyMask)
end;

function rotationPart:mouseEvent(posX, posY, isDown, isUp, button)
end;

function rotationPart:keyEvent(unicode, sym, modifier, isDown)
end;

function rotationPart:update(dt)
	if setRotate == true then
        -- update rotatingParts
        self.rotatingPartsAnimTime = self.rotatingPartsAnimTime + dt;
        for _, rotatingPart in ipairs(self.rotatingParts) do
            setRotation(rotatingPart.node, 0 , rotatingPart.speed*self.rotatingPartsAnimTime, 0);
        end;
	end;
end;

function rotationPart:updateTick(dt)
end;

function rotationPart:draw()
end;

function rotationPart:onDetach()
end;

function rotationPart:onLeave()
end;

function rotationPart:onDeactivate()
end;

function rotationPart:onDeactivateSounds()
end;