-- author: rafftnix
-- date: 15.12.2013


-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

-- increases motor sound pitch and fuel usage if tool is turnedOn or moving tool is moved
-- note: vehicle needs to be turn-on-able of cause

WorkRPM = {}

function WorkRPM.prerequisitesPresent(specializations)
    return true;
end;

function WorkRPM:load(xmlFile)
	self.getPoweringVehicle = WorkRPM.getPoweringVehicle;
	
	self.motorSoundMaxPitchWorkFactor = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workRPM#maxPitchFactor"), 1);
	self.motorSoundMaxPitchWorkAcc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workRPM#maxPitchAcc"), 0.002);
	self.workFuelUsageFactor = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workRPM#fuelUsageFactor"), 0.1);
	self.movingToolSoundPitch = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workRPM#movingToolSoundPitch"), -0.01);
	
	self.poweringVehicle = nil;
end;

function WorkRPM:delete()
  
end;

function WorkRPM:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WorkRPM:keyEvent(unicode, sym, modifier, isDown)
end;

function WorkRPM:update(dt)
	
end;

function WorkRPM:updateTick(dt)
	if self.poweringVehicle ~= nil then
		local vehicle = self.poweringVehicle;
		if self.isTurnedOn and vehicle.isMotorStarted ~= nil and vehicle.isMotorStarted then
			if vehicle.motorSoundPitchOffset ~= nil then
				vehicle.motorSoundPitchOffset = math.min(vehicle.motorSoundPitchOffset + (dt*self.motorSoundMaxPitchWorkAcc), vehicle.motorSoundPitchMax*self.motorSoundMaxPitchWorkFactor);
			end;
			if vehicle.motorSoundRunPitchOffset ~= nil then
				vehicle.motorSoundRunPitchOffset = math.min(vehicle.motorSoundRunPitchOffset + (dt*self.motorSoundMaxPitchWorkAcc), vehicle.motorSoundRunPitchMax*self.motorSoundMaxPitchWorkFactor);
			end;
			if self.isServer and vehicle.setFuelFillLevel ~= nil and vehicle.fuelUsage ~= nil then
				local usedFuel = vehicle.fuelUsage * dt * self.workFuelUsageFactor;
				vehicle:setFuelFillLevel(vehicle.fuelFillLevel-usedFuel);
			end;
		elseif vehicle.motorSoundPitchOffset ~= nil and vehicle.motorSoundPitchOffsetBackup ~= nil then
			vehicle.motorSoundPitchOffset = math.max(vehicle.motorSoundPitchOffset - (dt*self.motorSoundMaxPitchWorkAcc), vehicle.motorSoundPitchOffsetBackup);
			if vehicle.motorSoundRunPitchOffset ~= nil then
				vehicle.motorSoundRunPitchOffset = math.max(vehicle.motorSoundRunPitchOffset - (dt*self.motorSoundMaxPitchWorkAcc), vehicle.motorSoundRunPitchOffsetBackup);
			end;
		end;
		
		local toolsMoving = false;
		if self.movingTools ~= nil then
			for a=1, table.getn(self.movingTools) do
				if (self.movingTools[a].lastRotSpeed ~= nil and self.movingTools[a].lastRotSpeed ~= 0) or (self.movingTools[a].lastTransSpeed ~= nil and self.movingTools[a].lastTransSpeed ~=0) or (self.movingTools[a].rotBackup ~= nil and self.movingTools[a].rotBackup ~= self.movingTools[a].curRot[self.movingTools[a].rotationAxis]) then
					vehicle.motorSoundPitchOffset = vehicle.motorSoundPitchOffset + (vehicle.motorSoundPitchOffset*self.movingToolSoundPitch);
				end;
			end;
		end;
	elseif self.motor ~= nil then
		self.poweringVehicle = self;
		if self.motorSoundPitchOffset ~= nil then
			self.motorSoundPitchOffsetBackup = self.motorSoundPitchOffset;
		end;
		if self.motorSoundRunPitchOffset ~= nil then
			self.motorSoundRunPitchOffsetBackup = self.motorSoundRunPitchOffset;
		end;
	end;
end;

function WorkRPM:draw()
  
end;

function WorkRPM:onAttach(attacherVehicle)
	local poweringVehicle = self:getPoweringVehicle(self);
	if poweringVehicle ~= nil then
		if poweringVehicle.motorSoundPitchOffset ~= nil then
			poweringVehicle.motorSoundPitchOffsetBackup = poweringVehicle.motorSoundPitchOffset;
		end;
		if poweringVehicle.motorSoundRunPitchOffset ~= nil then
			poweringVehicle.motorSoundRunPitchOffsetBackup = poweringVehicle.motorSoundRunPitchOffset;
		end;
		self.poweringVehicle = poweringVehicle;
	end;
end;

function WorkRPM:onDetach(attacherVehicle)
	local vehicle = self.poweringVehicle;
	if vehicle.motorSoundPitchOffsetBackup ~= nil then
		vehicle.motorSoundPitchOffset = vehicle.motorSoundPitchOffsetBackup;
		vehicle.motorSoundPitchOffsetBackup = nil;
	end;
	if vehicle.motorSoundRunPitchOffsetBackup ~= nil then
		vehicle.motorSoundRunPitchOffset = vehicle.motorSoundRunPitchOffsetBackup;
		vehicle.motorSoundRunPitchOffsetBackup = nil;
	end;
	self.poweringVehicle = nil;
end;

function WorkRPM:getPoweringVehicle(vehicle)
	if vehicle.motor ~= nil and vehicle.startMotor ~= nil then
		return vehicle;
	end;
	if vehicle.attacherVehicle ~= nil then
		return self:getPoweringVehicle(vehicle.attacherVehicle);
	else
		return nil;
	end;
end;