WoodWireLoopAttachEvent = {};
WoodWireLoopAttachEvent_mt = Class(WoodWireLoopAttachEvent, Event);

InitEventClass(WoodWireLoopAttachEvent, "WoodWireLoopAttachEvent");

function WoodWireLoopAttachEvent:emptyNew()
    local self = Event:new(WoodWireLoopAttachEvent_mt);
    self.className="WoodWireLoopAttachEvent";
    return self;
end;

function WoodWireLoopAttachEvent:new(object, id, trunkId, posU, posD, posL, posR)
    local self = WoodWireLoopAttachEvent:emptyNew()
    self.object = object;
	self.id = id;
	self.trunkId = trunkId;
	self.posU = {};
	self.posD = {};
	self.posL = {};
	self.posR = {};	
	for i=1,3 do
		self.posU[i] = posU[i];
		self.posD[i] = posD[i];
		self.posL[i] = posL[i];
		self.posR[i] = posR[i];
	end;
    return self;
end;

function WoodWireLoopAttachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.id = streamReadInt8(streamId);
    local idT = streamReadInt32(streamId);
	self.posU = {};
	self.posD = {};
	self.posL = {};
	self.posR = {};		
	for i=1,3 do
		self.posU[i] = streamReadFloat32(streamId);
		self.posD[i] = streamReadFloat32(streamId);
		self.posL[i] = streamReadFloat32(streamId);
		self.posR[i] = streamReadFloat32(streamId);
	end;	
    self.object = networkGetObject(id);
    self.trunkId = networkGetObject(idT);
    self:run(connection);
end;

function WoodWireLoopAttachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.id);
	streamWriteInt32(streamId, networkGetObjectId(self.trunkId));
	for i=1,3 do
		streamWriteFloat32(streamId, self.posU[i]);
		streamWriteFloat32(streamId, self.posD[i]);
		streamWriteFloat32(streamId, self.posL[i]);
		streamWriteFloat32(streamId, self.posR[i]);
	end;	
end;

function WoodWireLoopAttachEvent:run(connection)
	self.object:setLoopToTrunk(self.id, self.trunkId, self.posU, self.posD, self.posL, self.posR);
    if not connection:getIsServer() then
        g_server:broadcastEvent(WoodWireLoopAttachEvent:new(self.object, self.id, self.trunkId, self.posU, self.posD, self.posL, self.posR), nil, connection, self.object);
    end;
end;


