SetInvertSteeringEvent = {};
SetInvertSteeringEvent_mt = Class(SetInvertSteeringEvent, Event);

InitEventClass(SetInvertSteeringEvent, "SetInvertSteeringEvent");

function SetInvertSteeringEvent:emptyNew()
    local self = Event:new(SetInvertSteeringEvent_mt);
    self.className="SetInvertSteeringEvent";
    return self;
end;

function SetInvertSteeringEvent:new(object, steeringIsInverted)
    local self = SetInvertSteeringEvent:emptyNew()
    self.object = object;
	self.steeringIsInverted = steeringIsInverted;
    return self;
end;

function SetInvertSteeringEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.steeringIsInverted = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetInvertSteeringEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.steeringIsInverted);
end;

function SetInvertSteeringEvent:run(connection)
	self.object:invertSteering(self.steeringIsInverted, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetInvertSteeringEvent:new(self.object, self.steeringIsInverted), nil, connection, self.object);
    end;
end;

function SetInvertSteeringEvent.sendEvent(vehicle, steeringIsInverted, noEventSend)
	if steeringIsInverted ~= vehicle.steeringIsInverted then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetInvertSteeringEvent:new(vehicle, steeringIsInverted), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetInvertSteeringEvent:new(vehicle, steeringIsInverted));
			end;
		end;
	end;
end;

