DetachEvent = {};
DetachEvent_mt = Class(DetachEvent, Event);

InitEventClass(DetachEvent, "DetachEvent");

function DetachEvent:emptyNew()
    local self = Event:new(DetachEvent_mt);
    self.className="DetachEvent";
    return self;
end;

function DetachEvent:new(object)
    local self = DetachEvent:emptyNew()
    self.object = object;
    return self;
end;

function DetachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function DetachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

function DetachEvent:run(connection)
	if self.object.isBaleAttached then
		self.object:detachBale();
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(DetachEvent:new(self.object), nil, connection, self.object);
    end;	
end;

function DetachEvent.sendEvent(vehicle, noEventSend)
		--if myNumber ~= vehicle.isClosed then
			if noEventSend == nil or noEventSend == false then
				if g_server ~= nil then
					g_server:broadcastEvent(DetachEvent:new(vehicle), nil, nil, vehicle);
				else
					g_client:getServerConnection():sendEvent(DetachEvent:new(vehicle));
				end;
			end;
		--end;
end;

