-- JohnDeereFrontHydarulic
-- Specialisation for the JohnDeereFrontHydarulic
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  30/01/2011

JohnDeereFrontHydarulic = {};

function JohnDeereFrontHydarulic.prerequisitesPresent(specializations)
    return true;
end;

function JohnDeereFrontHydarulic:load(xmlFile)
	self.onAttachImplemtentTransformations = {};
	self.onAttachImplemtentTransformations.bottomRot = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.onAttachImplemtentTransformations.bottomRot#index"));
	self.onAttachImplemtentTransformations.topArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.onAttachImplemtentTransformations.topArm#index"));
	if self.onAttachImplemtentTransformations.bottomRot ~= nil then
		self.onAttachImplemtentTransformations.bottomRotDetached = {getRotation(self.onAttachImplemtentTransformations.bottomRot)};
	end;
	if self.onAttachImplemtentTransformations.topArm ~= nil then
		self.onAttachImplemtentTransformations.topArmRotDetached = {getRotation(self.onAttachImplemtentTransformations.topArm)};
		self.onAttachImplemtentTransformations.topArmTransDetached = {getTranslation(self.onAttachImplemtentTransformations.topArm)};
	end;	

	local x,y,z = getCenterOfMass(self.components[1].node);
	self.centerOfMassDetachedCollision = {x,y,z};
end;

function JohnDeereFrontHydarulic:delete()
end;

function JohnDeereFrontHydarulic:readStream(streamId, connection)
end;

function JohnDeereFrontHydarulic:writeStream(streamId, connection)	
end;

function JohnDeereFrontHydarulic:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JohnDeereFrontHydarulic:keyEvent(unicode, sym, modifier, isDown)
end;

function JohnDeereFrontHydarulic:update(dt)
	if self:getIsActive() then		
		for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;
	end;
	if self:getIsActiveForInput() then		
        if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
            self:handleLowerImplementEvent();
        end;
	end;
end;

function JohnDeereFrontHydarulic:updateTick(dt)
end;

function JohnDeereFrontHydarulic:draw()
end;

function JohnDeereFrontHydarulic:attachImplement(implement)
	if self.onAttachImplemtentTransformations.bottomRot ~= nil then
		setRotation(self.onAttachImplemtentTransformations.bottomRot, 0,0,0)
	end;
	if self.onAttachImplemtentTransformations.topArm ~= nil then
		setRotation(self.onAttachImplemtentTransformations.topArm, 0,0,0)
		setTranslation(self.onAttachImplemtentTransformations.topArm, 0,0,0)
	end;
end;

function JohnDeereFrontHydarulic:detachImplement(implementIndex)
	if self.onAttachImplemtentTransformations.bottomRot ~= nil then
		setRotation(self.onAttachImplemtentTransformations.bottomRot, unpack(self.onAttachImplemtentTransformations.bottomRotDetached))
	end;
	if self.onAttachImplemtentTransformations.topArm ~= nil then
		setRotation(self.onAttachImplemtentTransformations.topArm, unpack(self.onAttachImplemtentTransformations.topArmRotDetached))
		setTranslation(self.onAttachImplemtentTransformations.topArm, unpack(self.onAttachImplemtentTransformations.topArmTransDetached))
	end;
end;

function JohnDeereFrontHydarulic:onAttach(attacherVehicle)
	local x,y,z = getCenterOfMass(attacherVehicle.rootNode);
	if x ~= nil then
		x,y,z = localToWorld(attacherVehicle.rootNode, x,y,z);
		x,y,z = worldToLocal(self.components[1].node, x,y,z);
		setCenterOfMass(self.components[1].node, x,y,z);
	end;
end;

function JohnDeereFrontHydarulic:onDetach()
	local x,y,z = unpack(self.centerOfMassDetachedCollision);
	setCenterOfMass(self.components[1].node, x, y, z);
end;