--
--
--
--
--

SetTrunkVisScaleEvent = {};
SetTrunkVisScaleEvent_mt = Class(SetTrunkVisScaleEvent, Event);
InitEventClass(SetTrunkVisScaleEvent, "SetTrunkVisScaleEvent");

function SetTrunkVisScaleEvent:emptyNew()
    local self = Event:new(SetTrunkVisScaleEvent_mt);
    self.className="SetTrunkVisScaleEvent";
    return self;
end;

function SetTrunkVisScaleEvent:new(object, scale, bMove)
    local self = SetTrunkVisScaleEvent:emptyNew(); 
	self.object = object; 
    self.scale = scale; 
	self.bMove = bMove;
    return self;
end;

function SetTrunkVisScaleEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.scale);
	streamWriteBool(streamId, self.bMove);
end;

function SetTrunkVisScaleEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.scale = streamReadFloat32(streamId);
	self.bMove = streamReadBool(streamId);
    self:run(connection);
end;

function SetTrunkVisScaleEvent:run(connection)
	self.object:setVisScale(self.scale, self.bMove, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetTrunkVisScaleEvent:new(self.object, self.scale, self.bMove), nil, connection, self.object);
	end; 
end;

function SetTrunkVisScaleEvent.sendEvent(object, scale, bMove, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(SetTrunkVisScaleEvent:new(object, scale, bMove), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(SetTrunkVisScaleEvent:new(object, scale, bMove)); 
		end;
	end;
end;