SetFreeSwingEvent = {};
SetFreeSwingEvent_mt = Class(SetFreeSwingEvent, Event);

InitEventClass(SetFreeSwingEvent, "SetFreeSwingEvent");

function SetFreeSwingEvent:emptyNew()
    local self = Event:new(SetFreeSwingEvent_mt);
    self.className="SetFreeSwingEvent";
    return self;
end;

function SetFreeSwingEvent:new(object, state)
    local self = SetFreeSwingEvent:emptyNew();
    self.object = object;
	self.state = state;
    return self;
end;

function SetFreeSwingEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetFreeSwingEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function SetFreeSwingEvent:run(connection)
    self.object:setFreeSwing(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetFreeSwingEvent:new(self.object, self.state), nil, connection, self.object);
    end;
end;

function SetFreeSwingEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetFreeSwingEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetFreeSwingEvent:new(vehicle, state));
		end;
	end;
end;