-- author: rafftnix
-- date: 13.01.2012

SetBranchInvisibleEvent = {};
SetBranchInvisibleEvent_mt = Class(SetBranchInvisibleEvent, Event);
InitEventClass(SetBranchInvisibleEvent, "SetBranchInvisibleEvent");
function SetBranchInvisibleEvent:emptyNew()
    local self = Event:new(SetBranchInvisibleEvent_mt);
    self.className="SetBranchInvisibleEvent";
    return self;
end;

function SetBranchInvisibleEvent:new(object, branchNum)
    local self = SetBranchInvisibleEvent:emptyNew(); 
    self.object = object; 
	self.branchNum = branchNum;
    return self;
end;

function SetBranchInvisibleEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.branchNum);
end;

function SetBranchInvisibleEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.branchNum = streamReadInt8(streamId);
    self:run(connection);
end;

function SetBranchInvisibleEvent:run(connection)
	self.object:setBranchInvisible(self.branchNum);
end;