-- author: rafftnix
-- date: 25.12.2012

WoodClawAttachEvent = {};
WoodClawAttachEvent_mt = Class(WoodClawAttachEvent, Event);
InitEventClass(WoodClawAttachEvent, "WoodClawAttachEvent");
function WoodClawAttachEvent:emptyNew()
    local self = Event:new(WoodClawAttachEvent_mt);
    self.className="WoodClawAttachEvent";
    return self;
end;

function WoodClawAttachEvent:new(object, attach)
    local self = WoodClawAttachEvent:emptyNew(); 
    self.object = object; 
	self.attach = attach;
    return self;
end;

function WoodClawAttachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.attach);
end;

function WoodClawAttachEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.attach = streamReadBool(streamId);
    self:run(connection);
end;

function WoodClawAttachEvent:run(connection)
	if self.attach then
		self.object:attachTrunks(true);
	else
		self.object:detachTrunks(true);
	end;
end;