RemoveGrowingTreeEvent = {};
RemoveGrowingTreeEvent_mt = Class(RemoveGrowingTreeEvent, Event);
InitEventClass(RemoveGrowingTreeEvent, "RemoveGrowingTreeEvent");
function RemoveGrowingTreeEvent:emptyNew()
    local self = Event:new(RemoveGrowingTreeEvent_mt);
    self.className="RemoveGrowingTreeEvent";
    return self;
end;

function RemoveGrowingTreeEvent:new(treeIndex)
    local self = RemoveGrowingTreeEvent:emptyNew(); 
    self.treeIndex = treeIndex; 
    return self;
end;

function RemoveGrowingTreeEvent:writeStream(streamId, connection)
	streamWriteInt16(streamId, self.treeIndex);
end;

function RemoveGrowingTreeEvent:readStream(streamId, connection)
	self.treeIndex = streamReadInt16(streamId);
    self:run(connection);
end;

function RemoveGrowingTreeEvent:run(connection)
	g_currentMission.treeManager:removeGrowingTree(self.treeIndex);
end;

function RemoveGrowingTreeEvent.sendEvent(treeIndex)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(RemoveGrowingTreeEvent:new(treeIndex), nil, nil, nil);  -- last parameter is nil, any problem with that?
		else  
			print("RemoveGrowingTreeEvent: this should never be called");
		end;
	end;
end;