SetOpenStateEvent = {};
SetOpenStateEvent_mt = Class(SetOpenStateEvent, Event);

InitEventClass(SetOpenStateEvent, "SetOpenStateEvent");

function SetOpenStateEvent:emptyNew()
    local self = Event:new(SetOpenStateEvent_mt);
    self.className="SetOpenStateEvent";
    return self;
end;

function SetOpenStateEvent:new(object, isClosed)
    local self = SetOpenStateEvent:emptyNew()
    self.object = object;
	self.isClosed = isClosed;
    return self;
end;

function SetOpenStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isClosed = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetOpenStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isClosed);
end;

function SetOpenStateEvent:run(connection)
	self.object:setOpenState(self.isClosed, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetOpenStateEvent:new(self.object, self.isClosed), nil, connection, self.object);
    end;	
end;

function SetOpenStateEvent.sendEvent(vehicle, isClosed, noEventSend)
		--if myNumber ~= vehicle.isClosed then
			if noEventSend == nil or noEventSend == false then
				if g_server ~= nil then
					g_server:broadcastEvent(SetOpenStateEvent:new(vehicle, isClosed), nil, nil, vehicle);
				else
					g_client:getServerConnection():sendEvent(SetOpenStateEvent:new(vehicle, isClosed));
				end;
			end;
		--end;
end;

