AttachEvent = {};
AttachEvent_mt = Class(AttachEvent, Event);

InitEventClass(AttachEvent, "AttachEvent");

function AttachEvent:emptyNew()
    local self = Event:new(AttachEvent_mt);
    self.className="AttachEvent";
    return self;
end;

function AttachEvent:new(object)
    local self = AttachEvent:emptyNew()
    self.object = object;
    return self;
end;

function AttachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function AttachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

function AttachEvent:run(connection)
	if not self.object.isBaleAttached then
		self.object:attachBale();
		self.object.isBaleAttached = true;
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(AttachEvent:new(self.object), nil, connection, self.object);
    end;	
end;

function AttachEvent.sendEvent(vehicle, noEventSend)
		--if myNumber ~= vehicle.isClosed then
			if noEventSend == nil or noEventSend == false then
				if g_server ~= nil then
					g_server:broadcastEvent(AttachEvent:new(vehicle), nil, nil, vehicle);
				else
					g_client:getServerConnection():sendEvent(AttachEvent:new(vehicle));
				end;
			end;
		--end;
end;

