WoodWireLoopDetachEvent = {};
WoodWireLoopDetachEvent_mt = Class(WoodWireLoopDetachEvent, Event);

InitEventClass(WoodWireLoopDetachEvent, "WoodWireLoopDetachEvent");

function WoodWireLoopDetachEvent:emptyNew()
    local self = Event:new(WoodWireLoopDetachEvent_mt);
    self.className="WoodWireLoopDetachEvent";
    return self;
end;

function WoodWireLoopDetachEvent:new(object)
    local self = WoodWireLoopDetachEvent:emptyNew()
    self.object = object;
    return self;
end;

function WoodWireLoopDetachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function WoodWireLoopDetachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

function WoodWireLoopDetachEvent:run(connection)
	self.object:removeLoopFromTrunk();
    if not connection:getIsServer() then
        g_server:broadcastEvent(WoodWireLoopDetachEvent:new(self.object), nil, connection, self.object);
    end;
end;


