TreePlanterSetTreeTypeEvent = {};
TreePlanterSetTreeTypeEvent_mt = Class(TreePlanterSetTreeTypeEvent, Event);
InitEventClass(TreePlanterSetTreeTypeEvent, "TreePlanterSetTreeTypeEvent");
function TreePlanterSetTreeTypeEvent:emptyNew()
    local self = Event:new(TreePlanterSetTreeTypeEvent_mt);
    self.className="TreePlanterSetTreeTypeEvent";
    return self;
end;

function TreePlanterSetTreeTypeEvent:new(object, treeType)
    local self = TreePlanterSetTreeTypeEvent:emptyNew(); 
    self.object = object; 
	self.treeType = treeType;
    return self;
end;

function TreePlanterSetTreeTypeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.treeType);
end;

function TreePlanterSetTreeTypeEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.treeType = streamReadInt8(streamId);
    self:run(connection);
end;

function TreePlanterSetTreeTypeEvent:run(connection)
	self.object.currentTreeType = self.treeType;
	if not connection:getIsServer() then
		g_server:broadcastEvent(TreePlanterSetTreeTypeEvent:new(self.object, self.treeType), nil, connection, self.object);
	end; 
end;

function TreePlanterSetTreeTypeEvent.sendEvent(object, treeType, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(TreePlanterSetTreeTypeEvent:new(object, treeType), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(TreePlanterSetTreeTypeEvent:new(object, treeType)); 
		end;
	end;
end;