--	author: fruktor
--	date: 	13.12.2013

SetSawXRotationEvent = {};
SetSawXRotationEvent_mt = Class(SetSawXRotationEvent, Event);
InitEventClass(SetSawXRotationEvent, "SetSawXRotationEvent");

function SetSawXRotationEvent:emptyNew()
    local self = Event:new(SetSawXRotationEvent_mt);
    self.className="SetSawXRotationEvent";
    return self;
end;

function SetSawXRotationEvent:new(object, value)
    local self = SetSawXRotationEvent:emptyNew(); 
    self.object = object; 
	self.value = value;
    return self;
end;

function SetSawXRotationEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteFloat32(streamId, self.value);
end;

function SetSawXRotationEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.value = streamReadFloat32(streamId);
    self:run(connection);
end;

function SetSawXRotationEvent:run(connection)
	self.object:setSawXRotation(self.value, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetSawXRotationEvent:new(self.object, self.value), nil, connection, self.object);
	end; 
end;

function SetSawXRotationEvent.sendEvent(object, value, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(SetSawXRotationEvent:new(object, value), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(SetSawXRotationEvent:new(object, value)); 
		end;
	end;
end;