ForrestHoeTreeContactEvent = {};
ForrestHoeTreeContactEvent_mt = Class(ForrestHoeTreeContactEvent, Event);
InitEventClass(ForrestHoeTreeContactEvent, "ForrestHoeTreeContactEvent");
function ForrestHoeTreeContactEvent:emptyNew()
    local self = Event:new(ForrestHoeTreeContactEvent_mt);
    self.className="ForrestHoeTreeContactEvent";
    return self;
end;

function ForrestHoeTreeContactEvent:new(object, state)
    local self = ForrestHoeTreeContactEvent:emptyNew(); 
    self.object = object; 
	self.state = state;
    return self;
end;

function ForrestHoeTreeContactEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function ForrestHoeTreeContactEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function ForrestHoeTreeContactEvent:run(connection)
	self.object:setHasTreeContact(self.state);
end;

function ForrestHoeTreeContactEvent.sendEvent(object, state)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(ForrestHoeTreeContactEvent:new(object, state), nil, nil, object); 
		else  
			print("ForrestHoeTreeContactEvent: this should never be called");
		end;
	end;
end;