
AutoCombineRegister = {};
AutoCombineRegister.isLoaded = true;
AutoCombineRegister.g_currentModDirectory = g_currentModDirectory;

if SpecializationUtil.specializations["AutoCombine"] == nil then
	SpecializationUtil.registerSpecialization("AutoCombine", "AutoCombine", g_currentModDirectory.."AutoCombine.lua")
	AutoCombineRegister.isLoaded = false;
end;

function AutoCombineRegister:loadMap(name)	
  if not AutoCombineRegister.isLoaded then	
		AutoCombineRegister:add();
    AutoCombineRegister.isLoaded = true;
  end;
end;

function AutoCombineRegister:deleteMap()
  --AutoCombineRegister.isLoaded = false;
end;

function AutoCombineRegister:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AutoCombineRegister:keyEvent(unicode, sym, modifier, isDown)
end;

function AutoCombineRegister:update(dt)
end;

function AutoCombineRegister:draw()
end;

function AutoCombineRegister:add()
	local searchTable = { "APCombine", "AutoCombine" };	
	
	for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
		local modName             = string.match(k, "([^.]+)");
		local AutoCombineRegister = true;
		local correctLocation     = false;
		
		for _, search in pairs(searchTable) do
			if SpecializationUtil.specializations[modName .. "." .. search] ~= nil then
				AutoCombineRegister = false;
				break;
			end;
		end;
		
		for i = 1, table.maxn(v.specializations) do
			local vs = v.specializations[i];
			if      vs   ~= nil 
					and ( vs == SpecializationUtil.getSpecialization("aiCombine")
		-- Krone BigX Beast
              ) then --or vs == SpecializationUtil.getSpecialization(modName .. "." .. "aiCombine2") ) then
				correctLocation = true;
				break;
			end;
		end;
		
		if AutoCombineRegister and correctLocation then
			table.insert(v.specializations, SpecializationUtil.getSpecialization("AutoCombine"));
		  print("  AutoCombine was inserted on " .. k);
		elseif correctLocation and not AutoCombineRegister then
			print("  Failed to inserting AutoCombine on " .. k);
		end;
	end;
	
	-- make l10n global 
	g_i18n.globalI18N.texts["AC_COMBINE_TXT_START"]                = g_i18n:getText("AC_COMBINE_TXT_START");
	g_i18n.globalI18N.texts["AC_COMBINE_TXT_STOP"]                 = g_i18n:getText("AC_COMBINE_TXT_STOP");
	g_i18n.globalI18N.texts["AC_COMBINE_TXT_WORKWIDTH"]            = g_i18n:getText("AC_COMBINE_TXT_WORKWIDTH");
	g_i18n.globalI18N.texts["AC_COMBINE_TXT_ACTIVESIDELEFT"]       = g_i18n:getText("AC_COMBINE_TXT_ACTIVESIDELEFT");
	g_i18n.globalI18N.texts["AC_COMBINE_TXT_ACTIVESIDERIGHT"]      = g_i18n:getText("AC_COMBINE_TXT_ACTIVESIDERIGHT");
	g_i18n.globalI18N.texts["AC_COMBINE_WAITMODE_ON"]              = g_i18n:getText("AC_COMBINE_WAITMODE_ON");
	g_i18n.globalI18N.texts["AC_COMBINE_WAITMODE_OFF"]             = g_i18n:getText("AC_COMBINE_WAITMODE_OFF");
	g_i18n.globalI18N.texts["AC_COMBINE_COLLISIONTRIGGERMODE_ON"]  = g_i18n:getText("AC_COMBINE_COLLISIONTRIGGERMODE_ON");
	g_i18n.globalI18N.texts["AC_COMBINE_COLLISIONTRIGGERMODE_OFF"] = g_i18n:getText("AC_COMBINE_COLLISIONTRIGGERMODE_OFF");
	g_i18n.globalI18N.texts["AC_COMBINE_TEXTHELPPANELOFF"]         = g_i18n:getText("AC_COMBINE_TEXTHELPPANELOFF");
	g_i18n.globalI18N.texts["AC_COMBINE_TEXTHELPPANELON"]          = g_i18n:getText("AC_COMBINE_TEXTHELPPANELON");
--g_i18n.globalI18N.texts["AC_COMBINE_STARTSTOP"]                = g_i18n:getText("AC_COMBINE_STARTSTOP");
	g_i18n.globalI18N.texts["AC_COMBINE_COLLISION_OTHER"]          = g_i18n:getText("AC_COMBINE_COLLISION_OTHER");
	g_i18n.globalI18N.texts["AC_COMBINE_COLLISION_BACK"]           = g_i18n:getText("AC_COMBINE_COLLISION_BACK");
	g_i18n.globalI18N.texts["AC_COMBINE_UTURN_ON"]                 = g_i18n:getText("AC_COMBINE_UTURN_ON");
	g_i18n.globalI18N.texts["AC_COMBINE_UTURN_OFF"]                = g_i18n:getText("AC_COMBINE_UTURN_OFF");
	g_i18n.globalI18N.texts["AC_COMBINE_REVERSE_ON"]               = g_i18n:getText("AC_COMBINE_REVERSE_ON");
	g_i18n.globalI18N.texts["AC_COMBINE_REVERSE_OFF"]              = g_i18n:getText("AC_COMBINE_REVERSE_OFF");
	g_i18n.globalI18N.texts["AC_COMBINE_WIDTH_OFFSET"]             = g_i18n:getText("AC_COMBINE_WIDTH_OFFSET");
	g_i18n.globalI18N.texts["AC_COMBINE_TURN_OFFSET"]              = g_i18n:getText("AC_COMBINE_TURN_OFFSET");
	g_i18n.globalI18N.texts["AC_COMBINE_ERROR"]                    = g_i18n:getText("AC_COMBINE_ERROR");
	
end;

addModEventListener(AutoCombineRegister);
