--
-- AutoCombine
-- Extended AICombine 
--
-- @author  Mogli aka biedens
-- @date  22.10.2013
--
--  code source: AICombine.lua by Giants Software    
 
AutoCombine = {};

local function acPrintCallstack()
	local i = 2;
	local info;
	print("------------------------------------------------------------------------");
	while i <= 10 do
		info = debug.getinfo(i);
		if info == nil or info.name == nil or info.currentline == nil then break end
		print(string.format("%i: %s (%i)", i, info.name, info.currentline ));
		i = i + 1;
	end
	if info ~= nil and info.name ~= nil and info.currentline ~= nil then
		print("...");
	end
	print("------------------------------------------------------------------------");
end

------------------------------------------------------------------------
-- prerequisitesPresent
------------------------------------------------------------------------
function AutoCombine.prerequisitesPresent(specializations)
  return SpecializationUtil.hasSpecialization(Hirable, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

local AcDirectory = g_currentModDirectory;

local function acGetText(id)
	if id == nil then
		return "nil";
	end;
	
	local text = g_i18n:getText( id ); --g_i18n.globalI18N.texts[id];
	if text == nil or text == "" then
		return id;
	end;
	
	return text;
end;

local function acInvertSide(string)
	if     string == "left"  then
		return "right";
	elseif string == "right" then
		return "left";
	end
	return nil;
end
		
local oldCourseplaySide_to_drive = nil;
function AutoCombine.cpSideToDrive(self, _self, combine, distance,switchSide)

	if oldCourseplaySide_to_drive == nil then return "none" end
	
	if     combine.acParameters == nil 
			or combine.acParameters.enabled == nil 
			or not combine.acParameters.enabled 
			or combine.acParameters.CPSupport == nil
			or not combine.acParameters.CPSupport
			or not combine.isAIThreshing then
		return oldCourseplaySide_to_drive(self, _self, combine, distance,switchSide)
	end
	
	if combine.cp.forcedSide ~= nil then
		return oldCourseplaySide_to_drive(self, _self, combine, distance,switchSide)
	end

	local tractor = combine
	if courseplay.isAttachedCombine(self, combine) then
		tractor = combine.attacherVehicle
	end
	
	if tractor.drive then
		return oldCourseplaySide_to_drive(self, _self, combine, distance,switchSide)
	end

	if combine.acParameters.leftAreaActive then
		fruitSide = "right"
	else
		fruitSide = "left"
	end

	if switchSide then
		if     combine.acTurnStage >=  1 and combine.acTurnStage <= 10 then
			_self.sideToDrive = fruitSide
		elseif combine.acTurnStage >= 11 and combine.acTurnStage <= 19 then
			fruitSide = acInvertSide( fruitSide )
			_self.sideToDrive = acInvertSide( fruitSide );
		else
			_self.sideToDrive = acInvertSide( fruitSide );
		end
	else
		_self.sideToDrive = acInvertSide( fruitSide );
	end
	
	courseplay.debug(self,string.format("AutoCombine.lua(%i): %s: turn stage %i, switch side is %s, fruit side is %s, side to drive is %s", debug.getinfo(1).currentline, tostring(combine.name), combine.acTurnStage, tostring(switchSide), fruitSide, _self.sideToDrive),4);
	
	return fruitSide;
end

------------------------------------------------------------------------
-- 
------------------------------------------------------------------------
function AutoCombine:load(xmlFile)

  self.mouseEvent = Utils.overwrittenFunction( self.mouseEvent, AutoCombine.newMouseEvent );				
	self.acOnBackCollisionTrigger = AutoCombine.acOnBackCollisionTrigger;

	self.acNodeIsLinked = false;
	self.acButtons = {};

	self.acParameters = {}
	self.acParameters.upNDown 							= false;
	self.acParameters.otherCombine = false;
	self.acParameters.waitMode           = false;
	self.acParameters.leftAreaActive = true;
  self.acParameters.rightAreaActive = false;
  self.acParameters.enabled = false;
  self.acParameters.noReverse = false;
  self.acParameters.CPSupport = false;
	self.acParameters.turnOffset = 0;
	self.acParameters.widthOffset = 0;

	self.acDeltaTimeoutWait   = math.max(Utils.getNoNil( self.waitForTurnTimeout, 1500 ), 1000 ); 
	self.acDeltaTimeoutRun    = math.max(Utils.getNoNil( self.driveBackTimeout  , 1000 ),  300 );
	self.acDeltaTimeoutStop   = math.max(Utils.getNoNil( self.turnStage1Timeout , 20000), 10000);
	self.acDeltaTimeoutStart  = math.max(Utils.getNoNil( self.turnTimeoutLong   , 6000 ), 4000 );
	self.acDeltaTimeoutNoTurn = math.max(Utils.getNoNil( self.turnStage4Timeout , 2000 ), 1000 );
	self.acSteeringSpeed      = Utils.getNoNil( self.aiSteeringSpeed, 0.001 );
	self.acRecalculateDt      = 0;
	self.acTurn2Outside       = false;
	self.acDirectionBeforeTurn = {};
	self.acCollidingVehicles   = {};
	self.acTurnStage           = 0;
	self.acTurnStageSent       = 0;

	self.acI3D = getChild(Utils.loadSharedI3DFile("AutoCombine.i3d", AcDirectory),"AutoCombine");
	
	self.acBackTrafficCollisionTrigger   = getChild(self.acI3D,"backCollisionTrigger");
	self.acOtherCombineCollisionTriggerL = getChild(self.acI3D,"otherCombColliTriggerL");
	self.acOtherCombineCollisionTriggerR = getChild(self.acI3D,"otherCombColliTriggerR");
	self.acBorderDetected = nil;	
	self.acFruitsDetected = nil;
	
  self.acAutoRotateBackSpeedBackup = self.autoRotateBackSpeed;	

	self.acHelpPanelPath     = Utils.getFilename("AutoCombineHud.dds", AcDirectory);
	self.acHudWidth          = 0.215 --0.178;
	self.acHudHeight         = 0.215; 
	self.acHudPosX           = 0.025;   
	self.acHudPosY           = 0.0108;  
	self.acHelpPanelBtnPosX  = 0.04;     
	self.acHelpPanelBtnPosY  = 0.6;  --0.454 
	self.acHelpPanelTextPosX = self.acHelpPanelBtnPosX;--0.024;     
	self.acHelpPanelTextPosY = 0.02;  --0.454 
	self.acHelpPanelOverlay  = Overlay:new("AutoCombineHud", self.acHelpPanelPath, self.acHudPosX, self.acHudPosY, self.acHudWidth, self.acHudHeight);
	self.acGuiActive         = false;

	AutoCombine.addButton(self,Utils.getFilename("off.dds", AcDirectory), Utils.getFilename("on.dds", AcDirectory), AutoCombine.onStart, AutoCombine.evalStart, 0.00,0.40, "HireEmployee", "DismissEmployee" );
	AutoCombine.addButton(self,Utils.getFilename("no_wait.dds", AcDirectory),Utils.getFilename("wait.dds", AcDirectory), AutoCombine.setWait, AutoCombine.evalWait, 0.04,0.40, "AC_COMBINE_WAITMODE_OFF", "AC_COMBINE_WAITMODE_ON" );	
	AutoCombine.addButton(self,Utils.getFilename("inactive_left.dds", AcDirectory), Utils.getFilename("active_left.dds", AcDirectory), AutoCombine.setAreaLeft, AutoCombine.evalAreaLeft, 0.08,0.40, "AC_COMBINE_TXT_ACTIVESIDERIGHT", "AC_COMBINE_TXT_ACTIVESIDELEFT" );
	AutoCombine.addButton(self,Utils.getFilename("inactive_right.dds", AcDirectory), Utils.getFilename("active_right.dds", AcDirectory), AutoCombine.setAreaRight, AutoCombine.evalAreaRight, 0.12,0.40, "AC_COMBINE_TXT_ACTIVESIDELEFT", "AC_COMBINE_TXT_ACTIVESIDERIGHT" );
	AutoCombine.addButton(self,Utils.getFilename("next.dds", AcDirectory), Utils.getFilename("no_next.dds", AcDirectory), AutoCombine.nextTurnStage, AutoCombine.evalTurnStage, 0.16,0.40, "AC_COMBINE_TXT_NEXTTURNSTAGE", nil );
	
	AutoCombine.addButton(self,Utils.getFilename("ai_combine.dds", AcDirectory), Utils.getFilename("auto_combine.dds", AcDirectory), AutoCombine.onEnable, AutoCombine.evalEnable, 0.00,0.45, "AC_COMBINE_TXT_STOP", "AC_COMBINE_TXT_START" );
	AutoCombine.addButton(self,Utils.getFilename("no_distance.dds", AcDirectory),Utils.getFilename("distance.dds", AcDirectory), AutoCombine.setOtherCombine, AutoCombine.evalOtherCombine, 0.04,0.45, "AC_COMBINE_COLLISIONTRIGGERMODE_OFF", "AC_COMBINE_COLLISIONTRIGGERMODE_ON" );	
	AutoCombine.addButton(self,Utils.getFilename("no_uturn2.dds", AcDirectory),Utils.getFilename("uturn.dds", AcDirectory), AutoCombine.setUTurn, AutoCombine.evalUTurn, 0.08,0.45, "AC_COMBINE_UTURN_OFF", "AC_COMBINE_UTURN_ON") ;
	AutoCombine.addButton(self,Utils.getFilename("reverse.dds", AcDirectory), Utils.getFilename("no_reverse.dds", AcDirectory), AutoCombine.setNoReverse, AutoCombine.evalNoReverse, 0.12,0.45, "AC_COMBINE_REVERSE_ON", "AC_COMBINE_REVERSE_OFF");
	AutoCombine.addButton(self,Utils.getFilename("no_cp.dds", AcDirectory), Utils.getFilename("cp.dds", AcDirectory), AutoCombine.setCPSupport, AutoCombine.evalCPSupport, 0.16,0.45, "AC_COMBINE_TXT_CP_OFF", "AC_COMBINE_TXT_CP_ON" );


	--AutoCombine.addButton(self,Utils.getFilename("magic.dds", AcDirectory),nil, AutoCombine.detectWidth, nil, 0.06,0.40);
	AutoCombine.addButton(self,Utils.getFilename("bigger.dds", AcDirectory),   nil, AutoCombine.setWidthUp,   nil, 0.00,0.50, "AC_COMBINE_WIDTH_OFFSET", nil, AutoCombine.getWidth);
	AutoCombine.addButton(self,Utils.getFilename("smaller.dds", AcDirectory),  nil, AutoCombine.setWidthDown, nil, 0.04,0.50, "AC_COMBINE_WIDTH_OFFSET", nil, AutoCombine.getWidth);
	AutoCombine.addButton(self,Utils.getFilename("forward.dds", AcDirectory),  nil, AutoCombine.setForward,   nil, 0.08,0.50, "AC_COMBINE_TURN_OFFSET", nil, AutoCombine.getTurnOffset);
	AutoCombine.addButton(self,Utils.getFilename("backward.dds", AcDirectory), nil, AutoCombine.setBackward,  nil, 0.12,0.50, "AC_COMBINE_TURN_OFFSET", nil, AutoCombine.getTurnOffset);
	
	self.acRefNode = self.aiTreshingDirectionNode;

	if      self.articulatedAxis ~= nil 
			and self.articulatedAxis.componentJoint ~= nil
      and self.articulatedAxis.componentJoint.jointNode ~= nil 
			and self.articulatedAxis.rotMax then	
		self.acRefNode = self.components[self.articulatedAxis.componentJoint.componentIndices[2]].node;
	end;

	-- for courseplay  
	self.acNumCollidingVehicles = 0;

end;

------------------------------------------------------------------------
-- addButton
------------------------------------------------------------------------
function AutoCombine.addButton(self, imgEnabled, imgDisabled, cbOnClick, cbVisible, x,y, textEnabled, textDisabled, textCallback, width,height)
	local x1 = self.acHelpPanelBtnPosX + x;
	local y2 = self.acHelpPanelBtnPosY - y;
	local x2 = x1+0.03;
	if width ~= nil then
		local x2 = x1+abs(width);
	end;
	local y1 = y2-0.04;
	if height ~= nil then
		local y1 = y2-abs(height);
	end;
	local overlay = Overlay:new(nil, imgEnabled, x1,y1,x2-x1,y2-y1);
	local overlay2 = nil;
	if imgDisabled == nil then
		overlay2 = Overlay:new(nil, Utils.getFilename("empty.dds", AcDirectory), x1,y1,x2-x1,y2-y1);
	else
		overlay2 = Overlay:new(nil, imgDisabled, x1,y1,x2-x1,y2-y1);
    end;
    local button = {enabled=true, ovEnabled=overlay, ovDisabled=overlay2, onClick=cbOnClick, onVisible=cbVisible, twoState=(imgDisabled ~= nil), rect={x1,y1,x2,y2}, text1 = textEnabled, text2 = textDisabled, textcb = textCallback };
    table.insert(self.acButtons, button);
    return button;
end;

------------------------------------------------------------------------
-- newMouseEvent
------------------------------------------------------------------------
function AutoCombine:newMouseEvent(superFunc, posX, posY, isDown, isUp, button)
	if self.acGuiActive then
		local x = InputBinding.mouseMovementX;
		local y = InputBinding.mouseMovementY;
		InputBinding.mouseMovementX = 0;
		InputBinding.mouseMovementY = 0;
		superFunc(self,posX, posY, isDown, isUp, button);
		InputBinding.mouseMovementX = x;
		InputBinding.mouseMovementY = y;
	else
		superFunc(self,posX, posY, isDown, isUp, button);
	end;
end;

------------------------------------------------------------------------
-- mouseEvent
------------------------------------------------------------------------
function AutoCombine:mouseEvent(posX, posY, isDown, isUp, button)

	self.acTooltip = nil;
	local textID, textCB;
	if self.acGuiActive then
		for _,overlayButton in pairs(self.acButtons) do
			if overlayButton.rect[1] <= posX and posX <= overlayButton.rect[3] and overlayButton.rect[2] <= posY and posY <= overlayButton.rect[4] then
				if overlayButton.onClick ~= nil and isDown and button == 1 then
					if overlayButton.enabled then
						if overlayButton.twoState ~= nil then
							overlayButton.onClick(self, true);
						else
							overlayButton.onClick(self);
						end;
					elseif overlayButton.twoState then
						overlayButton.onClick(self, false);
					end;
					AutoCombine.sendParameters(self);
				end
				if  overlayButton.text1 ~= nil 
						and ( overlayButton.enabled 
							or not overlayButton.twoState 
							or overlayButton.text2 == nil ) then
					textID = overlayButton.text1;
				elseif overlayButton.text2 ~= nil then
					textID = overlayButton.text2;
				end;
				textCB = overlayButton.textcb;
				break;				
			end;
		end;
	end;
	
	if textID ~= nil then
		self.acTooltip = acGetText( textID );
		if textCB ~= nil then 
			self.acTooltip = textCB(self,self.acTooltip) 
		end
	end
end

------------------------------------------------------------------------
-- renderButtons
------------------------------------------------------------------------
function AutoCombine.renderButtons(self)
  for _,button in pairs(self.acButtons) do
    if button.onVisible ~= nil then
			button.enabled = button.onVisible(self);
		end;
		if button.enabled then
			if button.ovEnabled ~= nil then
				button.ovEnabled:render();
			end;
		else
			if button.ovDisabled ~= nil then
				button.ovDisabled:render();
			end;
		end;
  end;	
end;

------------------------------------------------------------------------
-- mouse event callbacks
------------------------------------------------------------------------
function AutoCombine.showGui(self,on)
  self.acGuiActive = on;
  g_mouseControlsHelp.active = not on;
	InputBinding.setShowMouseCursor(on);		
end;

function AutoCombine:evalUTurn()
	return not self.acParameters.upNDown;
end;

function AutoCombine:setUTurn(enabled)
	self.acParameters.upNDown = enabled;
end;

function AutoCombine:evalWait()
	return not self.acParameters.waitMode;
end;

function AutoCombine:setWait(enabled)
	self.acParameters.waitMode = enabled;
end;

function AutoCombine:evalAreaLeft()
	return not self.acParameters.leftAreaActive;
end;

function AutoCombine:setAreaLeft(enabled)
	if not enabled then return; end;
	self.acParameters.leftAreaActive  = enabled;
	self.acParameters.rightAreaActive = not enabled;
end;

function AutoCombine:evalAreaRight()
	return not self.acParameters.rightAreaActive;
end;

function AutoCombine:setAreaRight(enabled)
	if not enabled then return; end;
	self.acParameters.rightAreaActive = enabled;
	self.acParameters.leftAreaActive  = not enabled;
end;

function AutoCombine:evalStart()
	return not self.isAIThreshing or not self:canStartAIThreshing();
end;

function AutoCombine:onStart(enabled)
  if self.isAIThreshing and not enabled then
    self:stopAIThreshing()
  elseif self:canStartAIThreshing() and enabled then
    self:startAIThreshing()
  end
end;

function AutoCombine:evalEnable()
	return not self.acParameters.enabled;
end;

function AutoCombine:onEnable(enabled)
	if not self.isAIThreshing then
		self.acParameters.enabled = enabled;
	end;
end;

function AutoCombine:evalOtherCombine()
	return not self.acParameters.otherCombine;
end;

function AutoCombine:setOtherCombine(enabled)
	self.acParameters.otherCombine = enabled;
end;

function AutoCombine:evalNoReverse()
	return not self.acParameters.noReverse;
end;

function AutoCombine:setNoReverse(enabled)
	self.acParameters.noReverse = enabled;
end;

function AutoCombine:setWidthUp()
	self.acParameters.widthOffset = self.acParameters.widthOffset + 0.125;
	self.acDimensions = nil;
end;

function AutoCombine:setWidthDown()
	self.acParameters.widthOffset = self.acParameters.widthOffset - 0.125;
	self.acDimensions = nil;
end;

function AutoCombine:getWidth(old)
	new = string.format(old..": %0.2fm",self.acParameters.widthOffset+self.acParameters.widthOffset);
	return new
end

function AutoCombine:setForward()
	self.acParameters.turnOffset = self.acParameters.turnOffset + 0.25;
	self.acDimensions = nil;
end;                                               

function AutoCombine:setBackward()               
	self.acParameters.turnOffset = self.acParameters.turnOffset - 0.25;
	self.acDimensions = nil;
end;

function AutoCombine:getTurnOffset(old)
	new = string.format(old..": %0.2fm",self.acParameters.turnOffset);
	return new
end

function AutoCombine:evalTurnStage()
	if self.acParameters.enabled then
		if     self.acTurnStage == 2 
				or self.acTurnStage == 12
				or self.acTurnStage == 15
				or self.acTurnStage == 17
				or self.acTurnStage == 18 then
			return true
		end
--	else
--		if self.turnStage > 0 and self.turnStage < 4 then
--			return true;
--		end
	end
	
	return false
end

function AutoCombine:nextTurnStage()
	AutoCombine.setNextTurnStage(self);
end

function AutoCombine:evalCPSupport()
	return not self.acParameters.CPSupport;
end

function AutoCombine:setCPSupport(enabled)
	self.acParameters.CPSupport = enabled;
end

------------------------------------------------------------------------
-- delete
------------------------------------------------------------------------
function AutoCombine:delete()
end;

------------------------------------------------------------------------
-- keyEvent
------------------------------------------------------------------------
function AutoCombine:keyEvent(unicode, sym, modifier, isDown)
	
	if isDown and sym == Input.KEY_s then
		self.speed2Level = 0;
	end;	
end;

------------------------------------------------------------------------
-- update
------------------------------------------------------------------------
function AutoCombine:update(dt)

	if      self.acParameters          ~= nil
			and courseplay                 ~= nil 
			and oldCourseplaySide_to_drive == nil then
		oldCourseplaySide_to_drive = courseplay.side_to_drive;
		courseplay.side_to_drive   = AutoCombine.cpSideToDrive;
		print("AutoCombine was added to CoursePlay");
	end

	if self:getIsActiveForInput(false) then
		if InputBinding.hasEvent(InputBinding.AC_COMBINE_HELPPANEL) then
			AutoCombine.showGui( self, not self.acGuiActive );
		end;
		if	InputBinding.hasEvent(InputBinding.SPEED_LEVEL1) then
			self.speed2Level = 1;
		elseif InputBinding.hasEvent(InputBinding.SPEED_LEVEL2) then
			self.speed2Level = 2;
		elseif InputBinding.hasEvent(InputBinding.SPEED_LEVEL3) then
			self.speed2Level = 3;
		elseif InputBinding.hasEvent(InputBinding.SPEED_LEVEL4) then
			self.speed2Level = 4;
		end;
	end;
	
	if self.acGuiActive or self.acParameters.enabled then
		if not self.acNodeIsLinked then
			AutoCombine.calculateDimensions(self);	
			self.acNodeIsLinked = true;
			link(self.acRefNode,self.acI3D);
		end;
	end;

	if      self.acGuiActive
			and self:getIsActiveForInput(false)
			and self.acParameters.enabled then
			
		AutoCombine.calculateDimensions(self);	
		if self.acDimensions ~= nil then				
			local a,n,l,d = 0,0,4,0;
			for _,wheel in pairs(self.wheels) do
				if wheel.rotSpeed < -1E-03 then
					a = a - wheel.steeringAngle;
					n = n + 1;
				end;
			end;
			
			if n > 1 then a = a / n end;		
			if not self.acParameters.leftAreaActive then a = -a; end;
			if     a < -self.acDimensions.maxSteeringAngle then a = -self.acDimensions.maxSteeringAngle
			elseif a >  self.acDimensions.maxLookingAngle  then a =  self.acDimensions.maxLookingAngle end;
			
			d = AutoCombine.calculateWidth(self,l,a);
			if not self.acParameters.leftAreaActive then d = -d; end;
			
			local x0,y0,z0,x1,y1,z1;
			x1,y1,z1 = localDirectionToWorld( self.acRefNode, d,0,l) ;
			
			--x0,y0,z0 = getWorldTranslation(lm);
			x0,y0,z0 = localToWorld( self.acRefNode, self.acDimensions.xLeft,0.25,self.acDimensions.zLeft );
				
			drawDebugArrow(x0,y0,z0,x1,0,z1,x1,0,z1,1,0,0);
			drawDebugArrow(x0,y0+1,z0,x1,0,z1,x1,0,z1,1,0,0);
			drawDebugArrow(x0,y0+1,z0,0,-1,0,0,-1,0,1,0,0);

			--x0,y0,z0 = getWorldTranslation(rm);
			x0,y0,z0 = localToWorld( self.acRefNode, self.acDimensions.xRight,0.25,self.acDimensions.zRight );
				
			drawDebugArrow(x0,y0,z0,x1,0,z1,x1,0,z1,1,0,0);
			drawDebugArrow(x0,y0+1,z0,x1,0,z1,x1,0,z1,1,0,0);
			drawDebugArrow(x0,y0+1,z0,0,-1,0,0,-1,0,1,0,0);
		end;
	end;
end;

------------------------------------------------------------------------
-- updateTick
------------------------------------------------------------------------
function AutoCombine:updateTick(dt)

  if      self.isServer
			and self.isAIThreshing 
			and self.acParameters.waitMode 
			and self.grainTankCapacity > 0
			and self.grainTankFillLevel > 0.1*self.grainTankCapacity 
			and not self.waitingForDischarge 
			and next(self.combineTrailersInRange) ~= nil 
			then		
    self.driveBackAfterDischarge = true
    self.waitingForDischarge     = true
    self.waitForDischargeTime    = self.time + self.waitForDischargeTimeout
	end;
	
	if self.acDimensions == nil then
		self.acRecalculateDt = 0
	else
		self.acRecalculateDt = self.acRecalculateDt + dt
		if self.acTurnStage == 0 and self.acRecalculateDt > 60000 then
			self.acRecalculateDt = 0
			self.acDimensions    = nil;
		end
	end
		
	if self.isServer then
		if self.acParameters.otherCombine then	
			AutoCombine.addOtherCombineCollisionTrigger(self);
		else
			AutoCombine.removeOtherCombineCollisionTrigger(self);
		end
	end		

	if self.acTurnStageSent ~= self.acTurnStage then
		self.acTurnStageSent = self.acTurnStage;
    if g_server ~= nil then
      g_server:broadcastEvent(AutoCombineTurnStageEvent:new(self,self.acTurnStage), nil, nil, self)
    else
      g_client:getServerConnection():sendEvent(AutoCombineNextTSEvent:new(self,self.acTurnStage))
    end
	end
end

------------------------------------------------------------------------
-- attachImplement
------------------------------------------------------------------------
function AutoCombine:attachImplement(implement)
	self.acDimensions = nil;
end;

------------------------------------------------------------------------
-- detachImplement
------------------------------------------------------------------------
function AutoCombine:detachImplement(implementIndex)
	self.acDimensions = nil;
end;

------------------------------------------------------------------------
-- AICombine:canStartAIThreshing
------------------------------------------------------------------------
local oldAICombineCanStartAIThreshing = AICombine.canStartAIThreshing;
function AICombine:canStartAIThreshing()

	if self.acParameters == nil or self.acParameters.enabled == nil or not self.acParameters.enabled then
		return oldAICombineCanStartAIThreshing(self);
	end
  if g_currentMission.disableCombineAI then
    return false
  end
  if not self:getIsStartThreshingAllowed() then
    return false
  end
  if      self.numAttachedTrailers > 0 
			and ( self.acParameters           == nil
			   or self.acParameters.enabled   == nil 
				 or not self.acParameters.enabled
				 or self.acParameters.upNDown   == nil
				 or not self.acParameters.upNDown
			   or self.acParameters.noReverse == nil 
				 or not self.acParameters.noReverse ) then
    return false
  end
  if Hirable.numHirablesHired >= g_currentMission.maxNumHirables then
    return false
  end
  return true
end

------------------------------------------------------------------------
-- AICombine:getIsAIThreshingAllowed
------------------------------------------------------------------------
local oldAICombineGetIsAIThreshingAllowed = AICombine.getIsAIThreshingAllowed;
AICombine.getIsAIThreshingAllowed = function(self)

	if self.acParameters == nil or self.acParameters.enabled == nil or not self.acParameters.enabled then
		return oldAICombineGetIsAIThreshingAllowed(self);
	end
  if g_currentMission.disableCombineAI then
    return false
  end
  if not self:getIsStartThreshingAllowed() then
    return false
  end
  if      self.numAttachedTrailers > 0 
			and ( self.acParameters           == nil
			   or self.acParameters.enabled   == nil 
				 or not self.acParameters.enabled
				 or self.acParameters.upNDown   == nil
				 or not self.acParameters.upNDown
			   or self.acParameters.noReverse == nil 
				 or not self.acParameters.noReverse ) then
    return false
  end
  return true
end


------------------------------------------------------------------------
-- AICombine:startAIThreshing
------------------------------------------------------------------------
local oldAICombineStartAIThreshing = AICombine.startAIThreshing;
AICombine.startAIThreshing = function(self, noEventSend)
	
	-- just to be safe...
	if self.acParameters ~= nil and self.acParameters.enabled then
		self.acDimensions  = nil;
		self.acTurnStage   = 22;
		self.turnTimer     = self.acDeltaTimeoutWait;
		self.aiRescueTimer = self.acDeltaTimeoutStop;
		self.waitForTurnTime = 0;
		
		if self.speed2Level == nil or self.speed2Level < 1 or self.speed2Level > 4 then
			self.speed2Level = 2
			for cutter, implement in pairs(self.attachedCutters) do
				if Cutter.getUseLowSpeedLimit(cutter) then
					self.speed2Level = 1
				end
			end
		end
		
		AutoCombine.sendParameters(self);

		AutoCombine.addBackTrafficCollisionTrigger(self);
	end

	return oldAICombineStartAIThreshing(self, noEventSend);
end;

------------------------------------------------------------------------
-- AICombine:stopAIThreshing
------------------------------------------------------------------------
local oldAICombineStopAIThreshing = AICombine.stopAIThreshing;
AICombine.stopAIThreshing = function(self, noEventSend)
	AutoCombine.removeBackTrafficCollisionTrigger(self);
	return oldAICombineStopAIThreshing(self, noEventSend);
end;

function AutoCombine:getFruitArea(x1,z1,x2,z2,d,fruitType,hasFruitPreparer)
	local lx1,lz1,lx2,lz2,lx3,lz3 = AutoCombine.getParallelogram( self, x1, z1, x2, z2, d );
	return Utils.getFruitArea(fruitType, lx1,lz1,lx2,lz2,lx3,lz3, hasFruitPreparer);
end

function AutoCombine:isField(x1,z1,x2,z2)
	local lx1,lz1,lx2,lz2,lx3,lz3 = AutoCombine.getParallelogram( self, x1, z1, x2, z2, 0 );

	for i=0,3 do
		if Utils.getDensity(g_currentMission.terrainDetailId, i, lx1,lz1,lx2,lz2,lx3,lz3) ~= 0 then
			return true;
		end;
	end;

	return false;
	
end
------------------------------------------------------------------------
-- AICombine:updateAIMovement
------------------------------------------------------------------------
local oldAICombineUpdateAIMovement = AICombine.updateAIMovement;
AICombine.updateAIMovement = function(self, dt)

	if self.acParameters == nil or self.acParameters.enabled == nil or not self.acParameters.enabled then
		return oldAICombineUpdateAIMovement(self,dt);
	end;

  if not self:getIsAIThreshingAllowed() then
    self:stopAIThreshing()
    return
  end
  if not self.isControlled then
    if g_currentMission.environment.needsLights then
      self:setLightsVisibility(true)
    else
      self:setLightsVisibility(false)
    end
  end
  local allowedToDrive = true
  if self.grainTankCapacity == 0 then
    if not self.pipeStateIsUnloading[self.currentPipeState] then
      allowedToDrive = false
    end
    if not self.isPipeUnloading and (0 < self.lastArea or 0 < self.lastLostGrainTankFillLevel) then
      self.waitingForTrailerToUnload = true
    end
  elseif self.grainTankFillLevel >= self.grainTankCapacity then
    allowedToDrive = false
  end
  if self.waitingForTrailerToUnload then
    if self.lastValidGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
      do
        local trailer = self:findTrailerToUnload(self.lastValidGrainTankFruitType)
        if trailer ~= nil then
          self.waitingForTrailerToUnload = false
        end
      end
    else
      self.waitingForTrailerToUnload = false
    end
  end
  if self.grainTankFillLevel >= self.grainTankCapacity and self.grainTankCapacity > 0 or self.waitingForTrailerToUnload or self.waitingForDischarge then
    allowedToDrive = false
  end
  for _, v in pairs(self.numCollidingVehicles) do
    if v > 0 then
			self.acHelpPanelInfoText = acGetText("AC_COMBINE_COLLISION_OTHER");
      allowedToDrive = false
      break
    end
  end
	
	if self.acTurnStage == 2 or self.acTurnStage == 18 then
		for _, v in pairs(self.acCollidingVehicles) do
			if v > 0 then
				self.acHelpPanelInfoText = acGetText("AC_COMBINE_COLLISION_BACK");
				allowedToDrive = false
				break
			end
		end
	end
	
	local moveForwards = true;
  local speedLevel = self.speed2Level;--2
  if not self:getIsThreshingAllowed(true) then
    allowedToDrive = false
    self:setIsThreshing(false)
    self.waitingForWeather = true
  elseif self.waitingForWeather then
    if self.acTurnStage == 0 or self.acTurnStage >= 20 then
      self.driveBackTime = self.time + self.driveBackTimeout
    end
    self:startThreshing()
    self.waitingForWeather = false
  end
	
  if not allowedToDrive or speedLevel == 0 then
    AIVehicleUtil.driveInDirection(self, dt, 30, 0, 0, 28, false, moveForwards, nil, nil)
    return
  end

  if self.driveBackTime ~= nil and self.driveBackTime >= self.time then
    local x, y, z = getWorldTranslation(self.aiTreshingDirectionNode)
    local lx, lz = AIVehicleUtil.getDriveDirection(self.aiTreshingDirectionNode, self.aiThreshingTargetX, y, self.aiThreshingTargetZ)
    AIVehicleUtil.driveInDirection(self, dt, 30, 0, 0, 28, true, false, nil, nil, speedLevel, 1)
    return
  end

  local hasFruitPreparer = false
  local fruitType = self.lastValidInputFruitType

--==============================================================				
-- find fruit type if cutter supports only one
	if self.acTurnStage == 22 and fruitType == FruitUtil.FRUITTYPE_UNKNOWN then
		local found = nil;
		for cutter, implement in pairs(self.attachedCutters) do
			for i,f in pairs(cutter.fruitTypes) do
				if f and i>0 then
					if fruitType == FruitUtil.FRUITTYPE_UNKNOWN then
						found = true;
						fruitType = i;
					elseif fruitType ~= i then
						found = false;
						break;
					end
				end
			end
		end
		
		if found == nil or not found then
			fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
		end
	end

-- find fruit type looking ahead
	if self.acTurnStage == 22 and fruitType == FruitUtil.FRUITTYPE_UNKNOWN then
		AutoCombine.calculateDimensions(self);
		d = - self.acDimensions.distance - self.acDimensions.distance;
		if not self.acParameters.leftAreaActive then d = -d; end;

		for cutter, implement in pairs(self.attachedCutters) do
			for i,f in pairs(cutter.fruitTypes) do
				if f and i>0 then
					if AutoCombine.getFruitArea( self, 0, -1, d, 10, 0, i, false ) > 0 then
						fruitType = i;
						break;
					end
				end
			end
			if fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then break end
		end
	end
	
  if self.fruitPreparerFruitType ~= nil and self.fruitPreparerFruitType == fruitType then
    hasFruitPreparer = true
  end

	local angle = 0;
	self.acBorderDetected = false;
	self.turnTimer = self.turnTimer - dt;
	
	if self.acTurnStage == 0 or self.acTurnStage >= 20 then
		self.aiRescueTimer = self.aiRescueTimer - dt;
	else
		self.aiRescueTimer = self.acDeltaTimeoutStop;
	end
	
	if self.aiRescueTimer < 0 then
		self:stopAIThreshing();
		--self.acHelpPanelInfoText = "Stopped";
		return;
	end;
	
--==============================================================				
-- calculate...		
	if fruitType == FruitUtil.FRUITTYPE_UNKNOWN then
		self.setAIImplementsMoveDown(self,true);
	else
		AutoCombine.calculateDimensions(self);
	
		local offsetOutside = 0;
		if     self.acParameters.rightAreaActive then
			offsetOutside = -1;
		elseif self.acParameters.leftAreaActive then
			offsetOutside = 1;
		end;
			
		self.acHelpPanelInfoText = "";				
		
		local d, lookAhead = 0,10;							
		local border;	
		local aaDiffX, aaDiffZ = 0,0;
		
--==============================================================				
		self.acFruitsDetected = false;
		
		if     self.acTurnStage == 17 then -- and self.acParameters.noReverse then
			d = - self.acDimensions.distance - self.acDimensions.distance;
			if not self.acParameters.leftAreaActive then d = -d; end;
			self.acFruitsDetected = AutoCombine.getFruitArea( self, 0, -2, d, 2, 0, fruitType, hasFruitPreparer ) > 0;
		elseif self.acTurnStage == 2 then --or self.acTurnStage == 18 then
			local w = math.min( 1.4 * self.acDimensions.distance, 0.7 * (self.acDimensions.cutterDistance + self.acDimensions.wheelBase) );
			d = - self.acDimensions.distance - self.acDimensions.distance;
			if not self.acParameters.leftAreaActive then d = -d; end;
			self.acFruitsDetected = AutoCombine.getFruitArea( self, 0, -w, d, w, 0, fruitType, hasFruitPreparer ) > 0;
		elseif self.acTurnStage == 11 or self.acTurnStage == 15 then
			d = self.acDimensions.distance + self.acDimensions.distance;
			self.acFruitsDetected = AutoCombine.getFruitArea( self, -self.acDimensions.distance, 0, d, 1, 0, fruitType, hasFruitPreparer ) > 0;		
		elseif self.acTurnStage == 0 or self.acTurnStage >= 20 then
			d = self.acDimensions.distance + self.acDimensions.distance;
			d = - math.max( 0.9 * d, d - 1 );
			if not self.acParameters.leftAreaActive then d = -d; end;
			self.acFruitsDetected = AutoCombine.getFruitArea( self, 0, -2, d, 3, 0, fruitType, hasFruitPreparer ) > 0;		
		end;		

--==============================================================				
		if self.acTurnStage == 0 or self.acTurnStage >= 20 then
-- look 3 to 10 meters ahead				
			local found = self.acFruitsDetected;
			if self.acTurnStage == 0 then found = true end;
			
			local lmin = math.min( 5, 1    + math.max( 1, 0.6 * self.acDimensions.distance ) );
			local lmax = math.min(10, lmin + math.max( 2, math.floor( 0.6 * self.acDimensions.distance + 0.5 ) ) );

--			if found then
--				d = - self.acDimensions.distance - self.acDimensions.distance;
--				if not self.acParameters.leftAreaActive then d = -d; end;
--				while not AutoCombine.isField( self, 0, lmax, d, 1 ) do
--					lmax = lmax - 1;
--					if lmax < lmin then 
--						lmin = lmin - 1;
--						if lmin < 0.5 then
--							break
--						end
--					end
--				end
--			end
						
			lookAhead = lmin;
			while lookAhead < lmax do --10 do
				d = AutoCombine.calculateWidth(self,lookAhead-1,self.acDimensions.maxLookingAngle);
				local w = math.max(1, AutoCombine.calculateWidth(self,lookAhead-1,-self.acDimensions.maxSteeringAngle) + d );
				if not self.acParameters.leftAreaActive then 
					d = -d;
				else
					w = -w;
				end;
				if     not AutoCombine.isField( self, d, lookAhead, w, 1, 0 ) then
					break;
				elseif not found and AutoCombine.getFruitArea( self, d, lookAhead-1, w, 1, 0, fruitType, hasFruitPreparer ) > 0 then
					found = true;
				elseif found and ( lookAhead >= lmax or AutoCombine.getFruitArea( self, d, lookAhead-1, w, 1, 0, fruitType, hasFruitPreparer ) <= 0 ) then
					break;
				end;
				lookAhead = lookAhead + 1;
				if lookAhead > 10 then
					lookAhead = 10;
					break;
				end;
			end;
	

			if lookAhead < 0.5 then
				self.acFruitsDetected = false;		
				self.acBorderDetected = false;
				border                = 0;
			else
				angle        = 0;	
				border       = AutoCombine.getFruitArea( self, 0, 0, offsetOutside, lookAhead, 0, fruitType, hasFruitPreparer );
				local factor = 0.05;			
				if border <= 0 then
					factor = -factor;					
				elseif self.acDimensions.maxLookingAngle < self.acDimensions.maxSteeringAngle then
					factor = factor * self.acDimensions.maxLookingAngle / self.acDimensions.maxSteeringAngle
				end 
				
				for i=1,20 do
					local a = factor*i*self.acDimensions.maxSteeringAngle; 							
					d = AutoCombine.calculateWidth(self,lookAhead,a);
					if not self.acParameters.leftAreaActive then d = -d; end;
					if self.acDimensions.aaAngleFactor > 0 then
						aaDiffX = math.sin( self.acDimensions.aaAngleFactor * a ) * self.acDimensions.aaDistance;
						aaDiffZ = ( math.cos( self.acDimensions.aaAngleFactor * a ) - 1 ) * self.acDimensions.aaDistance;
						if not self.acParameters.leftAreaActive then aaDiffX = -aaDiffX; end;
					end

					b = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
					
					if     border > 0 then
						if b <= 0 then
							self.acBorderDetected = true;
							angle = a;
							break
						end
					else
						if b > 0 then
							self.acBorderDetected = true;
							break
						end
					end
					angle = a;
				end
			end
			
			if not self.acBorderDetected then
				if      self.acTurnStage              >= 20
						and self.acTurnStage              <= 21
						and self.acDirectionBeforeTurn.tx ~= nil
						and self.acDirectionBeforeTurn.tz ~= nil then
					angle = nil;			
				elseif border > 0 then
					angle = self.acDimensions.maxSteeringAngle;
					self.acTurn2Outside = true;
				else
					angle = -self.acDimensions.maxSteeringAngle;
					self.acTurn2Outside = false;
					if      self.acTurnStage == 0 
							and self.turnTimer  <= self.acDeltaTimeoutRun then
						local l = AutoCombine.getTraceLength(self);
						local a = math.deg(AutoCombine.getTurnAngle(self));
						if not self.acParameters.leftAreaActive then a = -a; end;
--						if      ( self.acParameters.upNDown or self.acDimensions.aaAngleFactor > 1E-6 )
--								and l >= self.acDimensions.distance + self.acDimensions.distance 
--								and a < -9 then
--							angle = 0;
--						elseif  l >= 1
--								and a < -30 then
--							angle = 0;
--						end
						if      l >= 1
								and a < -15 then
							angle = 0;
						end
					elseif  self.acTurnStage >= 21 
							and not self.acFruitsDetected then
						angle = 0;
					end
				end
			end
			
--==============================================================				
-- backwards
		elseif self.acTurnStage == 2 or self.acTurnStage == 18 then
			angle = 0;
			self.acBorderDetected = false

			local factor = 0.1;
			local found  = self.acFruitsDetected;
			if not self.acTurn2Outside then
				factor = -factor
			elseif self.acDimensions.maxLookingAngle < self.acDimensions.maxSteeringAngle then
				factor = factor * self.acDimensions.maxLookingAngle / self.acDimensions.maxSteeringAngle
			end

			for i = 0,10 do
				a = factor*i*self.acDimensions.maxSteeringAngle;
				d = AutoCombine.calculateWidth(self,lookAhead, a);
				if not self.acParameters.leftAreaActive then d = -d; end;
				if self.acDimensions.aaAngleFactor > 0 then
					aaDiffX = math.sin( self.acDimensions.aaAngleFactor * a ) * self.acDimensions.aaDistance;
					aaDiffZ = ( math.cos( self.acDimensions.aaAngleFactor * a ) - 1 ) * self.acDimensions.aaDistance;
					if not self.acParameters.leftAreaActive then aaDiffX = -aaDiffX; end;
				end
		
				border = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
					
				if self.acTurn2Outside then
-- to outside: search for empty border						
					if border > 0 then
						found = true
					elseif found then
						self.acBorderDetected = true;
						angle = a
						break;
					end
				else
-- to inside: search for filled border						
					if border > 0 then
						self.acBorderDetected = true;
						break;
					end
				end
				angle = a;
			end
			
			if not self.acBorderDetected then
				angle = nil
			end
			
--==============================================================		
-- U turn		
		elseif self.acTurnStage == 17 then
			angle = self.acDimensions.maxLookingAngle;
			d = AutoCombine.calculateWidth(self,lookAhead,angle);
			if not self.acParameters.leftAreaActive then d = -d; end;
		
			border = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, -offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
			
			if border > 0 then
				border = AutoCombine.getFruitArea( self, aaDiffX, aaDiffZ, offsetOutside, lookAhead, d, fruitType, hasFruitPreparer );
				if border < 1 then
					self.acBorderDetected = true;						
				end
			end
		end;
		
--==============================================================		
--==============================================================		

		if angle == nil then
			local m = self.acDimensions.maxSteeringAngle;
			
			if self.acTrunStage == 21 then
				angle = 0;
			elseif self.acTurn2Outside then
				angle = m;
			else
				angle = -m;
			end
		
			if self.acDirectionBeforeTurn.tx ~= nil and self.acDirectionBeforeTurn.tz ~= nil then
				local x,z,dx,dz,wx,wz;
				if self.acParameters.leftAreaActive then
					x,_,z = localToWorld(self.acRefNode, self.acDimensions.xLeft, 0, self.acDimensions.zLeft );
				else
					x,_,z = localToWorld(self.acRefNode, self.acDimensions.xRight, 0, self.acDimensions.zRight);
				end			dx = self.acDirectionBeforeTurn.tx - x;
				dz = self.acDirectionBeforeTurn.tz - z;		
				wx,_,wz = worldDirectionToLocal(self.acRefNode,dx,0,dz);
				
				--if wz < 0 then wz = -wz end

				if wz > 0.1 then
					
					if not self.acParameters.leftAreaActive then wx = -wx; end;
					
					dmax = AutoCombine.calculateWidth(self,wz, self.acDimensions.maxLookingAngle);
					dmin = AutoCombine.calculateWidth(self,wz,-self.acDimensions.maxSteeringAngle);
						
					if wx > dmax then
						angle = m;
					elseif wx < dmin then
						angle = -m;
					else
						angle = AutoCombine.calculateSteeringAngle(self,wx,wz);
					end
					if self.acTurnStage < 20 and math.abs(wx) < 0.2 and wz > 4 then
						self.acBorderDetected = true;									
					end
				end
			end
		end

--==============================================================		
--==============================================================		
		local turnAngle = math.deg(AutoCombine.getTurnAngle(self));
		if self.acParameters.leftAreaActive then
			turnAngle = -turnAngle;
		end;
		--self.acHelpPanelInfoText = string.format("turn angle = %3i",turnAngle);

--==============================================================		
-- move far enough			
		if     self.acTurnStage == 1 then

			if self.acParameters.CPSupport and turnAngle > -3 then
				angle = self.acDimensions.maxSteeringAngle;
			else
				angle = 0;
			end

			if self.acTurn2Outside or ( angle == 0 and AutoCombine.getTurnDistance(self) > self.acDimensions.insideDistance ) then
				self.setAIImplementsMoveDown(self,false);
				self.acTurnStage   = 4;
				self.turnTimer     = self.acDeltaTimeoutWait;
				allowedToDrive     = false;				
				self.waitForTurnTime = self.time + self.turnTimer;
			end

--==============================================================				
-- wait before going back				
		elseif self.acTurnStage == 4 then
			allowedToDrive = false;				
			moveForwards   = false;					

			if self.acTurn2Outside then				
				angle = self.acDimensions.maxSteeringAngle;
			else
				angle = -self.acDimensions.maxSteeringAngle;
			end;
			
			--if self.turnTimer < 0 then
			if self.waitForTurnTime < self.time then
				self.acTurnStage = 2;
				self.turnTimer   = self.acDeltaTimeoutWait;
			end;

--==============================================================				
-- going back
		elseif self.acTurnStage == 2 then

			moveForwards = false;					
		
			if     ( ( turnAngle > 30 or self.acTurn2Outside ) 
					 and self.acBorderDetected 
					 and not self.acFruitsDetected ) 
					or ( self.turnTimer < 0 and turnAngle > 90 ) then
				self.acTurnStage   = 3;
				self.turnTimer     = self.acDeltaTimeoutWait;
				self.lastTurnAngle = -angle;
				self.setAIImplementsMoveDown(self,true);
			end;

--==============================================================				
-- wait after going back					
		elseif self.acTurnStage == 3 then
			allowedToDrive = false;						
			
			angle = self.lastTurnAngle;
			
			if self.turnTimer < 0 then
				self.acTurnStage   = 20;					
				self.turnTimer     = self.acDeltaTimeoutStart;
			end;
			
--==============================================================				
-- wait before U-turn					
		elseif self.acTurnStage == 11 then
			allowedToDrive = false;						
			angle = 0;

			--if self.turnTimer < 0 then
			if self.waitForTurnTime < self.time then
				self.setAIImplementsMoveDown(self,false);
				if self.acTurn2Outside then
					self.acTurnStage = 12;
					self.turnTimer   = self.acDeltaTimeoutStop;
				else
					local dist = self.acDimensions.uTurnDistance2;
					if self.acParameters.noReverse then
						dist = self.acDimensions.uTurnDistance;
					end;

					if not self.acFruitsDetected and AutoCombine.getTurnDistance(self) > dist then
						self.acTurnStage = 17;
						self.lastTurnAngle = math.deg(AutoCombine.getTurnAngle(self));					
					else
						self.acTurnStage = 15;
						self.turnTimer   = self.acDeltaTimeoutWait;
					end
				end
			end
			
--==============================================================				
-- move to the right position before U-turn					
		elseif  self.acTurnStage == 12 then

			local ref = 0;
			if self.acParameters.noReverse then
				ref = math.deg(self.acDimensions.uTurnAngle);
			end;
			
			if self.acTurn2Outside then
				angle = -self.acDimensions.maxSteeringAngle;
										
				if turnAngle >= ref then
					self.acTurn2Outside = false;
					self.acTurnStage = 13;
					self.turnTimer   = self.acDeltaTimeoutRun;
				end
			else
				angle = self.acDimensions.maxSteeringAngle;
								
				if turnAngle <= 0 then
					local dist = self.acDimensions.uTurnDistance2;
					if self.acParameters.noReverse then
						dist = self.acDimensions.uTurnDistance;
					end;

					if AutoCombine.getTurnDistance(self) > dist then
						self.acTurnStage = 17;
						self.lastTurnAngle = math.deg(AutoCombine.getTurnAngle(self));					
					else
						self.acTurnStage = 14;
						self.turnTimer   = self.acDeltaTimeoutRun;
					end;
				end;
			end;

--==============================================================				
-- wait during U-turn
		elseif self.acTurnStage == 13 then
			allowedToDrive = false;						
			
			angle = self.acDimensions.maxSteeringAngle;
			
			if self.turnTimer < 0 then
				self.acTurnStage = 12;					
			end;

--==============================================================				
-- wait during U-turn before going forward
		elseif self.acTurnStage == 14 then
			allowedToDrive = false;						
			
			angle = 0;
			
			if self.turnTimer < 0 then
				self.acTurnStage = 15;					
			end;
			
--==============================================================				
-- go to the right distance before the U-turn
		elseif self.acTurnStage == 15 then

			angle = 0;
			
			local dist = self.acDimensions.uTurnDistance2;
			if self.acParameters.noReverse then
				dist = self.acDimensions.uTurnDistance;
			end;
				
			if not self.acFruitsDetected and AutoCombine.getTurnDistance(self) > dist then
				self.acTurnStage = 16;					
				self.turnTimer   = self.acDeltaTimeoutRun;
			end;

--==============================================================				
-- wait during U-turn after going forward
		elseif self.acTurnStage == 16 then

			allowedToDrive = false;						
												
			angle = self.acDimensions.maxSteeringAngle;
			if self.turnTimer < 0 then
				self.acTurnStage   = 17;					
				self.lastTurnAngle = math.deg(AutoCombine.getTurnAngle(self));					
			end;
			
--==============================================================				
-- The U-turn					
		elseif self.acTurnStage == 17 then

			local ref = -105;
			if self.acDimensions.aaAngleFactor > 1E-6 then ref = -120 end;
			
			if not self.acParameters.noReverse and turnAngle <= ref then
				self.acTurn2Outside   = true;
				self.acTurnStage      = 18;
				self.turnTimer        = self.acDeltaTimeoutStop;
			elseif turnAngle <= -175 then 
				self.acTurnStage      = 19;				
				self.lastTurnAngle    = 0;
				self.turnTimer        = self.acDeltaTimeoutRun;
				self.setAIImplementsMoveDown(self,true);
			elseif self.acFruitsDetected then
				if self.acBorderDetected then
					self.acTurnStage    = 19;				
					self.lastTurnAngle  = self.acDimensions.maxLookingAngle;
					self.turnTimer      = self.acDeltaTimeoutRun;
					self.setAIImplementsMoveDown(self,true);
				elseif not self.acParameters.noReverse and turnAngle <= -75 then
					self.acTurn2Outside = true;
					self.acTurnStage    = 18;
					self.turnTimer      = self.acDeltaTimeoutStop;
				end;
			end;
			
			angle = self.acDimensions.maxSteeringAngle;

--==============================================================				
-- going back
		elseif self.acTurnStage == 18 then

			moveForwards = false;					
			
			if      self.acBorderDetected 
					and not self.acFruitsDetected then
				self.acTurnStage    = 19;
				self.turnTimer      = self.acDeltaTimeoutRun;
				self.lastTurnAngle  = -angle;
				self.setAIImplementsMoveDown(self,true);
			elseif math.abs(turnAngle) > 175 then
				self.acTurnStage    = 19;
				self.turnTimer      = self.acDeltaTimeoutRun;
				self.lastTurnAngle  = 0;
				self.setAIImplementsMoveDown(self,true);
			end;

--==============================================================				
-- wait after U-turn
		elseif self.acTurnStage == 19 then
			allowedToDrive = false;						
			
			angle = self.lastTurnAngle;
			
			if self.turnTimer < 0 then
				self.acTurnStage = 21;					
				self.turnTimer   = self.acDeltaTimeoutStart;
			end;
			
--==============================================================				
-- searching...
		elseif self.acTurnStage >= 20 and self.acTurnStage <= 22 then
			moveForwards     = true;

			
		--if self.acFruitsDetected and self.acBorderDetected then
			if self.acFruitsDetected then
				AutoCombine.saveDirection( self, false );
				self.acTurnStage    = 0;
				self.acTurn2Outside = false;
				self.turnTimer      = self.acDeltaTimeoutNoTurn;
				self.aiRescueTimer  = self.acDeltaTimeoutStop;
			end;
			
--==============================================================				
-- threshing...					
		elseif self.acTurnStage == 0 then
			moveForwards     = true;
			
			if self.acBorderDetected then --and self.acFruitsDetected then
				AutoCombine.saveDirection( self, true );
				self.turnTimer   	  = math.max(self.turnTimer,self.acDeltaTimeoutRun);
				self.aiRescueTimer  = self.acDeltaTimeoutStop;
			elseif  self.acFruitsDetected 
					and not self.acTurn2Outside then
				AutoCombine.saveDirection( self, true );
			elseif self.turnTimer < 0 then
				if     self.acTurn2Outside 
						or not self.acParameters.upNDown
						or AutoCombine.getTraceLength(self) < self.acDimensions.distance + self.acDimensions.distance then		
					self.acTurnStage = 1;
					self.turnTimer = self.acDeltaTimeoutWait;
				else
					--invert turn angle because we will swap left/right in about 10 lines
					turnAngle = -turnAngle;
					if self.acParameters.noReverse then
						self.acTurn2Outside = turnAngle < self.acDimensions.uTurnAngle;
					else
						self.acTurn2Outside = math.deg(turnAngle) < -3;					
					end;
					self.acTurnStage = 11;
					self.turnTimer = self.acDeltaTimeoutWait;
					self.waitForTurnTime = self.time + self.turnTimer;
					self.acParameters.leftAreaActive  = not self.acParameters.leftAreaActive;
					self.acParameters.rightAreaActive = not self.acParameters.rightAreaActive;
					AutoCombine.sendParameters(self);
				end
			end
			
--==============================================================				
-- error!!!
		else
			allowedToDrive = false;						
			self.acHelpPanelInfoText = string.format(acGetText("AC_COMBINE_ERROR")..": %i",self.acTurnStage);
			print(self.acHelpPanelInfoText);
			self:stopAIThreshing();
			return;
		end;                
	end;			
--==============================================================				

	local acceleration = 0;					
	local slowAngleLimit = 20;
	if self.isMotorStarted and speedLevel ~= 0 and self.fuelFillLevel > 0 then
		acceleration = 1.0;
	end;
	
	if self.acTurnStage > 0 or not self.acBorderDetected then
		acceleration = 0.8*acceleration;
	end;

	local maxAngle = 25;
  local maxlx = 0.7071067;
	if self.acDimensions ~= nil and self.acDimensions.maxSteeringAngle ~= nil then
		maxAngle = math.deg( self.acDimensions.maxSteeringAngle );
	end;
	
	local lx, lz = 0, 1;
		
	if angle == nil then
		angle = 0
	elseif not self.acParameters.leftAreaActive then
		angle = -angle;
	end

	lx, lz = math.sin(angle), math.cos(angle);
	
	if      self.acTurnStage == 0 
			and self.acBorderDetected 
			and self.acFruitsDetected then
		self.aiSteeringSpeed = 0.75 * self.acSteeringSpeed;	
	elseif self.acTurnStage == 0 
			or self.acTurnStage >= 20 then
		self.aiSteeringSpeed = self.acSteeringSpeed;	
	else
		self.aiSteeringSpeed = 1.5 * self.acSteeringSpeed;	
	end
	
	AIVehicleUtil.driveInDirection(self, dt, maxAngle, acceleration, math.max(0.25,0.75*acceleration), slowAngleLimit, allowedToDrive, moveForwards, lx, lz, speedLevel, 0.6)
	
	self.aiSteeringSpeed = self.acSteeringSpeed;	
	
  local colDirX = lx
  local colDirZ = lz
  if maxlx < colDirX then
    colDirX = maxlx
    colDirZ = 0.7071067
  elseif colDirX < -maxlx then
    colDirX = -maxlx
    colDirZ = 0.7071067
  end
  --for triggerId, _ in pairs(self.numCollidingVehicles) do
	  --AIVehicleUtil.setCollisionDirection(self.aiTreshingDirectionNode, triggerId, colDirX, colDirZ)
  --end

	self.turnStage = 0
	self.turnAP    = nil
	if not self.acParameters.CPSupport then
		--nothing
	elseif self.acTurnStage ==  4 then
		self.turnStage = 1
		--self.turnAP    = true
	elseif self.acTurnStage ==  3 then
		self.turnStage = 5
		--self.turnAP    = true
	elseif self.acTurnStage >=  2 and self.acTurnStage <  11 then
		self.turnStage = 2
		--self.turnAP    = true
	elseif self.acTurnStage >= 12 and self.acTurnStage <  15 then
		self.turnStage = 1
	elseif self.acTurnStage >= 15 and self.acTurnStage <  17 then
		self.turnStage = 2
	elseif self.acTurnStage >= 17 and self.acTurnStage <  18 then
		self.turnStage = 4
	elseif self.acTurnStage >= 18 and self.acTurnStage <= 19 then
		self.turnStage = 5		
	else
		self.turnStage = 0
	end
end

------------------------------------------------------------------------
-- 
------------------------------------------------------------------------
function AutoCombine:addBackTrafficCollisionTrigger()
	if self.acBackTrafficCollisionTrigger ~= nil then
		AutoCombine.addCollisionTrigger(self,self,self.acBackTrafficCollisionTrigger,"acOnBackCollisionTrigger");
	end;
end;

------------------------------------------------------------------------
-- 
------------------------------------------------------------------------
function AutoCombine:removeBackTrafficCollisionTrigger()
	if self.acBackTrafficCollisionTrigger ~= nil then		
		AutoCombine.removeCollisionTrigger(self,self,self.acBackTrafficCollisionTrigger,"acOnBackCollisionTrigger");
	end;
end;

------------------------------------------------------------------------
-- 
------------------------------------------------------------------------
function AutoCombine:addOtherCombineCollisionTrigger()
	local on,off;
	if self.acParameters.otherCombine then	
		if self.acParameters.leftAreaActive then
			on  = self.acOtherCombineCollisionTriggerL;
			off = self.acOtherCombineCollisionTriggerR;
		else
			on  = self.acOtherCombineCollisionTriggerR;
			off = self.acOtherCombineCollisionTriggerL;
		end
		
		if on ~= nil then
			if self.numCollidingVehicles[on] == nil then
				AutoCombine.addCollisionTrigger(self,self,on);
			end
		end
		if off ~= nil then
			if self.numCollidingVehicles[off] ~= nil then
				AutoCombine.removeCollisionTrigger(self,self,off);
			end
		end
	end
end

------------------------------------------------------------------------
-- 
------------------------------------------------------------------------
function AutoCombine:removeOtherCombineCollisionTrigger()
	local off;
	off = self.acOtherCombineCollisionTriggerL;
	if off ~= nil then
		if self.numCollidingVehicles[off] ~= nil then
			AutoCombine.removeCollisionTrigger(self,self,off);
		end
	end
	off = self.acOtherCombineCollisionTriggerR;
	if off ~= nil then
		if self.numCollidingVehicles[off] ~= nil then
			AutoCombine.removeCollisionTrigger(self,self,off);
		end
	end
end;
		
------------------------------------------------------------------------
-- acOnBackCollisionTrigger
------------------------------------------------------------------------
function AutoCombine:acOnBackCollisionTrigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
  if onEnter or onLeave then
    if g_currentMission.players[otherId] ~= nil then
      if onEnter then
        self.acCollidingVehicles[triggerId] = self.acCollidingVehicles[triggerId] + 1
      elseif onLeave then
        self.acCollidingVehicles[triggerId] = math.max(self.acCollidingVehicles[triggerId] - 1, 0)
      end
    else
      local vehicle = g_currentMission.nodeToVehicle[otherId]
      if vehicle ~= nil and self.trafficCollisionIgnoreList[otherId] == nil then
        if onEnter then
          self.acCollidingVehicles[triggerId] = self.acCollidingVehicles[triggerId] + 1
        elseif onLeave then
          self.acCollidingVehicles[triggerId] = math.max(self.acCollidingVehicles[triggerId] - 1, 0)
        end
      end
    end
  end
end

		
------------------------------------------------------------------------
-- addCollisionTrigger
------------------------------------------------------------------------
function AutoCombine:addCollisionTrigger(object,transformId,cb)
  if self.isServer then
    if transformId ~= nil then
			if cb == nil then
				addTrigger(transformId, "onTrafficCollisionTrigger", self)
				self.numCollidingVehicles[transformId] = 0
			else
				addTrigger(transformId, cb, self)
				self.acCollidingVehicles[transformId] = 0
			end
    end
    if object ~= self then
      for _, v in pairs(object.components) do
        self.trafficCollisionIgnoreList[v.node] = true
      end
    end
  end
end

------------------------------------------------------------------------
-- removeCollisionTrigger
------------------------------------------------------------------------
function AutoCombine:removeCollisionTrigger(object,transformId,cb)
  if self.isServer then
    if transformId ~= nil then
      removeTrigger(transformId)
			if cb == nil then
				self.numCollidingVehicles[transformId] = nil
			else
				self.acCollidingVehicles[transformId] = nil
			end
    end
    if object ~= self then
      for _, v in pairs(object.components) do
        self.trafficCollisionIgnoreList[v.node] = nil
      end
    end
  end
end

------------------------------------------------------------------------
-- draw
------------------------------------------------------------------------
function AutoCombine:draw()
	if self.acGuiActive then
		setTextAlignment(RenderText.ALIGN_LEFT);
    setTextBold(false);		
		setTextColor(1,1,1,1);
		
		g_currentMission:addHelpButtonText(acGetText("AC_COMBINE_TEXTHELPPANELOFF"), InputBinding.AC_COMBINE_HELPPANEL);
		self.acHelpPanelOverlay:render();
		if     self.acTooltip           ~= nil and self.acTooltip           ~= "" then
			renderText(self.acHelpPanelTextPosX, self.acHelpPanelTextPosY, 0.021,self.acTooltip);
		elseif self.acHelpPanelInfoText ~= nil and self.acHelpPanelInfoText ~= "" then
			renderText(self.acHelpPanelTextPosX, self.acHelpPanelTextPosY, 0.021,self.acHelpPanelInfoText);
		else
			local workWidth = 0;
			if self.acDimensions == nil or self.acDimensions.distance == nil then
				local lm, rm = AutoCombine.getMarker(self);
				if lm ~= nil then
					workWidth,_,_ = AutoCombine.getRelativeTranslation( self.aiTreshingDirectionNode, lm );
				end;
				if rm ~= nil then
					x,_,_ = AutoCombine.getRelativeTranslation( self.aiTreshingDirectionNode, rm );
					workWidth = workWidth - x;
				end
				workWidth = workWidth - AutoCombine.getAreaOverlap(self,workWidth);	
				workWidth = workWidth + self.acParameters.widthOffset + self.acParameters.widthOffset;
			else
				workWidth = self.acDimensions.distance + self.acDimensions.distance;
			end
			renderText(self.acHelpPanelTextPosX, self.acHelpPanelTextPosY, 0.021,string.format(acGetText("AC_COMBINE_TXT_WORKWIDTH").." %0.2fm",workWidth));
		end
		AutoCombine.renderButtons(self);
	else
		g_currentMission:addHelpButtonText(acGetText("AC_COMBINE_TEXTHELPPANELON"), InputBinding.AC_COMBINE_HELPPANEL);
	end;
end;

------------------------------------------------------------------------
-- onLeave
------------------------------------------------------------------------
function AutoCombine:onLeave()
  g_mouseControlsHelp.active = true;
	InputBinding.setShowMouseCursor(false);		
end;

------------------------------------------------------------------------
-- onEnter
------------------------------------------------------------------------
function AutoCombine:onEnter()
	AutoCombine.showGui(self, self.acGuiActive);
end;

------------------------------------------------------------------------
-- acBool2int
------------------------------------------------------------------------
local function acBool2int(boolean)
	if boolean then
		return 1;
	end;
	return 0;
end;

------------------------------------------------------------------------
-- getSaveAttributesAndNodes
------------------------------------------------------------------------
function AutoCombine:getSaveAttributesAndNodes(nodeIdent)
	local attributes = "";
	if     self.acParameters.enabled
			or self.acParameters.upNDown
			or self.acParameters.waitode 
			or self.acParameters.rightAreaActive
			or self.acParameters.otherCombine then
		attributes = 'acVersion="2.0"';
		attributes = attributes..'acEnabled="'     ..acBool2int(self.acParameters.enabled).. '" ';
		attributes = attributes..'acUTurn="'       ..acBool2int(self.acParameters.upNDown).. '" ';
		attributes = attributes..'acWaitMode="'    ..acBool2int(self.acParameters.waitMode).. '" ';
		attributes = attributes..'acAreaRight="'   ..acBool2int(self.acParameters.rightAreaActive).. '" ';
		attributes = attributes..'acOtherCombine="'..acBool2int(self.acParameters.otherCombine).. '" ';
		attributes = attributes..'acNoReverse="'   ..acBool2int(self.acParameters.noReverse).. '" ';
		attributes = attributes..'acTurnOffset="'  ..self.acParameters.turnOffset..'" ';		
		attributes = attributes..'acWidthOffset="' ..self.acParameters.widthOffset..'" ';		
	end;
	
	--print(attributes);
	
	return attributes
end;

------------------------------------------------------------------------
-- acGetXmlBool
------------------------------------------------------------------------
local function acGetXmlBool(xmlFile, key, default)
	local l = getXMLInt(xmlFile, key);
	if l~= nil then
		return (l == 1);
	end;
	return default;
end;

local function acGetXmlFloat(xmlFile, key, default)
	local f = getXMLFloat(xmlFile, key);
	if f ~= nil then
		return f;
	end;
	return default;
end;
------------------------------------------------------------------------
-- loadFromAttributesAndNodes
------------------------------------------------------------------------
function AutoCombine:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local version = getXMLString(xmlFile, key.."#acVersion");
	
	self.acParameters.enabled         = acGetXmlBool(xmlFile, key.."#acEnabled",     self.acParameters.enabled);
	self.acParameters.upNDown	        = acGetXmlBool(xmlFile, key.."#acUTurn",       self.acParameters.upNDown);
	self.acParameters.waitMode        = acGetXmlBool(xmlFile, key.."#acWaitMode",    self.acParameters.waitMode);
	self.acParameters.rightAreaActive = acGetXmlBool(xmlFile, key.."#acAreaRight",   self.acParameters.rightAreaActive);
	self.acParameters.otherCombine    = acGetXmlBool(xmlFile, key.."#acOtherCombine",self.acParameters.otherCombine);
	self.acParameters.noReverse       = acGetXmlBool(xmlFile, key.."#acNoReverse",   self.acParameters.noReverse);
	self.acParameters.turnOffset      = acGetXmlFloat(xmlFile, key.."#acTurnOffset", self.acParameters.turnOffset ); 
	self.acParameters.widthOffset     = acGetXmlFloat(xmlFile, key.."#acWidthOffset",self.acParameters.widthOffset); 

	self.acParameters.leftAreaActive  = not self.acParameters.rightAreaActive;
	self.acDimensions                 = nil;
	
	return BaseMission.VEHICLE_LOAD_OK;
end

------------------------------------------------------------------------
-- getMarker
------------------------------------------------------------------------
function AutoCombine:getMarker()

  local lm = self.aiLeftMarker;
  local rm = self.aiRightMarker;
	
  for cutter, implement in pairs(self.attachedCutters) do
    if cutter.aiLeftMarker ~= nil and lm == nil then
      lm = cutter.aiLeftMarker
    end
    if cutter.aiRightMarker ~= nil and rm == nil then
      rm = cutter.aiRightMarker
    end
  end;
	
	return lm, rm;
end;

------------------------------------------------------------------------
-- getAreaOverlap
------------------------------------------------------------------------
function AutoCombine:getAreaOverlap(threshWidth)
  local areaOverlap = 0;
	local scale = Utils.getNoNil( self.aiTurnThreshWidthScale, 0.1 );
	local diff  = Utils.getNoNil( self.aiTurnThreshWidthMaxDifference, 0.6 );

	areaOverlap = 0.5 * math.min(threshWidth * (1 - scale), diff);

	return areaOverlap;
end

------------------------------------------------------------------------
-- getCorrectedMaxSteeringAngle
------------------------------------------------------------------------
function AutoCombine:getCorrectedMaxSteeringAngle()

	local steeringAngle = self.acDimensions.maxSteeringAngle;
	if      self.articulatedAxis ~= nil 
			and self.articulatedAxis.componentJoint ~= nil
      and self.articulatedAxis.componentJoint.jointNode ~= nil 
			and self.articulatedAxis.rotMax then
		-- Ropa
		steeringAngle = steeringAngle + 0.15 * self.articulatedAxis.rotMax;
	end

	return steeringAngle
end

------------------------------------------------------------------------
-- calculateDimensions
------------------------------------------------------------------------
function AutoCombine:calculateDimensions()
	if self.acDimensions ~= nil then
		if lm == nil then
			return;
		end;
		
		local _,y,_ = AutoCombine.getRelativeTranslation( self.acRefNode, lm );		
		y = y + 1E-6;
		if y >= self.acDimensions.yMin then
			return;
		end
	end;
	
	self.acRecalculateDt = 0
	self.acDimensions = {};

	local lm, rm = AutoCombine.getMarker(self);
	local n = 0;
	self.acDimensions.distance = 0;
	self.acDimensions.cutterDistance = 0;

	if lm ~= nil then
		self.acDimensions.xLeft,self.acDimensions.yMin,self.acDimensions.zLeft = AutoCombine.getRelativeTranslation( self.acRefNode, lm );		
		self.acDimensions.distance = self.acDimensions.distance + self.acDimensions.xLeft;
		self.acDimensions.cutterDistance = self.acDimensions.cutterDistance + self.acDimensions.zLeft;
		n = n + 1;
	else
		self.acDimensions.xLeft,self.acDimensions.yMin,self.acDimensions.zLeft = 0,99,0;		
	end
	if rm ~= nil then
		self.acDimensions.xRight,_,self.acDimensions.zRight = AutoCombine.getRelativeTranslation( self.acRefNode, rm );		
		self.acDimensions.distance = self.acDimensions.distance - self.acDimensions.xRight;
		self.acDimensions.cutterDistance = self.acDimensions.cutterDistance + self.acDimensions.zRight;
		n = n + 1;
	else
		self.acDimensions.xRight,self.acDimensions.zRight = 0,0;
	end
	
	if n > 1 then
		self.acDimensions.distance = self.acDimensions.distance / n;
		self.acDimensions.cutterDistance = self.acDimensions.cutterDistance / n;
	elseif n < 1 then
		self.acDimensions.distance = 1.75;
		self.acDimensions.cutterDistance = 3.3;
	end;
	self.acDimensions.cutterDistance = self.acDimensions.cutterDistance + 0.3;
	
	local threshWidth           = self.acDimensions.distance + self.acDimensions.distance;
  local areaOverlap           = AutoCombine.getAreaOverlap(self,threshWidth);	
	self.acDimensions.distance  = self.acDimensions.distance - areaOverlap;
	self.acDimensions.xLeft     = self.acDimensions.xLeft    - areaOverlap;
	self.acDimensions.xRight    = self.acDimensions.xRight   + areaOverlap;
	self.acDimensions.distance0 = self.acDimensions.distance;
	self.acDimensions.xLeft0    = self.acDimensions.xLeft;
	self.acDimensions.xRight0   = self.acDimensions.xRight;
		
	local m_ws, c_ws, z_ws, m_wn, c_wn, z_wn, m_wp, c_wp, z_wp = 0,0,0,0,0,0,0,0,0;
	self.acDimensions.maxSteeringAngle = math.rad(1);
	for _,wheel in pairs(self.wheels) do
		local x,y,z = AutoCombine.getRelativeTranslation(self.acRefNode,wheel.driveNode);
		if     wheel.rotSpeed < -1E-03 then
			if c_ws < 1 then z_ws = z else z_ws = math.min(z_ws,z) end;
			c_ws = 1;
			local m = math.min(math.abs(wheel.rotMin),math.abs(wheel.rotMax));
			if m > 0 then
				self.acDimensions.maxSteeringAngle = math.max( self.acDimensions.maxSteeringAngle, m );			
			end;
		elseif wheel.rotSpeed < 1E-03 then
			if c_wn < 1 then z_wn = z else z_wn = math.max(z_wn,z) end;
			c_wn = 1;
		else
			if c_wp < 1 then z_wp = z else z_wp = math.max(z_wp,z) end;
			c_wp = 1;
		end;
	end;

	if c_ws > 1 then z_ws = m_ws / c_ws; self.acDimensions.maxSteeringAngle = self.acDimensions.maxSteeringAngle / c_ws end;
	if c_wn > 1 then z_wn = m_wn / c_wn end;
	if c_wp > 1 then z_wp = m_wp / c_wp end;
	
	-- defaults
	self.acDimensions.zOffset         = 0;
	self.acDimensions.wheelBase       = 4;
	self.acDimensions.radius          = 10;
	self.acDimensions.aaDistance      = 0;
	self.acDimensions.aaAngle         = 0;
	self.acDimensions.aaAngleFactor   = 0;
	self.acDimensions.maxLookingAngle = 25;
	
	if      self.articulatedAxis ~= nil 
			and self.articulatedAxis.componentJoint ~= nil
      and self.articulatedAxis.componentJoint.jointNode ~= nil 
			and self.articulatedAxis.rotMax then
		-- Ropa
		local x,y,z = AutoCombine.getRelativeTranslation( self.acRefNode, self.articulatedAxis.componentJoint.jointNode );
		self.acDimensions.aaDistance    = self.acDimensions.cutterDistance - z;
    self.acDimensions.aaAngle       = self.articulatedAxis.rotMax;
		self.acDimensions.aaAngleFactor = self.acDimensions.aaAngle / self.acDimensions.maxSteeringAngle;
		self.acDimensions.zOffset       = z;
		
	elseif ( c_ws > 0 and c_wn > 0 )
			or ( c_ws > 0 and c_wp > 0 )
			or ( c_wn > 0 and c_wp > 0 ) then		
		if     c_wn < 1 then
			z_wn = 0.5 * ( z_ws + z_wp );
		elseif c_ws < 1 then
			z_ws = z_wp;
		end;
		
		self.acDimensions.zOffset       = z_wn;
	end;

	self.acDimensions.wheelBase       = self.acDimensions.zOffset - z_ws;
	self.acDimensions.cutterDistance  = self.acDimensions.cutterDistance - self.acDimensions.zOffset;
	self.acDimensions.radius          = self.acDimensions.wheelBase / math.tan( AutoCombine.getCorrectedMaxSteeringAngle(self) );

	AutoCombine.calculateDistances(self)
end

------------------------------------------------------------------------
-- calculateDistances
------------------------------------------------------------------------
function AutoCombine:calculateDistances()

	self.acDimensions.distance        = self.acDimensions.distance0 + self.acParameters.widthOffset;
	self.acDimensions.xLeft           = self.acDimensions.xLeft0    + self.acParameters.widthOffset;
	self.acDimensions.xRight          = self.acDimensions.xRight0   - self.acParameters.widthOffset;
	
	local optimDist                   = 0.5+self.acDimensions.distance;
	if self.acDimensions.radius > optimDist then
		self.acDimensions.uTurnAngle    = math.acos( optimDist / self.acDimensions.radius );
	else
		self.acDimensions.uTurnAngle    = 0;
	end;

	self.acDimensions.maxLookingAngle = math.min( AutoCombine.calculateSteeringAngle( self, 2, 1 ) ,self.acDimensions.maxSteeringAngle);
	self.acDimensions.insideDistance  = math.max(1, self.acDimensions.cutterDistance - 1 - self.acDimensions.distance +(self.acDimensions.radius * math.cos( AutoCombine.getCorrectedMaxSteeringAngle(self) )) );
	
	if self.acDimensions.aaAngle > 1E-6 then
		self.acDimensions.maxLookingAngle = math.min( self.acDimensions.maxLookingAngle, self.acDimensions.aaAngle );
		self.acDimensions.uTurnDistance   = 1.2 * self.acDimensions.cutterDistance + self.acDimensions.distance;
		self.acDimensions.uTurnDistance2  = self.acDimensions.cutterDistance + 0.7 * math.sin( self.articulatedAxis.rotMax ) * self.acDimensions.aaDistance;
	else
		self.acDimensions.uTurnDistance   = self.acDimensions.cutterDistance + math.max(2, 1 + self.acDimensions.distance - self.acDimensions.radius);
		self.acDimensions.uTurnDistance2  = math.max(1, self.acDimensions.cutterDistance + 1 + self.acDimensions.distance - self.acDimensions.radius );
	end
	
	self.acDimensions.insideDistance  = math.max( 1, self.acDimensions.insideDistance + self.acParameters.turnOffset );
  self.acDimensions.uTurnDistance   = math.max( 1, self.acDimensions.uTurnDistance  + self.acParameters.turnOffset );
  self.acDimensions.uTurnDistance2  = math.max( 1, self.acDimensions.uTurnDistance2 + self.acParameters.turnOffset );
	
	--print(string.format("a1=%i a2=%i cd=%f di=%f rd=%f wb=%f id=%f ud=%f ud2=%f",math.deg(self.acDimensions.maxSteeringAngle),math.deg(self.acDimensions.maxLookingAngle),self.acDimensions.cutterDistance,self.acDimensions.xLeft,self.acDimensions.radius,self.acDimensions.wheelBase,self.acDimensions.insideDistance,self.acDimensions.uTurnDistance,self.acDimensions.uTurnDistance2 	));
end

------------------------------------------------------------------------
-- getRelativeTranslation
------------------------------------------------------------------------
function AutoCombine.getRelativeTranslation(root,node)
	local x,y,z;
	if getParent(node)==root then
		x,y,z = getTranslation(node);
	else
		x,y,z = worldToLocal(root,getWorldTranslation(node));
	end;
	return x,y,z;
end

------------------------------------------------------------------------
-- calculateSteeringAngle
------------------------------------------------------------------------
function AutoCombine.calculateSteeringAngle(self,x,z)
	local angle = math.atan( self.acDimensions.wheelBase * x / ( self.acDimensions.cutterDistance * z + self.acDimensions.distance * x ) );
	return angle;
end;

------------------------------------------------------------------------
-- calculateWidth
------------------------------------------------------------------------
function AutoCombine:calculateWidth(z,angle)
	if math.abs(z)<1E-6 then
		return 0;
	end;
	
	local tanAngle = math.tan( angle );
	local dist = self.acDimensions.cutterDistance * z * tanAngle / ( self.acDimensions.wheelBase - tanAngle * self.acDimensions.distance );

	if self.acDimensions.aaAngleFactor > 0 then
		dist = dist + math.sin( self.acDimensions.aaAngleFactor * angle ) * z;
  end
	
	return dist;
end;

------------------------------------------------------------------------
-- getParallelogram
------------------------------------------------------------------------
function AutoCombine:getParallelogram( xOffset, zOffset, width, height, diff )
	local x, z, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ;

	if self.acParameters.leftAreaActive then
		x = self.acDimensions.xLeft;
		z = self.acDimensions.zLeft;
	else
		x = self.acDimensions.xRight;
		z = self.acDimensions.zRight;
	end
	
	startWorldX,_,startWorldZ   = localToWorld( self.acRefNode, x + xOffset,         0, z + zOffset );
	widthWorldX,_,widthWorldZ   = localToWorld( self.acRefNode, x + xOffset + width, 0, z + zOffset );
	heightWorldX,_,heightWorldZ = localToWorld( self.acRefNode, x +           diff,  0, z + zOffset + height );	
	
	return startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ;
end

------------------------------------------------------------------------
-- saveDirection
------------------------------------------------------------------------
function AutoCombine:saveDirection( cumulate )

	if cumulate then
		local vector = {};	
		vector.dx,_,vector.dz = localDirectionToWorld( self.acRefNode, 0,0,1 );
		vector.px,_,vector.pz = getWorldTranslation( self.acRefNode );
		
		if self.acDirectionBeforeTurn.traceIndex == nil then
			self.acDirectionBeforeTurn.trace = {};
			self.acDirectionBeforeTurn.traceIndex = 0;
		end;
		
		local count = table.getn(self.acDirectionBeforeTurn.trace);
		if count > 100 and self.acDirectionBeforeTurn.traceIndex == count then
			local x = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].px - self.acDirectionBeforeTurn.trace[1].px;
			local z = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].pz - self.acDirectionBeforeTurn.trace[1].pz;		
		
			if x*x + z*z > 36 then 
				self.acDirectionBeforeTurn.traceIndex = 0
			end
		end;
		self.acDirectionBeforeTurn.traceIndex = self.acDirectionBeforeTurn.traceIndex + 1;
		
		self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex] = vector;
		self.acDirectionBeforeTurn.a = nil;
		self.acDirectionBeforeTurn.x = vector.px;
		self.acDirectionBeforeTurn.z = vector.pz;
		
		if self.lastValidInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
			local hasFruitPreparer = false
			if self.fruitPreparerFruitType ~= nil and self.fruitPreparerFruitType == self.lastValidInputFruitType then
				hasFruitPreparer = true
			end
				
			local lx,lz;
			if self.acParameters.leftAreaActive then
				lx = self.acDimensions.xRight;
				lz = self.acDimensions.zRight;
			else
				lx = self.acDimensions.xLeft;
				lz = self.acDimensions.zLeft;
			end
	
			local x,_,z = localToWorld( self.acRefNode, lx, 0, lz );
			
			if Utils.getFruitArea(self.lastValidInputFruitType, x-1,z-1,x+1,z-1,x-1,z+1, hasFruitPreparer) > 0 then	
				self.acDirectionBeforeTurn.tx = x;
				self.acDirectionBeforeTurn.tz = z;
			end
		end
	else
		self.acDirectionBeforeTurn.trace = {};
		self.acDirectionBeforeTurn.traceIndex = 0;
		self.acDirectionBeforeTurn.sx, _, self.acDirectionBeforeTurn.sz = getWorldTranslation( self.acRefNode );
	end
end

------------------------------------------------------------------------
-- getFirstTraceIndex
------------------------------------------------------------------------
function AutoCombine:getFirstTraceIndex()
	if     self.acDirectionBeforeTurn.trace      == nil 
			or self.acDirectionBeforeTurn.traceIndex == nil 
			or self.acDirectionBeforeTurn.traceIndex < 1 then
		return nil;
	end;
	local l = table.getn(self.acDirectionBeforeTurn.trace);
	if l < 1 then
		return nil;
	end;
	local i = self.acDirectionBeforeTurn.traceIndex + 1;
	if i > l then i = 1 end
	return i;
end

------------------------------------------------------------------------
-- getTurnDistance
------------------------------------------------------------------------
function AutoCombine:getTurnDistance()
	if     self.acRefNode               == nil
			or self.acDirectionBeforeTurn   == nil
			or self.acDirectionBeforeTurn.x == nil
			or self.acDirectionBeforeTurn.z == nil then
		return 0
	end;
	local x,_,z = getWorldTranslation( self.acRefNode );
	x = x - self.acDirectionBeforeTurn.x;
	z = z - self.acDirectionBeforeTurn.z;
	return math.sqrt( x*x + z*z )
end

------------------------------------------------------------------------
-- getTraceLength
------------------------------------------------------------------------
function AutoCombine.getTraceLength( self )
	if self.acDirectionBeforeTurn.trace == nil then
		return 0;
	end;
	
	if table.getn(self.acDirectionBeforeTurn.trace) < 2 then
		return 0;
	end;
	
	local i = AutoCombine.getFirstTraceIndex( self );
	if i == nil then
		return 0;
	end
	
	local x = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].px - self.acDirectionBeforeTurn.sx;
	local z = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].pz - self.acDirectionBeforeTurn.sz;
	
	return math.sqrt( x*x + z*z );
end;

------------------------------------------------------------------------
-- getTurnAngle
------------------------------------------------------------------------
function AutoCombine.getTurnAngle( self )			
	if self.acDirectionBeforeTurn.a == nil then
		local i = AutoCombine.getFirstTraceIndex( self );
		if i == nil then
			return 0
		end
		if i == self.acDirectionBeforeTurn.traceIndex then
			return 0
		end
		local l = AutoCombine.getTraceLength( self );
		if l < 1E-3 then
			return 0
		end

		local vx = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].px - self.acDirectionBeforeTurn.trace[i].px;
		local vz = self.acDirectionBeforeTurn.trace[self.acDirectionBeforeTurn.traceIndex].pz - self.acDirectionBeforeTurn.trace[i].pz;		
		self.acDirectionBeforeTurn.a = Utils.getYRotationFromDirection(vx/l,vz/l);
	end;

	local x,y,z = localDirectionToWorld( self.acRefNode, 0,0,1 );
	
	local angle = Utils.getYRotationFromDirection(x,z) - self.acDirectionBeforeTurn.a;
	while angle < math.pi do 
		angle = angle+math.pi+math.pi; 
	end;
	while angle > math.pi do
		angle = angle-math.pi-math.pi; 
  end;
	
	return angle;
end;	

------------------------------------------------------------------------
-- Manually switch to next turn stage
------------------------------------------------------------------------
function AutoCombine:setNextTurnStage(noEventSend)

	if self.acParameters.enabled then
		if     self.acTurnStage == 2  then
			self.turnTimer     = self.acDeltaTimeoutWait;
			self.lastTurnAngle = nil;
			self.acTurnStage   = 3;
			self.setAIImplementsMoveDown(self,true);
		elseif self.acTurnStage == 12 then
			self.turnTimer     = self.acDeltaTimeoutWait;
			self.lastTurnAngle = nil;
			if self.acTurn2Outside then
				self.acTurn2Outside = false;
				self.acTurnStage   = 13;
			else
				self.acTurnStage   = 14;
			end
		elseif self.acTurnStage == 15 then
			self.turnTimer     = self.acDeltaTimeoutWait;
			self.lastTurnAngle = nil;
			self.acTurnStage   = 17;
		elseif self.acTurnStage == 17 then
			self.turnTimer     = self.acDeltaTimeoutWait;
			self.lastTurnAngle = nil;
			if self.acParameters.noReverse then
				self.acTurnStage   = 19;
				self.setAIImplementsMoveDown(self,true);
			else
				self.acTurn2Outside = true;
				self.turnTimer     = self.acDeltaTimeoutStop;
				self.acTurnStage   = 18;
			end
		elseif self.acTurnStage == 18 then
			self.turnTimer     = self.acDeltaTimeoutWait;
			self.lastTurnAngle = nil;
			self.acTurnStage   = 19;
			self.setAIImplementsMoveDown(self,true);
		end
	else
		if self.turnStage > 0 and self.turnStage < 4 then
			self.turnStage = self.turnStage + 1;
		end
	end

  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(AutoCombineNextTSEvent:new(self), nil, nil, self)
    else
      g_client:getServerConnection():sendEvent(AutoCombineNextTSEvent:new(self))
    end
  end
end;

------------------------------------------------------------------------
-- Event stuff
------------------------------------------------------------------------
function AutoCombine:getParameters()
	if self.acParameters == nil then
		self.acParameters = {}
		self.acParameters.upNDown = false;
		self.acParameters.otherCombine = false;
		self.acParameters.waitMode = false;
		self.acParameters.leftAreaActive = true;
		self.acParameters.rightAreaActive = false;
		self.acParameters.enabled = false;
		self.acParameters.noReverse = false;
		self.acParameters.CPSupport = false;
		self.acParameters.turnOffset = 0;
		self.acParameters.widthOffset = 0;
	end;

	return self.acParameters;
end;

local function acReadStream(streamId)
	local parameters = {};
	
	parameters.enabled         = streamReadBool(streamId);
	parameters.upNDown	       = streamReadBool(streamId);
	parameters.waitMode        = streamReadBool(streamId);
	parameters.rightAreaActive = streamReadBool(streamId);
	parameters.otherCombine    = streamReadBool(streamId);
	parameters.noReverse       = streamReadBool(streamId);
	parameters.CPSupport       = streamReadBool(streamId);
	parameters.turnOffset      = streamReadFloat32(streamId);
	parameters.widthOffset     = streamReadFloat32(streamId);

	return parameters;
end

local function acWriteStream(streamId, parameters)
	streamWriteBool(streamId, Utils.getNoNil( parameters.enabled        ,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.upNDown	      ,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.waitMode       ,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.rightAreaActive,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.otherCombine   ,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.noReverse      ,false ));
	streamWriteBool(streamId, Utils.getNoNil( parameters.CPSupport      ,false ));
	streamWriteFloat32(streamId, Utils.getNoNil( parameters.turnOffset  ,0 ));
	streamWriteFloat32(streamId, Utils.getNoNil( parameters.widthOffset ,0 ));
end

function AutoCombine:setParameters(parameters)
	local turnOffset = 0;
	if self.acParameters ~= nil and self.acParameters.turnOffset ~= nil then
		turnOffset = self.acParameters.turnOffset
	end
	local widthOffset = 0;
	if self.acParameters ~= nil and self.acParameters.widthOffset ~= nil then
		widthOffset = self.acParameters.widthOffset
	end
	
	self.acParameters = {}
	self.acParameters.enabled         = Utils.getNoNil(parameters.enabled        ,false);
	self.acParameters.upNDown         = Utils.getNoNil(parameters.upNDown        ,false);
	self.acParameters.waitMode        = Utils.getNoNil(parameters.waitMode       ,false);
	self.acParameters.rightAreaActive = Utils.getNoNil(parameters.rightAreaActive,false);
	self.acParameters.otherCombine    = Utils.getNoNil(parameters.otherCombine   ,false);
	self.acParameters.noReverse       = Utils.getNoNil(parameters.noReverse      ,false);
	self.acParameters.CPSupport       = Utils.getNoNil(parameters.CPSupport      ,false);
	self.acParameters.turnOffset      = Utils.getNoNil(parameters.turnOffset     ,0);
	self.acParameters.widthOffset     = Utils.getNoNil(parameters.widthOffset    ,0);
	self.acParameters.leftAreaActive  = not self.acParameters.rightAreaActive;
		
	if self.acDimensions ~= nil then
		if     math.abs( self.acParameters.turnOffset  - turnOffset  ) > 1E-6
				or math.abs( self.acParameters.widthOffset - widthOffset ) > 1E-6 then
			AutoCombine.calculateDistances( self )
		end
	end
end

function AutoCombine:readStream(streamId, connection)
  AutoCombine.setParameters( self, acReadStream(streamId) );
end

function AutoCombine:writeStream(streamId, connection)
  acWriteStream(streamId,AutoCombine.getParameters(self));
end

function AutoCombine:sendParameters(noEventSend)
	if self.acDimensions ~= nil then
		AutoCombine.calculateDistances( self )
	end

  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(AutoCombineParametersEvent:new(self, AutoCombine.getParameters(self)), nil, nil, self)
    else
      g_client:getServerConnection():sendEvent(AutoCombineParametersEvent:new(self, AutoCombine.getParameters(self)))
    end
  end
end;

AutoCombineParametersEvent = {}
AutoCombineParametersEvent_mt = Class(AutoCombineParametersEvent, Event)
InitEventClass(AutoCombineParametersEvent, "AutoCombineParametersEvent")
function AutoCombineParametersEvent:emptyNew()
  local self = Event:new(AutoCombineParametersEvent_mt)
  return self
end
function AutoCombineParametersEvent:new(object, parameters)
  local self = AutoCombineParametersEvent:emptyNew()
  self.object     = object;
  self.parameters = parameters;
  return self
end
function AutoCombineParametersEvent:readStream(streamId, connection)
  local id = streamReadInt32(streamId)
  self.object = networkGetObject(id)
	self.parameters = acReadStream(streamId);
  self:run(connection)
end
function AutoCombineParametersEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, networkGetObjectId(self.object))
	acWriteStream(streamId, self.parameters);
end
function AutoCombineParametersEvent:run(connection)
  AutoCombine.setParameters(self.object,self.parameters);
  if not connection:getIsServer() then
    g_server:broadcastEvent(AutoCombineParametersEvent:new(self.object, self.parameters), nil, connection, self.object)
  end
end


AutoCombineNextTSEvent = {}
AutoCombineNextTSEvent_mt = Class(AutoCombineNextTSEvent, Event)
InitEventClass(AutoCombineNextTSEvent, "AutoCombineNextTSEvent")
function AutoCombineNextTSEvent:emptyNew()
  local self = Event:new(AutoCombineNextTSEvent_mt)
  return self
end
function AutoCombineNextTSEvent:new(object)
  local self = AutoCombineNextTSEvent:emptyNew()
  self.object     = object;
  return self
end
function AutoCombineNextTSEvent:readStream(streamId, connection)
  local id = streamReadInt32(streamId)
  self.object = networkGetObject(id)
  self:run(connection)
end
function AutoCombineNextTSEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, networkGetObjectId(self.object))
end
function AutoCombineNextTSEvent:run(connection)
  AutoCombine.setNextTurnStage(self.object,true);
  if not connection:getIsServer() then
    g_server:broadcastEvent(AutoCombineNextTSEvent:new(self.object), nil, connection, self.object)
  end
end

AutoCombineTurnStageEvent = {}
AutoCombineTurnStageEvent_mt = Class(AutoCombineTurnStageEvent, Event)
InitEventClass(AutoCombineTurnStageEvent, "AutoCombineTurnStageEvent")
function AutoCombineTurnStageEvent:emptyNew()
  local self = Event:new(AutoCombineTurnStageEvent_mt)
  return self
end
function AutoCombineTurnStageEvent:new(object,turnStage)
  local self = AutoCombineTurnStageEvent:emptyNew()
  self.object     = object;
	self.turnStage  = turnStage;
  return self
end
function AutoCombineTurnStageEvent:readStream(streamId, connection)
  local id = streamReadInt32(streamId)
  self.object    = networkGetObject(id)
	self.turnStage = streamReadInt32(streamId)
  self:run(connection)
end
function AutoCombineTurnStageEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, networkGetObjectId(self.object))
  streamWriteInt32(streamId, self.turnStage)
end
function AutoCombineTurnStageEvent:run(connection)
  self.object.acTurnStage     = self.turnStage;
  self.object.acTurnStageSent = self.turnStage;
  if not connection:getIsServer() then
    g_server:broadcastEvent(AutoCombineTurnStageEvent:new(self.object,self.turnStage), nil, connection, self.object)
  end
end

