--
-- BuyableCareWheelsAttacher
-- Specialization for Buyable Care Wheels
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		30/10/12
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--

BuyableCareWheelsAttacher = {};

function BuyableCareWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableCareWheelsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.buyableCareWheels = {};
	self.buyableCareWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#careWheelsCheckString"), "standart");
	self.buyableCareWheels.careWheels = nil;
	self.buyableCareWheels.wheelsInRange = nil;	
end;

function BuyableCareWheelsAttacher:delete()
	if self.buyableCareWheels.careWheels ~= nil then
		self.buyableCareWheels.careWheels:disassembleWheels(true);
	end;
end;

function BuyableCareWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableCareWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableCareWheelsAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.buyableCareWheels;
		if wheels.wheelsInRange ~= nil then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.care4095kompaktIB) then
					if wheels.careWheels == nil then
						wheels.wheelsInRange:assembleWheels(self);
					else
						if wheels.wheelsInRange.careWheelUser == self then
							wheels.wheelsInRange:disassembleWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableCareWheelsAttacher:draw()
	local wheels = self.buyableCareWheels;
	if wheels.wheelsInRange ~= nil then
		if wheels.careWheels ~= nil then
			if wheels.wheelsInRange.careWheelUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("care4095kompaktD"), InputBinding.care4095kompaktIB);
			end;
		else
			if wheels.wheelsInRange.careWheelUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("care4095kompaktA"), InputBinding.care4095kompaktIB);
			end;
		end;
	end;
end;

function BuyableCareWheelsAttacher:onAssembling(buyableCareWheels)
	self.buyableCareWheels.careWheels = buyableCareWheels;
	if self.setFenderVisibility ~= nil then
		self:setFenderVisibility(false);
	end;
end;

function BuyableCareWheelsAttacher:onDisassembling()
	self.buyableCareWheels.careWheels = nil;
	if self.setFenderVisibility ~= nil then
		self:setFenderVisibility(true);
	end;
end;