--
-- MouseControlsVehicle
-- This is the specialization for vehicles which can be controlled by the mouse
--
-- @author  Stefan Geiger
-- @date  18/08/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
--
-- @edit Stefan Maurus, 24/08/13

MouseControlsVehicleEdit = {};

function MouseControlsVehicleEdit.prerequisitesPresent(specializations)
    return true;
end

function MouseControlsVehicleEdit:load(xmlFile)

    self.mouseControlsIcons = {};
    local i=0;
    while true do
       local key = string.format("vehicle.mouseControls.mouseControl(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end
 
        local iconFilename = getXMLString(xmlFile, key.."#iconFilename");
        local axis = getXMLString(xmlFile, key.."#axis");
        if iconFilename ~= nil and axis ~= nil then
            if self.mouseControlsIcons[axis] == nil then
                local entry = {};
                iconFilename = Utils.getFilename(iconFilename, self.baseDirectory);
                g_mouseControlsHelp:addIconFilename(iconFilename);
                entry.iconFilename= iconFilename;
                entry.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, key.."#foldMinLimit"), 0);
                entry.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, key.."#foldMaxLimit"), 1);
                self.mouseControlsIcons[axis] = entry;
            else
                print("Warning: duplicate mouse control axis "..axis.." in "..self.configFileName);
            end
        end
        i = i+1;
    end
end

function MouseControlsVehicleEdit:delete()
end

function MouseControlsVehicleEdit:mouseEvent(posX, posY, isDown, isUp, button)
end

function MouseControlsVehicleEdit:keyEvent(unicode, sym, modifier, isDown)
end

function MouseControlsVehicleEdit:update(dt)
    if self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
        local foldAnimTime = self.foldAnimTime;
        local xFilename = "";
        local yFilename = "";
        for axis,entry in pairs(self.mouseControlsIcons) do
			local actionIndex = InputBinding[axis];
			if actionIndex ~= nil and (foldAnimTime == nil or (foldAnimTime <= entry.foldMaxLimit and foldAnimTime >= entry.foldMinLimit)) then
                if InputBinding.getIsInputMouseAxisTriggered(actionIndex) then
                    if InputBinding.actions[actionIndex].mouseAxis == InputBinding.MOUSE_AXIS_X then
                        xFilename = entry.iconFilename;
                    elseif InputBinding.actions[actionIndex].mouseAxis == InputBinding.MOUSE_AXIS_Y then
                        yFilename = entry.iconFilename;
                    end
                end
            end
        end
        g_mouseControlsHelp:setIconFilename(xFilename, yFilename);
    end
end

function MouseControlsVehicleEdit:draw()
	g_currentMission:addExtraPrintText(g_i18n:getText("ALOE_FRONTLOADER_HELP"));
end

function MouseControlsVehicleEdit:onLeave()
end

function MouseControlsVehicleEdit.convertMouseAxisString(mouseAxis)
    if mouseAxis ~= nil then
		mouseAxis = mouseAxis:lower();
		if mouseAxis == "x" then
			return InputBinding.MOUSE_AXIS_X;
		elseif mouseAxis == "y" then
			return InputBinding.MOUSE_AXIS_Y;
		end
    end
	return InputBinding.MOUSE_AXIS_NONE;
end