--
-- MPOwner
--
-- @author  ANDR55
-- Version 0.1
-- @date 31.05.2014

MPOwner_2 = {}

tab = ""
msg = ""

function MPOwner_2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function MPOwner_2:keyEvent(unicode, sym, modifier, isDown)
end;

function MPOwner_2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MPOwner_2:update(dt)
end;

function MPOwner_2:resolveKey()

	if InputBinding.hasEvent(InputBinding.SWITCH_VEHICLE_BACK) then
		tab = "backtab";
	elseif InputBinding.hasEvent(InputBinding.SWITCH_VEHICLE) then
		tab = "tab";
	elseif InputBinding.hasEvent(InputBinding.ENTER) then
		tab = "e";
	else
		tab = "";
	end;
end;

function MPOwner_2:draw()

	if msg ~= "" and self.msg_zaehler <= 50 then
		self.msg_zaehler = self.msg_zaehler + 1;
		g_currentMission:addWarning(msg);
		if self.msg_zaehler >= 50 then
			msg = "";
			self.msg_zaehler = 0;
		end;
	end;
end;

function MPOwner_2:delete()
end;

function MPOwner_2:new(object, controllerName)

	local lfd_nummer;
	local ok = false;
	
	MPOwner_2:resolveKey();
	
	local i = 0;
	
	for vehicle = 1, table.getn(g_currentMission.steerables) do
		local veh = g_currentMission.steerables[vehicle];
		if networkGetObjectId(veh) == networkGetObjectId(object) then
			lfd_nummer = vehicle;
		end;
	end;

	i = lfd_nummer;
	
	local first = true;
	
	if tab == "e" then
		local veh = g_currentMission.steerables[i];
		if veh.MPOwner.owner == controllerName or veh.MPOwner.owner == "" then
			ok = true;
		else
			msg = "Dieses Fahrzeug geh\195\182rt "..veh.MPOwner.owner.."!";
		end;
	elseif tab == "tab" or tab == "backtab" then	
		while ok == false do

			if tab == "tab" then
				if i > table.getn(g_currentMission.steerables) then
					i = 1;
				end;
			elseif tab == "backtab" then
				if i < 1 then
					i = table.getn(g_currentMission.steerables);
				end;		
			end;
			
			if i == lfd_nummer and first == false then
				break;
			end;
			
			local veh = g_currentMission.steerables[i];
			if (veh.MPOwner.owner == controllerName or veh.MPOwner.owner == "") and veh.configFileName ~= "data/vehicles/steerable/lizard/golfCart.xml" then
				if not veh.isControlled then
					ok = true;
					break;
				end
			end;
			
			if tab == "tab" then
				i = i + 1;
			else
				i = i - 1;
			end;
			
			if first == true then
				first = false;
			end;
		end;
	else
		local veh = g_currentMission.steerables[i];
		if veh.MPOwner.owner == controllerName or veh.MPOwner.owner == "" then
			ok = true;
		end;
	end;
	
	if ok == true then
		local self = VehicleEnterRequestEvent:emptyNew();
		self.object = g_currentMission.steerables[i];
		self.objectId = networkGetObjectId(self.object);
		self.controllerName = controllerName;
		return self;
	else
		local self = VehicleEnterRequestEvent:emptyNew();
		return self;		
	end;
end;


function MPOwner_2:run(connection)
	if self.object ~= nil and connection ~= nil then
		if self.object.isControlled == false then
		   self.object:setOwner(connection);
		   g_server:broadcastEvent(VehicleEnterResponseEvent:new(self.objectId, false, self.controllerName), true, connection, self.object);
		   connection:sendEvent(VehicleEnterResponseEvent:new(self.objectId, true));

		   -- do not call onEnter twice on the server
			if not self.object.isEntered then
				self.object:onEnter(false);
			end;
		end;
	end;
end;

function MPOwner_2:loadMap(name)
	
	self.msg_zaehler = 0
	
	VehicleEnterRequestEvent.new = MPOwner_2.new
	VehicleEnterRequestEvent.run = MPOwner_2.run
end;

function MPOwner_2:deleteMap()
end;

addModEventListener(MPOwner_2);
