
MPOwnerEvent = {};
MPOwnerEvent_mt = Class(MPOwnerEvent, Event);
InitEventClass(MPOwnerEvent, "MPOwnerEvent");

function MPOwnerEvent:emptyNew()
	local self = Event:new(MPOwnerEvent_mt);
	return self;
end;

function MPOwnerEvent:new(vehicle, owner)

	local self = MPOwnerEvent:emptyNew();
	self.vehicle = vehicle;
	self.owner = owner;
  
	return self;
end;

function MPOwnerEvent:readStream(streamId, connection)

	local id = streamReadInt32(streamId)
	self.vehicle = networkGetObject(id);
	self.owner = streamReadString(streamId);
 
	self:run(connection);
end;

function MPOwnerEvent:writeStream(streamId, connection)

	local id = networkGetObjectId(self.vehicle)
	streamWriteInt32(streamId, id);
	streamWriteString(streamId, self.owner);
end;

function MPOwnerEvent:run(connection)
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, true);
	else
		if self.vehicle ~= nil then

			if self.vehicle.MPOwner == nil then
				self.vehicle.MPOwner = {};
				self.vehicle.MPOwner.owner = "";
			end;
			
			if self.vehicle.MPOwner.owner == nil then
				self.vehicle.MPOwner.owner = "";
			end;

			self.vehicle.MPOwner.owner = self.owner;
		end;
	end;
end;