
MPOwnerRefreshEvent = {};
MPOwnerRefreshEvent_mt = Class(MPOwnerRefreshEvent, Event);
InitEventClass(MPOwnerRefreshEvent, "MPOwnerRefreshEvent");

function MPOwnerRefreshEvent:emptyNew()
	local self = Event:new(MPOwnerRefreshEvent_mt);
	return self;
end;

function MPOwnerRefreshEvent:new(vehicle)

	local self = MPOwnerRefreshEvent:emptyNew();
	self.vehicle = vehicle;
  
	return self;
end;

function MPOwnerRefreshEvent:readStream(streamId, connection)

	local id = streamReadInt32(streamId)
	self.vehicle = networkGetObject(id);
 
	self:run(connection);
end;

function MPOwnerRefreshEvent:writeStream(streamId, connection)

	local id = networkGetObjectId(self.vehicle)
	streamWriteInt32(streamId, id);
	streamWriteString(streamId, self.owner);
end;

function MPOwnerRefreshEvent:run(connection)

	if not connection:getIsServer() then
		g_client:getServerConnection():sendEvent(MPOwnerEvent:new(self.vehicle, self.vehicle.MPOwner.owner))
	end;
end;