RentFieldRefreshEvent = {};
RentFieldRefreshEvent_mt = Class(RentFieldRefreshEvent, Event);
InitEventClass(RentFieldRefreshEvent, "RentFieldRefreshEvent");

function RentFieldRefreshEvent:emptyNew()
  local self = Event:new(RentFieldRefreshEvent_mt);
  return self;
end;

function RentFieldRefreshEvent:new(fieldNumber)

  local self = RentFieldRefreshEvent:emptyNew();
  self.fieldNumber = fieldNumber;
  
  return self;
end;

function RentFieldRefreshEvent:readStream(streamId, connection)

  self.fieldNumber = streamReadInt32(streamId);
 
  self:run(connection);
end;

function RentFieldRefreshEvent:writeStream(streamId, connection)

  streamWriteInt32(streamId, self.fieldNumber);
end;

function RentFieldRefreshEvent:run(connection)

	if not connection:getIsServer() then
		g_client:getServerConnection():sendEvent(RentFieldEvent:new(self.fieldNumber, g_currentMission.fieldDefinitionBase.fieldDefsByFieldNumber[self.fieldNumber].ownedByPlayer, g_currentMission.fieldDefinitionBase.fieldDefsByFieldNumber[self.fieldNumber].rentByPlayer))
	end;
end;