FieldEvent = {};
FieldEvent_mt = Class(FieldEvent, Event);
InitEventClass(FieldEvent, "FieldEvent");

function FieldEvent:emptyNew()
  local self = Event:new(FieldEvent_mt);
  return self;
end;

function FieldEvent:new(fieldnumber, ownedbyPlayer)

  local self = FieldEvent:emptyNew();
  self.fieldnumber = fieldnumber;
  self.ownedbyPlayer = ownedbyPlayer;
  
  return self;
end;

function FieldEvent:readStream(streamId, connection)

  self.fieldnumber = streamReadInt32(streamId);
  self.ownedbyPlayer = streamReadBool(streamId);
 
  self:run(connection);
end;

function FieldEvent:writeStream(streamId, connection)

  streamWriteInt32(streamId, self.fieldnumber);
  streamWriteBool(streamId, self.ownedbyPlayer);
end;

function FieldEvent:run(connection)
	
	local fieldDef = g_currentMission.fieldDefinitionBase.fieldDefsByFieldNumber[self.fieldnumber];
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, true);
	else
		g_currentMission.fieldDefinitionBase:setFieldOwnedByPlayer(fieldDef, self.ownedbyPlayer);
	end;

end;