--
-- RentaFieldInShop
--
-- @author  ANDR55
-- Version 0.1
-- @date 31.05.2014

local directory = g_currentModDirectory;
RentaFieldInShop = {};

function RentaFieldInShop:loadMap(name)
	
	local i
	for key,value in pairs(g_currentMission.fieldDefinitionBase.fieldDefsByFieldNumber) do
		i = table.getn(g_gui.guis.ShopScreen.target.storeItems) + 1
		
		g_gui.guis.ShopScreen.target.storeItems[i] = {}
		g_gui.guis.ShopScreen.target.storeItems[i].hook_type = "RentaField"
		g_gui.guis.ShopScreen.target.storeItems[i].xmlFilename = "Field "..value.fieldNumber
		g_gui.guis.ShopScreen.target.storeItems[i].imageBrand = directory.."brand_field.png"
		g_gui.guis.ShopScreen.target.storeItems[i].description = g_i18n:getText("RAFIS_Beschreibung")
		g_gui.guis.ShopScreen.target.storeItems[i].dailyUpkeep = 0
		g_gui.guis.ShopScreen.target.storeItems[i].price = 0
		g_gui.guis.ShopScreen.target.storeItems[i].achievementsNeeded = 0
		g_gui.guis.ShopScreen.target.storeItems[i].brand = g_i18n:getText("RAFIS_Brand")
		g_gui.guis.ShopScreen.target.storeItems[i].machineType = "misc"
		g_gui.guis.ShopScreen.target.storeItems[i].imageActive = directory.."store_field.png"
		g_gui.guis.ShopScreen.target.storeItems[i].isMod = false
		g_gui.guis.ShopScreen.target.storeItems[i].name = g_i18n:getText("RAFIS_Name").." "..value.fieldNumber.." "..g_i18n:getText("RAFIS_Rent")
		g_gui.guis.ShopScreen.target.storeItems[i].rotation = value.fieldNumber
		g_gui.guis.ShopScreen.target.storeItems[i].incomePerHour = {}
		g_gui.guis.ShopScreen.target.storeItems[i].incomePerHour[1] = 0
		g_gui.guis.ShopScreen.target.storeItems[i].incomePerHour[2] = 0
		g_gui.guis.ShopScreen.target.storeItems[i].incomePerHour[3] = 0
		g_gui.guis.ShopScreen.target.storeItems[i].species = ""
		g_gui.guis.ShopScreen.target.storeItems[i].specs = g_i18n:getText("RAFIS_Flaeche")..": "..tostring(math.floor(value.fieldArea*100)/100).." "..g_i18n:getText("RAFIS_ha").."\n"..g_i18n:getText("RAFIS_Costs")..": "..g_i18n:formatMoney(value.fieldPrice / 25)
		g_gui.guis.ShopScreen.target.storeItems[i].id = i
	end;
end;


function RentaFieldInShop:onSelectionChanged(target1)

	if g_gui.guis.ShopScreen.target.buyButton.target.selectedStoreItem ~= nil then
		if g_gui.guis.ShopScreen.target.buyButton.target.selectedStoreItem.hook_type == "RentaField" then
			local fieldDef = g_currentMission.fieldDefinitionBase.fieldDefsByFieldNumber[g_gui.guis.ShopScreen.target.buyButton.target.selectedStoreItem.rotation]
			g_gui.guis.ShopScreen.target.buyButton.disabled  =     fieldDef.ownedByPlayer
			g_gui.guis.ShopScreen.target.sellButton.disabled = not(fieldDef.ownedByPlayer and fieldDef.rentByPlayer)
			g_gui.guis.ShopScreen.target.buyButton.text  = g_i18n:getText("RAFIS_Shop_Rent")
			g_gui.guis.ShopScreen.target.sellButton.text = g_i18n:getText("RAFIS_Shop_Cancel")
		else
			g_gui.guis.ShopScreen.target.buyButton.text  = g_i18n:getText("RAFIS_Shop_Buy")
			g_gui.guis.ShopScreen.target.sellButton.text = g_i18n:getText("RAFIS_Shop_Sell")
		end;
	end;
end;
g_gui.guis.ShopScreen.target.shopItemList.onSelectionChanged = Utils.appendedFunction(g_gui.guis.ShopScreen.target.shopItemList.onSelectionChanged, RentaFieldInShop.onSelectionChanged);
g_gui.guis.ShopScreen.target.categorySelectionElement.onClick = Utils.appendedFunction(g_gui.guis.ShopScreen.target.categorySelectionElement.onClick, RentaFieldInShop.onSelectionChanged);
--g_gui.guis.ShopScreen.onOpenCallback = Utils.appendedFunction(g_gui.guis.ShopScreen.onOpenCallback, RentaFieldInShop.onSelectionChanged);


function RentaFieldInShop:update(dt)

	if not self.initialize then
		--Broadcast auslsen
		for key,value in pairs(g_currentMission.fieldDefinitionBase.fieldDefsByFieldNumber) do
			g_client:getServerConnection():sendEvent(RentFieldRefreshEvent:new(value.fieldNumber));
		end;
		self.initialize = true;
	end;

	if (g_gui.currentGuiName ~= "" and g_gui.currentGuiName ~= nil) then
		if g_gui.currentGuiName == "ShopScreen" then
			RentaFieldInShop:onSelectionChanged()
		end;
	end;
	
	if not self.hookPDA then
	
		g_currentMission.environment:addHourChangeListener(self);
	
		self.hookPDA = true
		
		local oldbuyButtononClick  = g_gui.guis.ShopScreen.target.buyButton.onClick;
		local oldsellButtononClick = g_gui.guis.ShopScreen.target.sellButton.onClick;

		g_gui.guis.ShopScreen.target.buyButton.onClick = function(buyButton, buyButton_target)
			if buyButton_target.target.selectedStoreItem.hook_type ~= "RentaField" then
				oldbuyButtononClick(buyButton, buyButton_target)
			else
				if g_currentMission.fieldDefinitionBase.fieldDefsByFieldNumber[buyButton_target.target.selectedStoreItem.rotation].ownedByPlayer == false then
					
					g_client:getServerConnection():sendEvent(RentFieldEvent:new(buyButton_target.target.selectedStoreItem.rotation, true, true));

					RentaFieldInShop:onSelectionChanged()
				end
			end
		end
		
		g_gui.guis.ShopScreen.target.sellButton.onClick = function(sellButton, sellButton_target)
			if sellButton_target.target.selectedStoreItem.hook_type ~= "RentaField" then
				oldsellButtononClick(sellButton, sellButton_target)
			else
				if g_currentMission.fieldDefinitionBase.fieldDefsByFieldNumber[sellButton_target.target.selectedStoreItem.rotation].ownedByPlayer == true then

					g_client:getServerConnection():sendEvent(RentFieldEvent:new(sellButton_target.target.selectedStoreItem.rotation, false, false));
					
					RentaFieldInShop:onSelectionChanged()
				end;
			end;
		end;
	end;
end;

function RentaFieldInShop:hourChanged()
	
	if g_server ~= nil then
		for key,value in pairs(g_currentMission.fieldDefinitionBase.fieldDefsByFieldNumber) do
			if value.rentByPlayer then
				g_currentMission:addSharedMoney(-value.fieldPrice/25/24, "other")
			end;
		end;
	end;
end;

function RentaFieldInShop:deleteMap()
end;

function RentaFieldInShop:delete()
end;

function RentaFieldInShop:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RentaFieldInShop:keyEvent(unicode, sym, modifier, isDown)
end;

function RentaFieldInShop:draw()
end;

addModEventListener(RentaFieldInShop);