RentFieldEvent = {};
RentFieldEvent_mt = Class(RentFieldEvent, Event);
InitEventClass(RentFieldEvent, "RentFieldEvent");

function RentFieldEvent:emptyNew()
  local self = Event:new(RentFieldEvent_mt);
  return self;
end;

function RentFieldEvent:new(fieldNumber, ownedByPlayer, rentByPlayer)

  local self = RentFieldEvent:emptyNew();
  self.fieldNumber = fieldNumber;
  self.ownedByPlayer = ownedByPlayer;
  self.rentByPlayer = rentByPlayer;
  
  return self;
end;

function RentFieldEvent:readStream(streamId, connection)

  self.fieldNumber = streamReadInt32(streamId);
  self.ownedByPlayer = streamReadBool(streamId);
  self.rentByPlayer = streamReadBool(streamId);
 
  self:run(connection);
end;

function RentFieldEvent:writeStream(streamId, connection)

  streamWriteInt32(streamId, self.fieldNumber);
  streamWriteBool(streamId, self.ownedByPlayer);
  streamWriteBool(streamId, self.rentByPlayer);
end;

function RentFieldEvent:run(connection)
	
	local fieldDef = g_currentMission.fieldDefinitionBase.fieldDefsByFieldNumber[self.fieldNumber];
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, true);
	else
		g_currentMission.fieldDefinitionBase:setFieldOwnedByPlayer(fieldDef, self.ownedByPlayer);
		fieldDef.rentByPlayer = self.rentByPlayer;
	end;

end;