-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- ZugmaulVisibility
-- Sorgt dafr dass das Zugmaul ausgeblendet und der Oberlenker eingeblendet wird sobald man ein Gert attacht.

ZugmaulVisibility = {};

function ZugmaulVisibility.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ZugmaulVisibility:load(xmlFile)
	self.setZvState = ZugmaulVisibility.setZvState;

    self.zugmaulIndex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ZugmaulVisible#zugmaulIndex"));
	self.oberlenkerIndex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ZugmaulVisible#oberlenkerIndex"));
	self.ackerschieneIndex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ZugmaulVisible#ackerschieneIndex"));

	self:setZvState(0);
end;
function ZugmaulVisibility:delete()
end;
function ZugmaulVisibility:mouseEvent(posX, posY, isDown, isUp, button)
end;
function ZugmaulVisibility:keyEvent(unicode, sym, modifier, isDown)   
end;
function ZugmaulVisibility:attachImplement(implement)
	local attacherIndex = implement.jointDescIndex;
	if attacherIndex == 1 then
		self:setZvState(1);
	end;
end;
function ZugmaulVisibility:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local attacherIndex = implement.jointDescIndex;
    if attacherIndex == 1 then
		self:setZvState(0)
	end;
end;
function ZugmaulVisibility:setZvState(currentState)
	if currentState == 0 then
		setVisibility(self.zugmaulIndex, true);
		setVisibility(self.oberlenkerIndex, false);
		setVisibility(self.ackerschieneIndex, true);
	elseif currentState == 1 then
		setVisibility(self.zugmaulIndex, false);
		setVisibility(self.oberlenkerIndex, true);
		setVisibility(self.ackerschieneIndex, false);
	end;
end;

function ZugmaulVisibility:update(dt)

end;
function ZugmaulVisibility:draw()
end;
function ZugmaulVisibility:onLeave()
end;
