--
-- HH_animation
-- Specialization for FH
--
-- @author  Manuel Leithner
-- @date  29/12/09
-- @edit by diekuh
-- @editdate 10/11/10

HH_animation = {};

function HH_animation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function HH_animation:load(xmlFile)
	-- Defines attributes of backHydraulic
	self.backHydraulic = {};
	self.backHydraulic.rootArmFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArmFixPoint"));
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.rootArmPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArmPart"));
	self.backHydraulic.armFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#armFixPoint"));
	self.backHydraulic.rootArmPartFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArmPartFixPoint"));
	ax, ay, az = getWorldTranslation(self.backHydraulic.rootArmPart);
    bx, by, bz = getWorldTranslation(self.backHydraulic.rootArmPartFixPoint);
    self.backHydraulic.rootArmDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
end;

function HH_animation:delete()
end;

function HH_animation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HH_animation:keyEvent(unicode, sym, modifier, isDown)
end;

function HH_animation:update(dt)
	if self:getIsActive() then
		-- oriented all hydraulicparts towards the right place
		if self.backHydraulic ~= nil then
			-- set correct rotation on rootArm
			local x, y, z = getRotation(getParent(getParent(self.backHydraulic.armFixPoint)));
			setRotation(self.backHydraulic.rootArm, x, y, z);	

			-- oriented rootArmPart towards a fixpoint on the bottomArm
			local ax, ay, az = getWorldTranslation(self.backHydraulic.rootArmPart);
			local bx, by, bz = getWorldTranslation(self.backHydraulic.armFixPoint);
			x, y, z = worldDirectionToLocal(getParent(self.backHydraulic.rootArmPart), bx-ax, by-ay, bz-az);
			setDirection(self.backHydraulic.rootArmPart, x, y, z, 0, 0, 1);	
			
			-- scale the rootArmPart to get a better looking style (Do Not Copy This -> WORST implementation but "Yeah it works" ) :-)
			if self.backHydraulic.rootArmPart ~= nil then
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				local xScale, yScale, zScale = getScale(self.backHydraulic.rootArmPart);
				local newScale = zScale * (distance / self.backHydraulic.rootArmDistance);
				setScale(self.backHydraulic.rootArmPart, 1, 1, newScale);
			end;		
		end;	
	end;
end;

function HH_animation:draw()	
end;

function HH_animation:attachImplement(implement)
end;

function HH_animation:detachImplement(implementIndex)
end;

function HH_animation:validateAttacherJoint(implement, jointDesc, dt)
end;

function HH_animation:onLeave()
end;

function HH_animation:onEnter()
end;