TowBallSteering = {};

function TowBallSteering.prerequisitesPresent(specializations)
    return true;
end;

function TowBallSteering:load(xmlFile)
	self.attacherCylinder = {};
	self.attacherCylinder.leftCylinder = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinder"));
	self.attacherCylinder.leftPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinderPunch"));
	self.attacherCylinder.leftFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#leftZylinderFixPoint"));
	if self.attacherCylinder.leftPunch ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.leftPunch);
		local bx, by, bz = getWorldTranslation(self.attacherCylinder.leftFixPoint);
		self.attacherCylinder.leftDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;
	self.attacherCylinder.rightCylinder = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinder"));
	self.attacherCylinder.rightPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinderPunch"));
	self.attacherCylinder.rightFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallZylinder#rightZylinderFixPoint"));
	if self.attacherCylinder.rightPunch ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.rightPunch);
		local bx, by, bz = getWorldTranslation(self.attacherCylinder.rightFixPoint);
		self.attacherCylinder.rightDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;
	self.towBallAngle = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.towBallAngle#index"));
end;

function TowBallSteering:delete()
end;

function TowBallSteering:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TowBallSteering:keyEvent(unicode, sym, modifier, isDown)
end;

function TowBallSteering:update(dt)

	if self.leftFixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.leftCylinder);
		local bx, by, bz = getWorldTranslation(self.leftFixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.attacherCylinder.leftCylinder), bx-ax, by-ay, bz-az);
		setDirection(self.attacherCylinder.leftCylinder, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.attacherCylinder.leftDistance ~= nil then
			setTranslation(self.attacherCylinder.leftPunch, 0, 0, distance-self.attacherCylinder.leftDistance);
		end;
	end;
	if self.rightFixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(self.attacherCylinder.rightCylinder);
		local bx, by, bz = getWorldTranslation(self.rightFixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.attacherCylinder.rightCylinder), bx-ax, by-ay, bz-az);
		setDirection(self.attacherCylinder.rightCylinder, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.attacherCylinder.rightDistance ~= nil then
			setTranslation(self.attacherCylinder.rightPunch, 0, 0, distance-self.attacherCylinder.rightDistance);
		end;
	end;
	
	local steeringAxleAngle = 0;
	if self.attacherVehicle ~= nil then
		local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
		local dot = z;
		dot = dot / Utils.vector2Length(x,z);
		local angle = math.acos(dot);
		if x > 0 then
			angle = -angle;
		end;
		steeringAxleAngle = -angle*0.6;
	end;
	self.steeringAxleAngle = steeringAxleAngle;
	
	if self:getIsActive() then	
		if self.lastSteeringAxleAngle ~= steeringAxleAngle then
			self.lastSteeringAxleAngle = steeringAxleAngle;
			for k, part in pairs(self.movingParts) do
				part.isDirty = true;
			end;			
		end;
	end;
end;

function TowBallSteering:updateTick(dt)

	local steeringAxleAngle = 0;
	if self.attacherVehicle ~= nil then
		local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
		local dot = z;
		dot = dot / Utils.vector2Length(x,z);
		local angle = math.acos(dot);
		if x > 0 then
			angle = -angle;
		end;
		steeringAxleAngle = -angle*0.6;
	end;
	setRotation(self.towBallAngle, 0, steeringAxleAngle, 0);

end;

function TowBallSteering:draw()
end;

function TowBallSteering:onAttach(attacherVehicle)
end;

function TowBallSteering:onDetach()
	setVisibility(self.attachedVisibility, false);
	setVisibility(self.detachedVisibility, true);
	if self.firstTimeRun and self.updateWheels and self.isServer then
		for i=1, table.getn(self.wheels) do
			local wheel = self.wheels[i];
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 50, wheel.steeringAngle);
		end;
	end;
end;